/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class FileStorProducer
implements StorFilestorConfig.Producer {
    private final Integer numThreads;
    private final ContentCluster cluster;
    private final int reponseNumThreads;
    private final StorFilestorConfig.Response_sequencer_type.Enum responseSequencerType;
    private final StorFilestorConfig.Async_operation_throttler_type.Enum asyncOperationThrottlerType;
    private final boolean useAsyncMessageHandlingOnSchedule;
    private final boolean asyncApplyBucketDiff;

    private static StorFilestorConfig.Response_sequencer_type.Enum convertResponseSequencerType(String sequencerType) {
        try {
            return StorFilestorConfig.Response_sequencer_type.Enum.valueOf((String)sequencerType);
        }
        catch (Throwable t) {
            return StorFilestorConfig.Response_sequencer_type.Enum.ADAPTIVE;
        }
    }

    private static StorFilestorConfig.Async_operation_throttler_type.Enum toAsyncOperationThrottlerType(String throttlerType) {
        try {
            return StorFilestorConfig.Async_operation_throttler_type.Enum.valueOf((String)throttlerType);
        }
        catch (Throwable t) {
            return StorFilestorConfig.Async_operation_throttler_type.UNLIMITED;
        }
    }

    public FileStorProducer(ModelContext.FeatureFlags featureFlags, ContentCluster parent, Integer numThreads) {
        this.numThreads = numThreads;
        this.cluster = parent;
        this.reponseNumThreads = featureFlags.defaultNumResponseThreads();
        this.responseSequencerType = FileStorProducer.convertResponseSequencerType(featureFlags.responseSequencerType());
        this.asyncOperationThrottlerType = FileStorProducer.toAsyncOperationThrottlerType(featureFlags.persistenceAsyncThrottling());
        this.useAsyncMessageHandlingOnSchedule = featureFlags.useAsyncMessageHandlingOnSchedule();
        this.asyncApplyBucketDiff = featureFlags.asyncApplyBucketDiff();
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        if (this.numThreads != null) {
            builder.num_threads(this.numThreads.intValue());
        }
        builder.enable_multibit_split_optimalization(this.cluster.getPersistence().enableMultiLevelSplitting());
        builder.num_response_threads(this.reponseNumThreads);
        builder.response_sequencer_type(this.responseSequencerType);
        builder.use_async_message_handling_on_schedule(this.useAsyncMessageHandlingOnSchedule);
        builder.async_apply_bucket_diff(this.asyncApplyBucketDiff);
        builder.async_operation_throttler_type(this.asyncOperationThrottlerType);
    }

    public static class Builder {
        protected FileStorProducer build(ModelContext.Properties properties, ContentCluster parent, ModelElement clusterElem) {
            return new FileStorProducer(properties.featureFlags(), parent, this.getThreads(clusterElem));
        }

        private Integer getThreads(ModelElement clusterElem) {
            ModelElement tuning = clusterElem.child("tuning");
            if (tuning == null) {
                return null;
            }
            ModelElement threads = tuning.child("persistence-threads");
            if (threads == null) {
                return null;
            }
            Integer count = threads.integerAttribute("count");
            if (count != null) {
                return count;
            }
            int numThreads = 0;
            for (ModelElement thread : threads.subElements("thread")) {
                count = thread.integerAttribute("count");
                numThreads += count == null ? 1 : count;
            }
            return numThreads;
        }
    }
}

