/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.SystemName;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class QuotaValidator
extends Validator {
    private static final Logger log = Logger.getLogger(QuotaValidator.class.getName());
    private static final Capacity zeroCapacity = Capacity.from((ClusterResources)new ClusterResources(0, 0, NodeResources.zero()));

    @Override
    public void validate(VespaModel model, DeployState deployState) {
        Quota quota = deployState.getProperties().quota();
        quota.maxClusterSize().ifPresent(maxClusterSize -> this.validateMaxClusterSize((int)maxClusterSize, model));
        quota.budgetAsDecimal().ifPresent(budget -> this.validateBudget((BigDecimal)budget, model, deployState.getProperties().zone().system()));
    }

    private void validateBudget(BigDecimal budget, VespaModel model, SystemName systemName) {
        double maxSpend = model.allClusters().stream().filter(id -> !this.adminClusterIds(model).contains(id)).map(id -> model.provisioned().all().getOrDefault(id, zeroCapacity)).mapToDouble(c -> c.maxResources().cost()).sum();
        double actualSpend = model.allocatedHosts().getHosts().stream().filter(hostSpec -> ((ClusterMembership)hostSpec.membership().get()).cluster().type() != ClusterSpec.Type.admin).mapToDouble(hostSpec -> hostSpec.advertisedResources().cost()).sum();
        if (Math.abs(actualSpend) < 0.01) {
            log.warning("Deploying application " + model.applicationPackage().getApplicationId() + " with zero budget use.  This is suspicious, but not blocked");
            return;
        }
        this.throwIfBudgetNegative(actualSpend, budget, systemName);
        this.throwIfBudgetExceeded(actualSpend, budget, systemName);
        this.throwIfBudgetExceeded(maxSpend, budget, systemName);
    }

    private Set<ClusterSpec.Id> adminClusterIds(VespaModel model) {
        return model.allocatedHosts().getHosts().stream().map(hostSpec -> ((ClusterMembership)hostSpec.membership().orElseThrow()).cluster()).filter(cluster -> cluster.type() == ClusterSpec.Type.admin).map(ClusterSpec::id).collect(Collectors.toUnmodifiableSet());
    }

    private void validateMaxClusterSize(int maxClusterSize, VespaModel model) {
        List invalidClusters = model.provisioned().all().entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> {
            Capacity cluster = (Capacity)entry.getValue();
            int clusterSize = cluster.maxResources().nodes();
            return clusterSize > maxClusterSize;
        }).map(Map.Entry::getKey).map(ClusterSpec.Id::value).collect(Collectors.toList());
        if (!invalidClusters.isEmpty()) {
            String clusterNames = String.join((CharSequence)", ", invalidClusters);
            throw new IllegalArgumentException("Clusters " + clusterNames + " exceeded max cluster size of " + maxClusterSize);
        }
    }

    private void throwIfBudgetNegative(double spend, BigDecimal budget, SystemName systemName) {
        if (budget.doubleValue() < 0.0) {
            this.throwBudgetException("Please free up some capacity! This deployment's quota use is ($%.2f) and reserved quota is below zero! ($%.2f)", spend, budget, systemName);
        }
    }

    private void throwIfBudgetExceeded(double spend, BigDecimal budget, SystemName systemName) {
        if (budget.doubleValue() < spend) {
            throw new IllegalArgumentException((String)(systemName.equals((Object)SystemName.Public) ? "" : systemName.value() + ": ") + "Deployment would make your tenant exceed its quota and has been blocked!  Please contact support to update your plan.");
        }
    }

    private void throwBudgetException(String formatMessage, double spend, BigDecimal budget, SystemName systemName) {
        String message = String.format(Locale.US, formatMessage, spend, budget);
        String messageWithSystem = (String)(systemName.equals((Object)SystemName.Public) ? "" : systemName.value() + ": ") + message;
        throw new IllegalArgumentException(messageWithSystem);
    }
}

