/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.LargeRankExpressions;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.OnnxModels;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.RawRankProfile;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;

public class RankProfileList
extends Derived
implements RankProfilesConfig.Producer {
    private static final Logger log = Logger.getLogger(RankProfileList.class.getName());
    private final Map<String, RawRankProfile> rankProfiles = new LinkedHashMap<String, RawRankProfile>();
    private final RankingConstants rankingConstants;
    private final LargeRankExpressions largeRankExpressions;
    private final OnnxModels onnxModels;
    public static RankProfileList empty = new RankProfileList();

    private RankProfileList() {
        this.rankingConstants = new RankingConstants(null, Optional.empty());
        this.largeRankExpressions = new LargeRankExpressions(null);
        this.onnxModels = new OnnxModels(null, Optional.empty());
    }

    public RankProfileList(Schema schema, RankingConstants rankingConstants, LargeRankExpressions largeRankExpressions, OnnxModels onnxModels, AttributeFields attributeFields, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, ModelContext.Properties deployProperties, ExecutorService executor) {
        this.setName(schema == null ? "default" : schema.getName());
        this.rankingConstants = rankingConstants;
        this.largeRankExpressions = largeRankExpressions;
        this.onnxModels = onnxModels;
        this.deriveRankProfiles(rankProfileRegistry, queryProfiles, importedModels, schema, attributeFields, deployProperties, executor);
    }

    private boolean areDependenciesReady(RankProfile rank, RankProfileRegistry registry) {
        return rank.getInheritedName() == null || this.rankProfiles.containsKey(rank.getInheritedName()) || rank.getSearch() != null && registry.resolve(rank.getSearch().getDocument(), rank.getInheritedName()) != null;
    }

    private void deriveRankProfiles(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, Schema schema, AttributeFields attributeFields, ModelContext.Properties deployProperties, ExecutorService executor) {
        if (schema != null) {
            RawRankProfile rawRank = new RawRankProfile(rankProfileRegistry.get(schema, "default"), this.largeRankExpressions, queryProfiles, importedModels, attributeFields, deployProperties);
            this.rankProfiles.put(rawRank.getName(), rawRank);
        }
        LinkedHashMap<String, RankProfile> remaining = new LinkedHashMap<String, RankProfile>();
        rankProfileRegistry.rankProfilesOf(schema).forEach(rank -> remaining.put(rank.getName(), (RankProfile)rank));
        remaining.remove("default");
        while (!remaining.isEmpty()) {
            ArrayList<RankProfile> ready = new ArrayList<RankProfile>();
            remaining.forEach((name, rank) -> {
                if (this.areDependenciesReady((RankProfile)rank, rankProfileRegistry)) {
                    ready.add((RankProfile)rank);
                }
            });
            this.processRankProfiles(ready, queryProfiles, importedModels, schema, attributeFields, deployProperties, executor);
            ready.forEach(rank -> remaining.remove(rank.getName()));
        }
    }

    private void processRankProfiles(List<RankProfile> ready, QueryProfileRegistry queryProfiles, ImportedMlModels importedModels, Schema schema, AttributeFields attributeFields, ModelContext.Properties deployProperties, ExecutorService executor) {
        LinkedHashMap<String, Future<RawRankProfile>> futureRawRankProfiles = new LinkedHashMap<String, Future<RawRankProfile>>();
        for (RankProfile rank : ready) {
            if (schema == null) {
                this.onnxModels.add(rank.onnxModels());
            }
            futureRawRankProfiles.put(rank.getName(), executor.submit(() -> new RawRankProfile(rank, this.largeRankExpressions, queryProfiles, importedModels, attributeFields, deployProperties)));
        }
        try {
            for (Future rawFuture : futureRawRankProfiles.values()) {
                RawRankProfile rawRank = (RawRankProfile)rawFuture.get();
                this.rankProfiles.put(rawRank.getName(), rawRank);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public OnnxModels getOnnxModels() {
        return this.onnxModels;
    }

    public Map<String, RawRankProfile> getRankProfiles() {
        return this.rankProfiles;
    }

    public RawRankProfile getRankProfile(String name) {
        return this.rankProfiles.get(name);
    }

    @Override
    public String getDerivedName() {
        return "rank-profiles";
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        for (RawRankProfile rank : this.rankProfiles.values()) {
            rank.getConfig(builder);
        }
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        this.largeRankExpressions.asMap().values().forEach(expr -> builder.expression.add(new RankingExpressionsConfig.Expression.Builder().name(expr.getName()).fileref(expr.getFileReference())));
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        for (RankingConstant constant : this.rankingConstants.asMap().values()) {
            if ("".equals(constant.getFileReference())) {
                log.warning("Illegal file reference " + constant);
                continue;
            }
            builder.constant(new RankingConstantsConfig.Constant.Builder().name(constant.getName()).fileref(constant.getFileReference()).type(constant.getType()));
        }
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        for (OnnxModel model : this.onnxModels.asMap().values()) {
            if ("".equals(model.getFileReference())) {
                log.warning("Illegal file reference " + model);
                continue;
            }
            OnnxModelsConfig.Model.Builder modelBuilder = new OnnxModelsConfig.Model.Builder();
            modelBuilder.dry_run_on_setup(true);
            modelBuilder.name(model.getName());
            modelBuilder.fileref(model.getFileReference());
            model.getInputMap().forEach((name, source) -> modelBuilder.input(new OnnxModelsConfig.Model.Input.Builder().name(name).source(source)));
            model.getOutputMap().forEach((name, as) -> modelBuilder.output(new OnnxModelsConfig.Model.Output.Builder().name(name).as(as)));
            if (model.getStatelessExecutionMode().isPresent()) {
                modelBuilder.stateless_execution_mode(model.getStatelessExecutionMode().get());
            }
            if (model.getStatelessInterOpThreads().isPresent()) {
                modelBuilder.stateless_interop_threads(model.getStatelessInterOpThreads().get().intValue());
            }
            if (model.getStatelessIntraOpThreads().isPresent()) {
                modelBuilder.stateless_intraop_threads(model.getStatelessIntraOpThreads().get().intValue());
            }
            builder.model(modelBuilder);
        }
    }
}

