/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.searchdefinition.document.Case;
import com.yahoo.searchdefinition.document.Dictionary;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;

public class DictionaryOperation
implements FieldOperation {
    private final Operation operation;

    public DictionaryOperation(Operation type) {
        this.operation = type;
    }

    @Override
    public void apply(SDField field) {
        Dictionary dictionary = field.getOrSetDictionary();
        switch (this.operation) {
            case HASH: {
                dictionary.updateType(Dictionary.Type.HASH);
                break;
            }
            case BTREE: {
                dictionary.updateType(Dictionary.Type.BTREE);
                break;
            }
            case CASED: {
                dictionary.updateMatch(Case.CASED);
                break;
            }
            case UNCASED: {
                dictionary.updateMatch(Case.UNCASED);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled operation " + this.operation);
            }
        }
    }

    public static enum Operation {
        HASH,
        BTREE,
        CASED,
        UNCASED;

    }
}

