/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.GeoPos;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VsmSummary
extends Derived
implements VsmsummaryConfig.Producer {
    private final Map<SummaryField, List<String>> summaryMap = new LinkedHashMap<SummaryField, List<String>>(1);

    public VsmSummary(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        this.derive(schema, schema.getSummary("default"));
    }

    private void derive(Schema schema, DocumentSummary documentSummary) {
        if (documentSummary == null) {
            return;
        }
        for (SummaryField summaryField : documentSummary.getSummaryFields().values()) {
            List<String> from = this.toStringList(summaryField.sourceIterator());
            if (!this.doMapField(schema, summaryField)) continue;
            SDField sdField = schema.getConcreteField(summaryField.getName());
            if (sdField != null && GeoPos.isPos(sdField)) {
                this.summaryMap.put(summaryField, Collections.singletonList(summaryField.getName()));
                continue;
            }
            this.summaryMap.put(summaryField, from);
        }
    }

    private boolean doMapField(Schema schema, SummaryField summaryField) {
        SDField sdField = schema.getConcreteField(summaryField.getName());
        SDDocumentType document = schema.getDocument();
        if (sdField == null || document != null && document.getField(summaryField.getName()) == sdField) {
            return true;
        }
        if (summaryField.getVsmCommand().equals((Object)SummaryField.VsmCommand.FLATTENJUNIPER)) {
            return true;
        }
        if (!sdField.usesStructOrMap()) {
            return !sdField.getName().equals(summaryField.getName());
        }
        if (summaryField.getSourceCount() == sdField.getStructFields().size()) {
            for (SummaryField.Source source : summaryField.getSources()) {
                if (!sdField.getStructFields().contains(new SDField(schema.getDocument(), source.getName(), sdField.getDataType()))) {
                    return true;
                }
                if (sdField.getStructField(source.getName()) == null || sdField.getStructField(source.getName()).doesSummarying()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private List<String> toStringList(Iterator<SummaryField.Source> i) {
        ArrayList<String> ret = new ArrayList<String>();
        while (i.hasNext()) {
            ret.add(i.next().getName());
        }
        return ret;
    }

    @Override
    public String getDerivedName() {
        return "vsmsummary";
    }

    public void getConfig(VsmsummaryConfig.Builder vB) {
        for (Map.Entry<SummaryField, List<String>> entry : this.summaryMap.entrySet()) {
            VsmsummaryConfig.Fieldmap.Builder fmB = new VsmsummaryConfig.Fieldmap.Builder().summary(entry.getKey().getName());
            for (String field : entry.getValue()) {
                fmB.document(new VsmsummaryConfig.Fieldmap.Document.Builder().field(field));
            }
            fmB.command(VsmsummaryConfig.Fieldmap.Command.Enum.valueOf((String)entry.getKey().getVsmCommand().toString()));
            vB.fieldmap(fmB);
        }
    }
}

