/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.searchlib.TranslogserverConfig;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.config.content.core.StorBucketmoverConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;
import com.yahoo.vespa.model.search.NodeResourcesTuning;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchInterface;
import com.yahoo.vespa.model.search.TransactionLogServer;
import com.yahoo.vespa.model.search.Tuning;
import java.util.HashMap;
import java.util.Optional;
import org.w3c.dom.Element;

@RestartConfigs(value={ProtonConfig.class, MetricsmanagerConfig.class, TranslogserverConfig.class, StorFilestorConfig.class, StorBucketmoverConfig.class, StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class, LoadTypeConfig.class})
public class SearchNode
extends AbstractService
implements SearchInterface,
ProtonConfig.Producer,
FiledistributorrpcConfig.Producer,
MetricsmanagerConfig.Producer,
TranslogserverConfig.Producer {
    private static final int RPC_PORT = 0;
    private static final int UNUSED_1 = 1;
    private static final int UNUSED_2 = 2;
    private static final int UNUSED_3 = 3;
    private static final int HEALTH_PORT = 4;
    private final boolean isHostedVespa;
    private final boolean flushOnShutdown;
    private NodeSpec nodeSpec;
    private int distributionKey;
    private final String clusterName;
    private TransactionLogServer tls;
    private AbstractService serviceLayerService;
    private final Optional<Tuning> tuning;
    private final Optional<ResourceLimits> resourceLimits;
    private final double fractionOfMemoryReserved;
    private final double tlsSizeFraction;

    public static SearchNode create(AbstractConfigProducer parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Optional<Tuning> tuning, Optional<ResourceLimits> resourceLimits, boolean isHostedVespa, double fractionOfMemoryReserved, double tlsSizeFraction) {
        return new SearchNode(parent, name, distributionKey, nodeSpec, clusterName, serviceLayerService, flushOnShutdown, tuning, resourceLimits, isHostedVespa, fractionOfMemoryReserved, tlsSizeFraction);
    }

    private SearchNode(AbstractConfigProducer parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Optional<Tuning> tuning, Optional<ResourceLimits> resourceLimits, boolean isHostedVespa, double fractionOfMemoryReserved, double tlsSizeFraction) {
        this(parent, name, nodeSpec, clusterName, flushOnShutdown, tuning, resourceLimits, isHostedVespa, fractionOfMemoryReserved, tlsSizeFraction);
        this.distributionKey = distributionKey;
        this.serviceLayerService = serviceLayerService;
        this.setPropertiesElastic(clusterName, distributionKey);
    }

    private SearchNode(AbstractConfigProducer parent, String name, NodeSpec nodeSpec, String clusterName, boolean flushOnShutdown, Optional<Tuning> tuning, Optional<ResourceLimits> resourceLimits, boolean isHostedVespa, double fractionOfMemoryReserved, double tlsSizeFraction) {
        super(parent, name);
        this.setOmpNumThreads(1);
        this.isHostedVespa = isHostedVespa;
        this.fractionOfMemoryReserved = fractionOfMemoryReserved;
        this.tlsSizeFraction = tlsSizeFraction;
        this.nodeSpec = nodeSpec;
        this.clusterName = clusterName;
        this.flushOnShutdown = flushOnShutdown;
        this.portsMeta.on(0).tag("rpc").tag("rtc").tag("admin").tag("status");
        this.portsMeta.on(1).tag("unused");
        this.portsMeta.on(2).tag("unused");
        this.portsMeta.on(3).tag("unused");
        this.portsMeta.on(4).tag("http").tag("json").tag("health").tag("state");
        this.tuning = tuning;
        this.resourceLimits = resourceLimits;
    }

    private void setPropertiesElastic(String clusterName, int distributionKey) {
        this.setProp("index", distributionKey).setProp("clustertype", "search").setProp("clustername", clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private String getClusterConfigId() {
        return this.getParent().getConfigId();
    }

    private String getBaseDir() {
        return Defaults.getDefaults().underVespaHome("var/db/vespa/search/cluster." + this.getClusterName()) + "/n" + this.distributionKey;
    }

    @Override
    public NodeSpec getNodeSpec() {
        return this.nodeSpec;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        from.allocatePort("rpc");
        from.allocatePort("unused/1");
        from.allocatePort("unused/2");
        from.allocatePort("unused/3");
        from.allocatePort("health");
    }

    @Override
    public int getPortCount() {
        return 5;
    }

    public int getRpcPort() {
        return this.getRelativePort(0);
    }

    @Override
    public int getHealthPort() {
        return this.getHttpPort();
    }

    @Override
    public String getServiceType() {
        return "searchnode";
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    private int getHttpPort() {
        return this.getRelativePort(4);
    }

    public void getConfig(TranslogserverConfig.Builder builder) {
        Optional<NodeResources> nodeResources = this.getSpecifiedNodeResources();
        if (nodeResources.isPresent() && nodeResources.get().storageType() == NodeResources.StorageType.remote) {
            builder.usefsync(false);
        }
        this.tls.getConfig(builder);
    }

    @Override
    public String toString() {
        return this.getHostName();
    }

    private TransactionLogServer getTransactionLogServer() {
        return this.tls;
    }

    public void setTls(TransactionLogServer tls) {
        this.tls = tls;
    }

    public AbstractService getServiceLayerService() {
        return this.serviceLayerService;
    }

    @Override
    public String getStartupCommand() {
        if (this.getOmpNumThreads() != 1) {
            throw new IllegalStateException("ompNumThreads must be 1");
        }
        String startup = this.getEnvVariables() + "exec $ROOT/sbin/vespa-proton --identity " + this.getConfigId();
        if (this.serviceLayerService != null) {
            startup = startup + " --serviceidentity " + this.serviceLayerService.getConfigId();
        }
        return startup;
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        FileDistributionConfigProducer fileDistribution = this.getRoot().getFileDistributionConfigProducer();
        if (fileDistribution != null) {
            FileDistributionConfigProvider configProducer = fileDistribution.getConfigProducer(this.getHost().getHost());
            configProducer.getConfig(builder);
        }
    }

    public void getConfig(ProtonConfig.Builder builder) {
        Optional<NodeResources> nodeResources;
        builder.rpcport(this.getRpcPort()).httpport(this.getHttpPort()).clustername(this.getClusterName()).basedir(this.getBaseDir()).tlsspec("tcp/" + this.getHost().getHostname() + ":" + this.getTransactionLogServer().getTlsPort()).tlsconfigid(this.getConfigId()).slobrokconfigid(this.getClusterConfigId()).routingconfigid(this.getClusterConfigId()).distributionkey(this.getDistributionKey());
        if (this.isHostedVespa) {
            builder.pruneremoveddocumentsage(349260.0);
        }
        if ((nodeResources = this.getSpecifiedNodeResources()).isPresent()) {
            NodeResourcesTuning nodeResourcesTuning = new NodeResourcesTuning(nodeResources.get(), this.tuning.map(Tuning::threadsPerSearch).orElse(1), this.fractionOfMemoryReserved, this.tlsSizeFraction);
            nodeResourcesTuning.getConfig(builder);
            this.tuning.ifPresent(t -> t.getConfig(builder));
            this.resourceLimits.ifPresent(l -> l.getConfig(builder));
        }
    }

    private Optional<NodeResources> getSpecifiedNodeResources() {
        return this.getHostResource() != null ? this.getHostResource().realResources().asOptional() : Optional.empty();
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        Monitoring point = this.getMonitoringService();
        if (point != null) {
            builder.snapshot(new MetricsmanagerConfig.Snapshot.Builder().periods(point.getIntervalSeconds()).periods(Integer.valueOf(300)));
        }
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("log").tags("logdefault"));
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        if (this.flushOnShutdown) {
            int port = this.getRpcPort();
            String cmd = Defaults.getDefaults().underVespaHome("bin/vespa-proton-cmd ") + port + " prepareRestart";
            return Optional.of(cmd);
        }
        return Optional.empty();
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<SearchNode> {
        private final String name;
        private final NodeSpec nodeSpec;
        private final String clusterName;
        private final ContentNode contentNode;
        private final boolean flushOnShutdown;
        private final Optional<Tuning> tuning;
        private final Optional<ResourceLimits> resourceLimits;
        private final double fractionOfMemoryReserved;

        public Builder(String name, NodeSpec nodeSpec, String clusterName, ContentNode node, boolean flushOnShutdown, Optional<Tuning> tuning, Optional<ResourceLimits> resourceLimits, double fractionOfMemoryReserved) {
            this.name = name;
            this.nodeSpec = nodeSpec;
            this.clusterName = clusterName;
            this.contentNode = node;
            this.flushOnShutdown = flushOnShutdown;
            this.tuning = tuning;
            this.resourceLimits = resourceLimits;
            this.fractionOfMemoryReserved = fractionOfMemoryReserved;
        }

        @Override
        protected SearchNode doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element producerSpec) {
            return new SearchNode(ancestor, this.name, this.contentNode.getDistributionKey(), this.nodeSpec, this.clusterName, this.contentNode, this.flushOnShutdown, this.tuning, this.resourceLimits, deployState.isHosted(), this.fractionOfMemoryReserved, deployState.featureFlags().tlsSizeFraction());
        }
    }
}

