/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.vespa.config.search.core.ProtonConfig;

public class NodeResourcesTuning
implements ProtonConfig.Producer {
    static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    private static final long MEMORY_COST_PER_DOCUMENT_STORE_ONLY = 46L;
    private final NodeResources resources;
    private final int threadsPerSearch;
    private final double fractionOfMemoryReserved;
    private final double tlsSizeFraction;
    public static final double reservedMemoryGb = 0.5;

    public NodeResourcesTuning(NodeResources resources, int threadsPerSearch, double fractionOfMemoryReserved, double tlsSizeFraction) {
        this.resources = resources;
        this.threadsPerSearch = threadsPerSearch;
        this.fractionOfMemoryReserved = fractionOfMemoryReserved;
        this.tlsSizeFraction = tlsSizeFraction;
    }

    public void getConfig(ProtonConfig.Builder builder) {
        this.setHwInfo(builder);
        this.tuneDiskWriteSpeed(builder);
        this.tuneRequestThreads(builder);
        this.tuneDocumentStoreMaxFileSize(builder.summary.log);
        this.tuneFlushStrategyMemoryLimits(builder.flush.memory);
        this.tuneFlushStrategyTlsSize(builder.flush.memory);
        this.tuneSummaryReadIo(builder.summary.read);
        this.tuneSummaryCache(builder.summary.cache);
        this.tuneSearchReadIo(builder.search.mmap);
        for (ProtonConfig.Documentdb.Builder dbb : builder.documentdb) {
            this.getConfig(dbb);
        }
    }

    private void getConfig(ProtonConfig.Documentdb.Builder builder) {
        ProtonConfig.Documentdb dbCfg = builder.build();
        if (dbCfg.mode() != ProtonConfig.Documentdb.Mode.Enum.INDEX) {
            long numDocs = (long)this.usableMemoryGb() * 0x40000000L / 46L;
            builder.allocation.initialnumdocs(numDocs);
        }
    }

    private void tuneSummaryCache(ProtonConfig.Summary.Cache.Builder builder) {
        long memoryLimitBytes = (long)(this.usableMemoryGb() * 0.05 * 1.073741824E9);
        builder.maxbytes(memoryLimitBytes);
    }

    private void setHwInfo(ProtonConfig.Builder builder) {
        builder.hwinfo.disk.shared(true);
        builder.hwinfo.cpu.cores((int)this.resources.vcpu());
        builder.hwinfo.memory.size((long)(this.usableMemoryGb() * 1.073741824E9));
        builder.hwinfo.disk.size((long)(this.resources.diskGb() * 1.073741824E9));
    }

    private void tuneDiskWriteSpeed(ProtonConfig.Builder builder) {
        if (this.resources.diskSpeed() != NodeResources.DiskSpeed.fast) {
            builder.hwinfo.disk.writespeed(40.0);
        }
    }

    private void tuneDocumentStoreMaxFileSize(ProtonConfig.Summary.Log.Builder builder) {
        double memoryGb = this.usableMemoryGb();
        long fileSizeBytes = 0x100000000L;
        if (memoryGb <= 12.0) {
            fileSizeBytes = 0x10000000L;
        } else if (memoryGb < 24.0) {
            fileSizeBytes = 0x20000000L;
        } else if (memoryGb <= 64.0) {
            fileSizeBytes = 0x40000000L;
        }
        builder.maxfilesize(fileSizeBytes);
    }

    private void tuneFlushStrategyMemoryLimits(ProtonConfig.Flush.Memory.Builder builder) {
        long memoryLimitBytes = (long)(this.usableMemoryGb() / 8.0 * 1.073741824E9);
        builder.maxmemory(memoryLimitBytes);
        builder.each.maxmemory(memoryLimitBytes);
    }

    private void tuneFlushStrategyTlsSize(ProtonConfig.Flush.Memory.Builder builder) {
        long tlsSizeBytes = (long)(this.resources.diskGb() * this.tlsSizeFraction * 1.073741824E9);
        tlsSizeBytes = Long.max(0x80000000L, Long.min(tlsSizeBytes, 0x1900000000L));
        builder.maxtlssize(tlsSizeBytes);
    }

    private void tuneSummaryReadIo(ProtonConfig.Summary.Read.Builder builder) {
        if (this.resources.diskSpeed() == NodeResources.DiskSpeed.fast) {
            builder.io(ProtonConfig.Summary.Read.Io.DIRECTIO);
        }
    }

    private void tuneSearchReadIo(ProtonConfig.Search.Mmap.Builder builder) {
        if (this.resources.diskSpeed() == NodeResources.DiskSpeed.fast) {
            builder.advise(ProtonConfig.Search.Mmap.Advise.RANDOM);
        }
    }

    private void tuneRequestThreads(ProtonConfig.Builder builder) {
        int numCores = (int)Math.ceil(this.resources.vcpu());
        builder.numsearcherthreads(numCores * this.threadsPerSearch);
        builder.numsummarythreads(numCores);
        builder.numthreadspersearch(this.threadsPerSearch);
    }

    private double usableMemoryGb() {
        double usableMemoryGb = this.resources.memoryGb() - 0.5;
        return usableMemoryGb * (1.0 - this.fractionOfMemoryReserved);
    }
}

