/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.search.AttributeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.DocumentTypeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.IndexingScriptChangeValidator;
import com.yahoo.vespa.model.application.validation.change.search.StructFieldAttributeChangeValidator;
import com.yahoo.vespa.model.search.DocumentDatabase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class DocumentDatabaseChangeValidator {
    private final ClusterSpec.Id id;
    private final DocumentDatabase currentDatabase;
    private final NewDocumentType currentDocType;
    private final DocumentDatabase nextDatabase;
    private final NewDocumentType nextDocType;
    private final ValidationOverrides overrides;
    private final Instant now;

    public DocumentDatabaseChangeValidator(ClusterSpec.Id id, DocumentDatabase currentDatabase, NewDocumentType currentDocType, DocumentDatabase nextDatabase, NewDocumentType nextDocType, ValidationOverrides overrides, Instant now) {
        this.id = id;
        this.currentDatabase = currentDatabase;
        this.currentDocType = currentDocType;
        this.nextDatabase = nextDatabase;
        this.nextDocType = nextDocType;
        this.overrides = overrides;
        this.now = now;
    }

    public List<VespaConfigChangeAction> validate() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAttributeChanges());
        result.addAll(this.validateStructFieldAttributeChanges());
        result.addAll(this.validateIndexingScriptChanges());
        result.addAll(this.validateDocumentTypeChanges());
        return result;
    }

    private List<VespaConfigChangeAction> validateAttributeChanges() {
        return new AttributeChangeValidator(this.id, this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.currentDatabase.getDerivedConfiguration().getIndexSchema(), this.currentDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDatabase.getDerivedConfiguration().getIndexSchema(), this.nextDocType, this.overrides, this.now).validate();
    }

    private List<VespaConfigChangeAction> validateStructFieldAttributeChanges() {
        return new StructFieldAttributeChangeValidator(this.id, this.currentDocType, this.currentDatabase.getDerivedConfiguration().getAttributeFields(), this.nextDocType, this.nextDatabase.getDerivedConfiguration().getAttributeFields()).validate();
    }

    private List<VespaConfigChangeAction> validateIndexingScriptChanges() {
        return new IndexingScriptChangeValidator(this.id, this.currentDatabase.getDerivedConfiguration().getSearch(), this.nextDatabase.getDerivedConfiguration().getSearch()).validate();
    }

    private List<VespaConfigChangeAction> validateDocumentTypeChanges() {
        return new DocumentTypeChangeValidator(this.id, this.currentDocType, this.nextDocType).validate();
    }
}

