/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.HashSet;

public class ValidateStructTypeInheritance
extends Processor {
    public ValidateStructTypeInheritance(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        this.verifyNoRedeclarations(this.schema.getDocument());
    }

    void fail(Field field, String message) {
        throw this.newProcessException(this.schema, field, message);
    }

    void verifyNoRedeclarations(SDDocumentType docType) {
        for (SDDocumentType type : docType.allTypes().values()) {
            if (!type.isStruct()) continue;
            ArrayList<SDDocumentType> inheritedTypes = new ArrayList<SDDocumentType>(type.getInheritedTypes());
            for (int i = 0; i < inheritedTypes.size(); ++i) {
                SDDocumentType inherit = inheritedTypes.get(i);
                for (SDDocumentType extra : inherit.getInheritedTypes()) {
                    if (inheritedTypes.contains(extra)) continue;
                    inheritedTypes.add(extra);
                }
            }
            if (inheritedTypes.isEmpty()) continue;
            HashSet<String> seenFieldNames = new HashSet<String>();
            for (Field field : type.getDocumentType().contentStruct().getFieldsThisTypeOnly()) {
                if (seenFieldNames.contains(field.getName())) {
                    this.fail(field, "struct " + type.getName() + " has multiple fields with same name: " + field.getName());
                }
                seenFieldNames.add(field.getName());
            }
            for (SDDocumentType inherit : inheritedTypes) {
                if (inherit.isStruct()) {
                    for (Field field : inherit.getDocumentType().contentStruct().getFieldsThisTypeOnly()) {
                        if (seenFieldNames.contains(field.getName())) {
                            this.fail(field, "struct " + type.getName() + " cannot inherit from " + inherit.getName() + " and redeclare field " + field.getName());
                        }
                        seenFieldNames.add(field.getName());
                    }
                    continue;
                }
                this.fail(new Field("no field"), "struct cannot inherit from non-struct " + inherit.getName() + " class " + inherit.getClass());
            }
        }
    }
}

