/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.multifieldresolver.IndexCommandResolver;
import com.yahoo.searchdefinition.processing.multifieldresolver.RankTypeResolver;
import com.yahoo.searchdefinition.processing.multifieldresolver.StemmingResolver;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultifieldIndexHarmonizer
extends Processor {
    private Map<String, List<SDField>> indexToFields = new HashMap<String, List<SDField>>();

    public MultifieldIndexHarmonizer(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.populateIndexToFields(this.schema);
        this.resolveAllConflicts(this.schema);
    }

    private void populateIndexToFields(Schema schema) {
        for (SDField field : schema.allConcreteFields()) {
            if (!field.doesIndexing()) continue;
            this.addIndexField(field.getName(), field);
        }
    }

    private void addIndexField(String indexName, SDField field) {
        List<SDField> fields = this.indexToFields.get(indexName);
        if (fields == null) {
            fields = new ArrayList<SDField>();
            this.indexToFields.put(indexName, fields);
        }
        fields.add(field);
    }

    private void resolveAllConflicts(Schema schema) {
        for (Map.Entry<String, List<SDField>> entry : this.indexToFields.entrySet()) {
            String indexName = entry.getKey();
            List<SDField> fields = entry.getValue();
            if (fields.size() == 1) continue;
            this.resolveConflicts(indexName, fields, schema);
        }
    }

    private void resolveConflicts(String indexName, List<SDField> fields, Schema schema) {
        new StemmingResolver(indexName, fields, schema, this.deployLogger).resolve();
        new IndexCommandResolver(indexName, fields, schema, this.deployLogger).resolve();
        new RankTypeResolver(indexName, fields, schema, this.deployLogger).resolve();
    }
}

