/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.TemporaryImportedField;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TemporaryImportedFields {
    private final Schema owner;
    private final Map<String, TemporaryImportedField> fields = new LinkedHashMap<String, TemporaryImportedField>();

    public TemporaryImportedFields(Schema owner) {
        this.owner = owner;
    }

    public void add(TemporaryImportedField importedField) {
        this.fields.put(importedField.fieldName(), importedField);
    }

    public boolean hasField(String fieldName) {
        boolean has;
        boolean bl = has = this.fields.get(fieldName) != null;
        if (has) {
            return true;
        }
        if (this.owner.inherited().isEmpty()) {
            return false;
        }
        if (this.owner.inherited().get().temporaryImportedFields().isEmpty()) {
            return false;
        }
        return this.owner.inherited().get().temporaryImportedFields().get().hasField(fieldName);
    }

    public Map<String, TemporaryImportedField> fields() {
        if (this.owner.inherited().isEmpty()) {
            return Collections.unmodifiableMap(this.fields);
        }
        if (this.owner.inherited().get().temporaryImportedFields().isEmpty()) {
            return Collections.unmodifiableMap(this.fields);
        }
        HashMap<String, TemporaryImportedField> allFields = new HashMap<String, TemporaryImportedField>(this.owner.inherited().get().temporaryImportedFields().get().fields());
        allFields.putAll(this.fields);
        return allFields;
    }
}

