/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.vespa.config.search.summary.JuniperrcConfig;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.LinkedHashSet;
import java.util.Set;

public class Juniperrc
extends Derived
implements JuniperrcConfig.Producer {
    private Set<String> boldingFields = new LinkedHashSet<String>();

    public Juniperrc(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        super.derive(schema);
        for (SummaryField summaryField : schema.getUniqueNamedSummaryFields().values()) {
            if (summaryField.getTransform() != SummaryTransform.BOLDED) continue;
            this.boldingFields.add(summaryField.getName());
        }
    }

    @Override
    protected String getDerivedName() {
        return "juniperrc";
    }

    public void getConfig(JuniperrcConfig.Builder builder) {
        if (this.boldingFields.size() != 0) {
            builder.prefix(true);
            for (String name : this.boldingFields) {
                builder.override(new JuniperrcConfig.Override.Builder().fieldname(name).length(65536).max_matches(1).min_length(8192).surround_max(65536));
            }
        }
    }
}

