/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.document.config.DocumenttypesConfig;
import com.yahoo.searchdefinition.SchemaBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.configmodel.producers.DocumentManager;
import com.yahoo.vespa.configmodel.producers.DocumentTypes;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class Deriver {
    public static SchemaBuilder getSearchBuilder(List<String> sds) {
        SchemaBuilder builder = new SchemaBuilder();
        try {
            for (String s : sds) {
                builder.importFile(s);
            }
        }
        catch (ParseException | IOException e) {
            throw new IllegalArgumentException(e);
        }
        builder.build();
        return builder;
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(String sd) {
        return Deriver.getDocumentManagerConfig(Collections.singletonList(sd));
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(List<String> sds) {
        return new DocumentManager().produce(Deriver.getSearchBuilder(sds).getModel(), new DocumentmanagerConfig.Builder());
    }

    public static DocumentmanagerConfig.Builder getDocumentManagerConfig(List<String> sds, boolean useV8DocManagerCfg) {
        return new DocumentManager().useV8DocManagerCfg(useV8DocManagerCfg).produce(Deriver.getSearchBuilder(sds).getModel(), new DocumentmanagerConfig.Builder());
    }

    public static DocumenttypesConfig.Builder getDocumentTypesConfig(String sd) {
        return Deriver.getDocumentTypesConfig(Collections.singletonList(sd));
    }

    public static DocumenttypesConfig.Builder getDocumentTypesConfig(List<String> sds) {
        return new DocumentTypes().produce(Deriver.getSearchBuilder(sds).getModel(), new DocumenttypesConfig.Builder());
    }
}

