/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.Schema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OnnxModels {
    private final FileRegistry fileRegistry;
    private final Optional<Schema> owner;
    private final Map<String, OnnxModel> models = new HashMap<String, OnnxModel>();

    public OnnxModels(FileRegistry fileRegistry, Optional<Schema> owner) {
        this.fileRegistry = fileRegistry;
        this.owner = owner;
    }

    public void add(OnnxModel model) {
        model.validate();
        model.register(this.fileRegistry);
        String name = model.getName();
        this.models.put(name, model);
    }

    public void add(Map<String, OnnxModel> models) {
        models.values().forEach(this::add);
    }

    public OnnxModel get(String name) {
        OnnxModel model = this.models.get(name);
        if (model != null) {
            return model;
        }
        if (this.owner.isPresent() && this.owner.get().inherited().isPresent()) {
            return this.owner.get().inherited().get().onnxModels().get(name);
        }
        return null;
    }

    public boolean has(String name) {
        boolean has = this.models.containsKey(name);
        if (has) {
            return true;
        }
        if (this.owner.isPresent() && this.owner.get().inherited().isPresent()) {
            return this.owner.get().inherited().get().onnxModels().has(name);
        }
        return false;
    }

    public Map<String, OnnxModel> asMap() {
        if (this.owner.isEmpty() || this.owner.get().inherited().isEmpty()) {
            return Collections.unmodifiableMap(this.models);
        }
        if (this.models.isEmpty()) {
            return this.owner.get().inherited().get().onnxModels().asMap();
        }
        HashMap<String, OnnxModel> allModels = new HashMap<String, OnnxModel>(this.owner.get().inherited().get().onnxModels().asMap());
        allModels.putAll(this.models);
        return Collections.unmodifiableMap(allModels);
    }
}

