/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TestProperties
implements ModelContext.Properties,
ModelContext.FeatureFlags {
    private boolean multitenant = false;
    private ApplicationId applicationId = ApplicationId.defaultId();
    private List<ConfigServerSpec> configServerSpecs = Collections.emptyList();
    private boolean hostedVespa = false;
    private Zone zone;
    private final Set<ContainerEndpoint> endpoints = Collections.emptySet();
    private boolean useDedicatedNodeForLogserver = false;
    private boolean useThreePhaseUpdates = false;
    private double defaultTermwiseLimit = 1.0;
    private String jvmGCOptions = null;
    private String sequencerType = "LATENCY";
    private int feedTaskLimit = 1000;
    private int feedMasterTaskLimit = 0;
    private String sharedFieldWriterExecutor = "NONE";
    private boolean firstTimeDeployment = false;
    private String responseSequencerType = "ADAPTIVE";
    private int responseNumThreads = 2;
    private Optional<EndpointCertificateSecrets> endpointCertificateSecrets = Optional.empty();
    private AthenzDomain athenzDomain;
    private Quota quota = Quota.unlimited();
    private boolean useAsyncMessageHandlingOnSchedule = false;
    private double feedConcurrency = 0.5;
    private boolean enableFeedBlockInDistributor = true;
    private int maxActivationInhibitedOutOfSyncGroups = 0;
    private List<TenantSecretStore> tenantSecretStores = Collections.emptyList();
    private String jvmOmitStackTraceInFastThrowOption;
    private int maxConcurrentMergesPerNode = 16;
    private int maxMergeQueueSize = 1024;
    private boolean ignoreMergeQueueLimit = false;
    private int largeRankExpressionLimit = 8192;
    private boolean allowDisableMtls = true;
    private List<X509Certificate> operatorCertificates = Collections.emptyList();
    private double resourceLimitDisk = 0.8;
    private double resourceLimitMemory = 0.8;
    private double minNodeRatioPerGroup = 0.0;
    private boolean containerDumpHeapOnShutdownTimeout = false;
    private double containerShutdownTimeout = 50.0;
    private int distributorMergeBusyWait = 10;
    private int docstoreCompressionLevel = 9;
    private int maxUnCommittedMemory = 123456;
    private double diskBloatFactor = 0.2;
    private boolean distributorEnhancedMaintenanceScheduling = false;
    private boolean asyncApplyBucketDiff = false;
    private boolean unorderedMergeChaining = false;
    private List<String> zoneDnsSuffixes = List.of();
    private int maxCompactBuffers = 1;
    private boolean failDeploymentWithInvalidJvmOptions = false;
    private double tlsSizeFraction = 0.07;

    public ModelContext.FeatureFlags featureFlags() {
        return this;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public List<ConfigServerSpec> configServerSpecs() {
        return this.configServerSpecs;
    }

    public HostName loadBalancerName() {
        return null;
    }

    public URI ztsUrl() {
        return null;
    }

    public String athenzDnsSuffix() {
        return null;
    }

    public boolean hostedVespa() {
        return this.hostedVespa;
    }

    public Zone zone() {
        return this.zone;
    }

    public Set<ContainerEndpoint> endpoints() {
        return this.endpoints;
    }

    public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
        return this.jvmGCOptions;
    }

    public String feedSequencerType() {
        return this.sequencerType;
    }

    public int feedTaskLimit() {
        return this.feedTaskLimit;
    }

    public int feedMasterTaskLimit() {
        return this.feedMasterTaskLimit;
    }

    public String sharedFieldWriterExecutor() {
        return this.sharedFieldWriterExecutor;
    }

    public boolean isBootstrap() {
        return false;
    }

    public boolean isFirstTimeDeployment() {
        return this.firstTimeDeployment;
    }

    public boolean useDedicatedNodeForLogserver() {
        return this.useDedicatedNodeForLogserver;
    }

    public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
        return this.endpointCertificateSecrets;
    }

    public double defaultTermwiseLimit() {
        return this.defaultTermwiseLimit;
    }

    public boolean useThreePhaseUpdates() {
        return this.useThreePhaseUpdates;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return Optional.ofNullable(this.athenzDomain);
    }

    public String responseSequencerType() {
        return this.responseSequencerType;
    }

    public int defaultNumResponseThreads() {
        return this.responseNumThreads;
    }

    public boolean skipCommunicationManagerThread() {
        return false;
    }

    public boolean skipMbusRequestThread() {
        return false;
    }

    public boolean skipMbusReplyThread() {
        return false;
    }

    public Quota quota() {
        return this.quota;
    }

    public boolean useAsyncMessageHandlingOnSchedule() {
        return this.useAsyncMessageHandlingOnSchedule;
    }

    public double feedConcurrency() {
        return this.feedConcurrency;
    }

    public boolean enableFeedBlockInDistributor() {
        return this.enableFeedBlockInDistributor;
    }

    public int maxActivationInhibitedOutOfSyncGroups() {
        return this.maxActivationInhibitedOutOfSyncGroups;
    }

    public List<TenantSecretStore> tenantSecretStores() {
        return this.tenantSecretStores;
    }

    public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
        return this.jvmOmitStackTraceInFastThrowOption;
    }

    public boolean allowDisableMtls() {
        return this.allowDisableMtls;
    }

    public List<X509Certificate> operatorCertificates() {
        return this.operatorCertificates;
    }

    public int largeRankExpressionLimit() {
        return this.largeRankExpressionLimit;
    }

    public int maxConcurrentMergesPerNode() {
        return this.maxConcurrentMergesPerNode;
    }

    public int maxMergeQueueSize() {
        return this.maxMergeQueueSize;
    }

    public boolean ignoreMergeQueueLimit() {
        return this.ignoreMergeQueueLimit;
    }

    public double resourceLimitDisk() {
        return this.resourceLimitDisk;
    }

    public double resourceLimitMemory() {
        return this.resourceLimitMemory;
    }

    public double minNodeRatioPerGroup() {
        return this.minNodeRatioPerGroup;
    }

    public int metricsproxyNumThreads() {
        return 1;
    }

    public double containerShutdownTimeout() {
        return this.containerShutdownTimeout;
    }

    public boolean containerDumpHeapOnShutdownTimeout() {
        return this.containerDumpHeapOnShutdownTimeout;
    }

    public int distributorMergeBusyWait() {
        return this.distributorMergeBusyWait;
    }

    public double diskBloatFactor() {
        return this.diskBloatFactor;
    }

    public int docstoreCompressionLevel() {
        return this.docstoreCompressionLevel;
    }

    public boolean distributorEnhancedMaintenanceScheduling() {
        return this.distributorEnhancedMaintenanceScheduling;
    }

    public int maxUnCommittedMemory() {
        return this.maxUnCommittedMemory;
    }

    public boolean asyncApplyBucketDiff() {
        return this.asyncApplyBucketDiff;
    }

    public boolean unorderedMergeChaining() {
        return this.unorderedMergeChaining;
    }

    public List<String> zoneDnsSuffixes() {
        return this.zoneDnsSuffixes;
    }

    public int maxCompactBuffers() {
        return this.maxCompactBuffers;
    }

    public boolean failDeploymentWithInvalidJvmOptions() {
        return this.failDeploymentWithInvalidJvmOptions;
    }

    public double tlsSizeFraction() {
        return this.tlsSizeFraction;
    }

    public TestProperties maxUnCommittedMemory(int maxUnCommittedMemory) {
        this.maxUnCommittedMemory = maxUnCommittedMemory;
        return this;
    }

    public TestProperties docstoreCompressionLevel(int docstoreCompressionLevel) {
        this.docstoreCompressionLevel = docstoreCompressionLevel;
        return this;
    }

    public TestProperties diskBloatFactor(double diskBloatFactor) {
        this.diskBloatFactor = diskBloatFactor;
        return this;
    }

    public TestProperties containerDumpHeapOnShutdownTimeout(boolean value) {
        this.containerDumpHeapOnShutdownTimeout = value;
        return this;
    }

    public TestProperties containerShutdownTimeout(double value) {
        this.containerShutdownTimeout = value;
        return this;
    }

    public TestProperties largeRankExpressionLimit(int value) {
        this.largeRankExpressionLimit = value;
        return this;
    }

    public TestProperties setFeedConcurrency(double feedConcurrency) {
        this.feedConcurrency = feedConcurrency;
        return this;
    }

    public TestProperties setAsyncMessageHandlingOnSchedule(boolean value) {
        this.useAsyncMessageHandlingOnSchedule = value;
        return this;
    }

    public TestProperties setJvmGCOptions(String gcOptions) {
        this.jvmGCOptions = gcOptions;
        return this;
    }

    public TestProperties setFeedSequencerType(String type) {
        this.sequencerType = type;
        return this;
    }

    public TestProperties setFeedTaskLimit(int value) {
        this.feedTaskLimit = value;
        return this;
    }

    public TestProperties setFeedMasterTaskLimit(int value) {
        this.feedMasterTaskLimit = value;
        return this;
    }

    public TestProperties setSharedFieldWriterExecutor(String value) {
        this.sharedFieldWriterExecutor = value;
        return this;
    }

    public TestProperties setResponseSequencerType(String type) {
        this.responseSequencerType = type;
        return this;
    }

    public TestProperties setFirstTimeDeployment(boolean firstTimeDeployment) {
        this.firstTimeDeployment = firstTimeDeployment;
        return this;
    }

    public TestProperties setResponseNumThreads(int numThreads) {
        this.responseNumThreads = numThreads;
        return this;
    }

    public TestProperties setMaxConcurrentMergesPerNode(int maxConcurrentMergesPerNode) {
        this.maxConcurrentMergesPerNode = maxConcurrentMergesPerNode;
        return this;
    }

    public TestProperties setMaxMergeQueueSize(int maxMergeQueueSize) {
        this.maxMergeQueueSize = maxMergeQueueSize;
        return this;
    }

    public TestProperties setIgnoreMergeQueueLimit(boolean ignoreMergeQueueLimit) {
        this.ignoreMergeQueueLimit = ignoreMergeQueueLimit;
        return this;
    }

    public TestProperties setDefaultTermwiseLimit(double limit) {
        this.defaultTermwiseLimit = limit;
        return this;
    }

    public TestProperties setUseThreePhaseUpdates(boolean useThreePhaseUpdates) {
        this.useThreePhaseUpdates = useThreePhaseUpdates;
        return this;
    }

    public TestProperties setApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public TestProperties setHostedVespa(boolean hostedVespa) {
        this.hostedVespa = hostedVespa;
        return this;
    }

    public TestProperties setMultitenant(boolean multitenant) {
        this.multitenant = multitenant;
        return this;
    }

    public TestProperties setConfigServerSpecs(List<Spec> configServerSpecs) {
        this.configServerSpecs = ImmutableList.copyOf(configServerSpecs);
        return this;
    }

    public TestProperties setUseDedicatedNodeForLogserver(boolean useDedicatedNodeForLogserver) {
        this.useDedicatedNodeForLogserver = useDedicatedNodeForLogserver;
        return this;
    }

    public TestProperties setEndpointCertificateSecrets(Optional<EndpointCertificateSecrets> endpointCertificateSecrets) {
        this.endpointCertificateSecrets = endpointCertificateSecrets;
        return this;
    }

    public TestProperties setZone(Zone zone) {
        this.zone = zone;
        return this;
    }

    public TestProperties setAthenzDomain(AthenzDomain domain) {
        this.athenzDomain = domain;
        return this;
    }

    public TestProperties setQuota(Quota quota) {
        this.quota = quota;
        return this;
    }

    public TestProperties enableFeedBlockInDistributor(boolean enabled) {
        this.enableFeedBlockInDistributor = enabled;
        return this;
    }

    public TestProperties maxActivationInhibitedOutOfSyncGroups(int nGroups) {
        this.maxActivationInhibitedOutOfSyncGroups = nGroups;
        return this;
    }

    public TestProperties setTenantSecretStores(List<TenantSecretStore> secretStores) {
        this.tenantSecretStores = List.copyOf(secretStores);
        return this;
    }

    public TestProperties setJvmOmitStackTraceInFastThrowOption(String value) {
        this.jvmOmitStackTraceInFastThrowOption = value;
        return this;
    }

    public TestProperties allowDisableMtls(boolean value) {
        this.allowDisableMtls = value;
        return this;
    }

    public TestProperties setOperatorCertificates(List<X509Certificate> operatorCertificates) {
        this.operatorCertificates = List.copyOf(operatorCertificates);
        return this;
    }

    public TestProperties setResourceLimitDisk(double value) {
        this.resourceLimitDisk = value;
        return this;
    }

    public TestProperties setResourceLimitMemory(double value) {
        this.resourceLimitMemory = value;
        return this;
    }

    public TestProperties setMinNodeRatioPerGroup(double value) {
        this.minNodeRatioPerGroup = value;
        return this;
    }

    public TestProperties setDistributorMergeBusyWait(int value) {
        this.distributorMergeBusyWait = value;
        return this;
    }

    public TestProperties distributorEnhancedMaintenanceScheduling(boolean enhancedScheduling) {
        this.distributorEnhancedMaintenanceScheduling = enhancedScheduling;
        return this;
    }

    public TestProperties setAsyncApplyBucketDiff(boolean value) {
        this.asyncApplyBucketDiff = value;
        return this;
    }

    public TestProperties setUnorderedMergeChaining(boolean unordered) {
        this.unorderedMergeChaining = unordered;
        return this;
    }

    public TestProperties setZoneDnsSuffixes(List<String> zoneDnsSuffixes) {
        this.zoneDnsSuffixes = List.copyOf(zoneDnsSuffixes);
        return this;
    }

    public TestProperties maxCompactBuffers(int maxCompactBuffers) {
        this.maxCompactBuffers = maxCompactBuffers;
        return this;
    }

    public TestProperties failDeploymentWithInvalidJvmOptions(boolean fail) {
        this.failDeploymentWithInvalidJvmOptions = fail;
        return this;
    }

    public TestProperties tlsSizeFraction(double tlsSizeFraction) {
        this.tlsSizeFraction = tlsSizeFraction;
        return this;
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

