/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.processing.AddAttributeTransformToSummaryOfImportedFields;
import com.yahoo.searchdefinition.processing.AddExtraFieldsToDocument;
import com.yahoo.searchdefinition.processing.AdjustPositionSummaryFields;
import com.yahoo.searchdefinition.processing.AttributeProperties;
import com.yahoo.searchdefinition.processing.AttributesImplicitWord;
import com.yahoo.searchdefinition.processing.Bolding;
import com.yahoo.searchdefinition.processing.BoolAttributeValidator;
import com.yahoo.searchdefinition.processing.BuiltInFieldSets;
import com.yahoo.searchdefinition.processing.CreatePositionZCurve;
import com.yahoo.searchdefinition.processing.DictionaryProcessor;
import com.yahoo.searchdefinition.processing.DisallowComplexMapAndWsetKeyTypes;
import com.yahoo.searchdefinition.processing.DiversitySettingsValidator;
import com.yahoo.searchdefinition.processing.ExactMatch;
import com.yahoo.searchdefinition.processing.FastAccessValidator;
import com.yahoo.searchdefinition.processing.FieldSetSettings;
import com.yahoo.searchdefinition.processing.FilterFieldNames;
import com.yahoo.searchdefinition.processing.ImplicitSummaries;
import com.yahoo.searchdefinition.processing.ImplicitSummaryFields;
import com.yahoo.searchdefinition.processing.ImportedFieldsResolver;
import com.yahoo.searchdefinition.processing.IndexFieldNames;
import com.yahoo.searchdefinition.processing.IndexingInputs;
import com.yahoo.searchdefinition.processing.IndexingOutputs;
import com.yahoo.searchdefinition.processing.IndexingValidation;
import com.yahoo.searchdefinition.processing.IndexingValues;
import com.yahoo.searchdefinition.processing.IntegerIndex2Attribute;
import com.yahoo.searchdefinition.processing.LiteralBoost;
import com.yahoo.searchdefinition.processing.MakeAliases;
import com.yahoo.searchdefinition.processing.MakeDefaultSummaryTheSuperSet;
import com.yahoo.searchdefinition.processing.MatchConsistency;
import com.yahoo.searchdefinition.processing.MatchPhaseSettingsValidator;
import com.yahoo.searchdefinition.processing.MatchedElementsOnlyResolver;
import com.yahoo.searchdefinition.processing.MultifieldIndexHarmonizer;
import com.yahoo.searchdefinition.processing.MutableAttributes;
import com.yahoo.searchdefinition.processing.NGramMatch;
import com.yahoo.searchdefinition.processing.OnnxModelConfigGenerator;
import com.yahoo.searchdefinition.processing.OnnxModelTypeResolver;
import com.yahoo.searchdefinition.processing.OptimizeIlscript;
import com.yahoo.searchdefinition.processing.PagedAttributeValidator;
import com.yahoo.searchdefinition.processing.PredicateProcessor;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.RankingExpressionTypeResolver;
import com.yahoo.searchdefinition.processing.ReferenceFieldsProcessor;
import com.yahoo.searchdefinition.processing.ReservedDocumentNames;
import com.yahoo.searchdefinition.processing.ReservedFunctionNames;
import com.yahoo.searchdefinition.processing.SearchMustHaveDocument;
import com.yahoo.searchdefinition.processing.SetRankTypeEmptyOnFilters;
import com.yahoo.searchdefinition.processing.SortingSettings;
import com.yahoo.searchdefinition.processing.StringSettingsOnNonStringFields;
import com.yahoo.searchdefinition.processing.SummaryConsistency;
import com.yahoo.searchdefinition.processing.SummaryDiskAccessValidator;
import com.yahoo.searchdefinition.processing.SummaryDynamicStructsArrays;
import com.yahoo.searchdefinition.processing.SummaryFieldsMustHaveValidSource;
import com.yahoo.searchdefinition.processing.SummaryNamesFieldCollisions;
import com.yahoo.searchdefinition.processing.TagType;
import com.yahoo.searchdefinition.processing.TensorFieldProcessor;
import com.yahoo.searchdefinition.processing.TextMatch;
import com.yahoo.searchdefinition.processing.UriHack;
import com.yahoo.searchdefinition.processing.UrlFieldValidator;
import com.yahoo.searchdefinition.processing.ValidateFieldTypes;
import com.yahoo.searchdefinition.processing.ValidateFieldTypesDocumentsOnly;
import com.yahoo.searchdefinition.processing.ValidateFieldWithIndexSettingsCreatesIndex;
import com.yahoo.searchdefinition.processing.ValidateStructTypeInheritance;
import com.yahoo.searchdefinition.processing.WordMatch;
import com.yahoo.searchdefinition.processing.multifieldresolver.RankProfileTypeSettingsProcessor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class Processing {
    private Collection<ProcessorFactory> processors() {
        return Arrays.asList(SearchMustHaveDocument::new, UrlFieldValidator::new, BuiltInFieldSets::new, ReservedDocumentNames::new, IndexFieldNames::new, IntegerIndex2Attribute::new, MakeAliases::new, UriHack::new, LiteralBoost::new, TagType::new, ValidateFieldTypesDocumentsOnly::new, IndexingInputs::new, OptimizeIlscript::new, ValidateFieldWithIndexSettingsCreatesIndex::new, AttributesImplicitWord::new, MutableAttributes::new, CreatePositionZCurve::new, DictionaryProcessor::new, WordMatch::new, ImportedFieldsResolver::new, ImplicitSummaries::new, ImplicitSummaryFields::new, AdjustPositionSummaryFields::new, SummaryConsistency::new, SummaryNamesFieldCollisions::new, SummaryFieldsMustHaveValidSource::new, MatchedElementsOnlyResolver::new, AddAttributeTransformToSummaryOfImportedFields::new, MakeDefaultSummaryTheSuperSet::new, Bolding::new, AttributeProperties::new, SetRankTypeEmptyOnFilters::new, SummaryDynamicStructsArrays::new, StringSettingsOnNonStringFields::new, IndexingOutputs::new, ExactMatch::new, NGramMatch::new, TextMatch::new, MultifieldIndexHarmonizer::new, FilterFieldNames::new, MatchConsistency::new, ValidateStructTypeInheritance::new, ValidateFieldTypes::new, SummaryDiskAccessValidator::new, DisallowComplexMapAndWsetKeyTypes::new, SortingSettings::new, FieldSetSettings::new, AddExtraFieldsToDocument::new, PredicateProcessor::new, MatchPhaseSettingsValidator::new, DiversitySettingsValidator::new, TensorFieldProcessor::new, RankProfileTypeSettingsProcessor::new, ReferenceFieldsProcessor::new, FastAccessValidator::new, ReservedFunctionNames::new, OnnxModelConfigGenerator::new, OnnxModelTypeResolver::new, RankingExpressionTypeResolver::new, BoolAttributeValidator::new, PagedAttributeValidator::new, IndexingValidation::new, IndexingValues::new);
    }

    private Collection<ProcessorFactory> rankProfileProcessors() {
        return Arrays.asList(RankProfileTypeSettingsProcessor::new, ReservedFunctionNames::new, RankingExpressionTypeResolver::new);
    }

    public void process(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, boolean validate, boolean documentsOnly, Set<Class<? extends Processor>> processorsToSkip) {
        Collection<ProcessorFactory> factories = this.processors();
        factories.stream().map(factory -> factory.create(schema, deployLogger, rankProfileRegistry, queryProfiles)).filter(processor -> !processorsToSkip.contains(processor.getClass())).forEach(processor -> processor.process(validate, documentsOnly));
    }

    public void processRankProfiles(DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles, boolean validate, boolean documentsOnly) {
        Collection<ProcessorFactory> factories = this.rankProfileProcessors();
        factories.stream().map(factory -> factory.create(null, deployLogger, rankProfileRegistry, queryProfiles)).forEach(processor -> processor.process(validate, documentsOnly));
    }

    @FunctionalInterface
    public static interface ProcessorFactory {
        public Processor create(Schema var1, DeployLogger var2, RankProfileRegistry var3, QueryProfiles var4);
    }
}

