/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.searchdefinition.Application;
import com.yahoo.searchdefinition.DocumentGraphValidator;
import com.yahoo.searchdefinition.DocumentModelBuilder;
import com.yahoo.searchdefinition.DocumentReferenceResolver;
import com.yahoo.searchdefinition.FieldOperationApplier;
import com.yahoo.searchdefinition.FieldOperationApplierForSearch;
import com.yahoo.searchdefinition.FieldOperationApplierForStructs;
import com.yahoo.searchdefinition.ImportedFieldsEnumerator;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SDDocumentTypeOrderer;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.TemporarySDTypeResolver;
import com.yahoo.searchdefinition.derived.SearchOrderer;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.SDParser;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.TokenMgrException;
import com.yahoo.searchdefinition.processing.Processing;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SchemaBuilder {
    private final DocumentTypeManager docTypeMgr = new DocumentTypeManager();
    private final DocumentModel model = new DocumentModel();
    private final Application application;
    private final RankProfileRegistry rankProfileRegistry;
    private final QueryProfileRegistry queryProfileRegistry;
    private final FileRegistry fileRegistry;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;
    private final boolean documentsOnly;
    private boolean isBuilt = false;
    private final Set<Class<? extends Processor>> processorsToSkip = new HashSet<Class<? extends Processor>>();

    public SchemaBuilder() {
        this(new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public SchemaBuilder(DeployLogger deployLogger) {
        this(MockApplicationPackage.createEmpty(), deployLogger);
    }

    public SchemaBuilder(DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(MockApplicationPackage.createEmpty(), deployLogger, rankProfileRegistry);
    }

    public SchemaBuilder(boolean documentsOnly) {
        this(MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry(), documentsOnly);
    }

    public SchemaBuilder(ApplicationPackage app, DeployLogger deployLogger) {
        this(app, (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public SchemaBuilder(ApplicationPackage app, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry) {
        this(app, (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), rankProfileRegistry, new QueryProfileRegistry());
    }

    public SchemaBuilder(RankProfileRegistry rankProfileRegistry) {
        this(rankProfileRegistry, new QueryProfileRegistry());
    }

    public SchemaBuilder(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(rankProfileRegistry, queryProfileRegistry, new TestProperties());
    }

    public SchemaBuilder(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry, ModelContext.Properties properties) {
        this(MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), properties, rankProfileRegistry, queryProfileRegistry);
    }

    public SchemaBuilder(ApplicationPackage app, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        this(app, fileRegistry, deployLogger, properties, rankProfileRegistry, queryProfileRegistry, false);
    }

    private SchemaBuilder(ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry, boolean documentsOnly) {
        this.application = new Application(applicationPackage);
        this.rankProfileRegistry = rankProfileRegistry;
        this.queryProfileRegistry = queryProfileRegistry;
        this.fileRegistry = fileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.documentsOnly = documentsOnly;
    }

    public String importFile(String fileName) throws IOException, ParseException {
        File file = new File(fileName);
        return this.importString(IOUtils.readFile((File)file), file.getAbsoluteFile().getParent());
    }

    private String importFile(Path file) throws IOException, ParseException {
        return this.importFile(file.toString());
    }

    public String importReader(NamedReader reader, String searchDefDir) throws IOException, ParseException {
        return this.importString(IOUtils.readAll((Reader)reader), searchDefDir);
    }

    public String importString(String str) throws ParseException {
        return this.importString(str, null);
    }

    private String importString(String str, String searchDefDir) throws ParseException {
        SimpleCharStream stream = new SimpleCharStream(str);
        try {
            return this.importRawSchema(new SDParser(stream, this.fileRegistry, this.deployLogger, this.properties, this.application, this.rankProfileRegistry, this.documentsOnly).schema(this.docTypeMgr, searchDefDir));
        }
        catch (TokenMgrException e) {
            throw new ParseException("Unknown symbol: " + e.getMessage());
        }
        catch (ParseException pe) {
            throw new ParseException(stream.formatException(Exceptions.toMessageString((Throwable)pe)));
        }
    }

    public String importRawSchema(Schema schema) {
        if (schema.getName() == null) {
            throw new IllegalArgumentException("Schema has no name");
        }
        String rawName = schema.getName();
        this.application.add(schema);
        return rawName;
    }

    public void build() {
        this.build(true);
    }

    public void build(boolean validate) {
        if (this.isBuilt) {
            throw new IllegalStateException("Application already built");
        }
        new TemporarySDTypeResolver(this.application.schemas().values(), this.deployLogger).process();
        if (validate) {
            this.application.validate(this.deployLogger);
        }
        ArrayList<SDDocumentType> sdocs = new ArrayList<SDDocumentType>();
        sdocs.add(SDDocumentType.VESPA_DOCUMENT);
        for (Schema schema : this.application.schemas().values()) {
            if (!schema.hasDocument()) continue;
            sdocs.add(schema.getDocument());
        }
        SDDocumentTypeOrderer orderer = new SDDocumentTypeOrderer(sdocs, this.deployLogger);
        orderer.process();
        for (SDDocumentType sdoc : orderer.getOrdered()) {
            new FieldOperationApplierForStructs().process(sdoc);
            new FieldOperationApplier().process(sdoc);
        }
        DocumentReferenceResolver documentReferenceResolver = new DocumentReferenceResolver(this.application.schemas().values());
        sdocs.forEach(documentReferenceResolver::resolveReferences);
        sdocs.forEach(documentReferenceResolver::resolveInheritedReferences);
        ImportedFieldsEnumerator importedFieldsEnumerator = new ImportedFieldsEnumerator(this.application.schemas().values());
        sdocs.forEach(importedFieldsEnumerator::enumerateImportedFields);
        if (validate) {
            new DocumentGraphValidator().validateDocumentGraph(sdocs);
        }
        DocumentModelBuilder builder = new DocumentModelBuilder(this.model);
        ArrayList<Schema> schemasSomewhatOrdered = new ArrayList<Schema>(this.application.schemas().values());
        for (Schema schema : new SearchOrderer().order(schemasSomewhatOrdered)) {
            new FieldOperationApplierForSearch().process(schema);
            this.process(schema, new QueryProfiles(this.queryProfileRegistry, this.deployLogger), validate);
        }
        builder.addToModel(schemasSomewhatOrdered);
        this.isBuilt = true;
    }

    public Set<Class<? extends Processor>> processorsToSkip() {
        return this.processorsToSkip;
    }

    private void process(Schema schema, QueryProfiles queryProfiles, boolean validate) {
        new Processing().process(schema, this.deployLogger, this.rankProfileRegistry, queryProfiles, validate, this.documentsOnly, this.processorsToSkip);
    }

    public Schema getSchema() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Application not built.");
        }
        if (this.application.schemas().size() != 1) {
            throw new IllegalStateException("This call only works if we have 1 schema. Schemas: " + this.application.schemas().values());
        }
        return this.application.schemas().values().stream().findAny().get();
    }

    public DocumentModel getModel() {
        return this.model;
    }

    public Schema getSchema(String name) {
        if (!this.isBuilt) {
            throw new IllegalStateException("Application not built.");
        }
        if (name == null) {
            return this.getSchema();
        }
        return this.application.schemas().get(name);
    }

    public Application application() {
        return this.application;
    }

    public List<Schema> getSchemaList() {
        return new ArrayList<Schema>(this.application.schemas().values());
    }

    public static SchemaBuilder createFromString(String sd) throws ParseException {
        return SchemaBuilder.createFromString(sd, (DeployLogger)new BaseDeployLogger());
    }

    public static SchemaBuilder createFromString(String sd, DeployLogger logger) throws ParseException {
        SchemaBuilder builder = new SchemaBuilder(logger);
        builder.importString(sd);
        builder.build(true);
        return builder;
    }

    public static SchemaBuilder createFromStrings(DeployLogger logger, String ... schemas) throws ParseException {
        SchemaBuilder builder = new SchemaBuilder(logger);
        for (String schema : schemas) {
            builder.importString(schema);
        }
        builder.build(true);
        return builder;
    }

    public static SchemaBuilder createFromFile(String fileName) throws IOException, ParseException {
        return SchemaBuilder.createFromFile(fileName, (DeployLogger)new BaseDeployLogger());
    }

    public static SchemaBuilder createFromFiles(Collection<String> fileNames) throws IOException, ParseException {
        return SchemaBuilder.createFromFiles(fileNames, (DeployLogger)new BaseDeployLogger());
    }

    public static SchemaBuilder createFromFile(String fileName, DeployLogger logger) throws IOException, ParseException {
        return SchemaBuilder.createFromFile(fileName, logger, new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static SchemaBuilder createFromFiles(Collection<String> fileNames, DeployLogger logger) throws IOException, ParseException {
        return SchemaBuilder.createFromFiles(fileNames, (FileRegistry)new MockFileRegistry(), logger, new TestProperties(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    private static SchemaBuilder createFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        return SchemaBuilder.createFromFiles(Collections.singletonList(fileName), (FileRegistry)new MockFileRegistry(), deployLogger, new TestProperties(), rankProfileRegistry, queryprofileRegistry);
    }

    private static SchemaBuilder createFromFiles(Collection<String> fileNames, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryprofileRegistry) throws IOException, ParseException {
        SchemaBuilder builder = new SchemaBuilder(MockApplicationPackage.createEmpty(), fileRegistry, deployLogger, properties, rankProfileRegistry, queryprofileRegistry);
        for (String fileName : fileNames) {
            builder.importFile(fileName);
        }
        builder.build(true);
        return builder;
    }

    public static SchemaBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties) throws IOException, ParseException {
        return SchemaBuilder.createFromDirectory(dir, fileRegistry, logger, properties, new RankProfileRegistry());
    }

    public static SchemaBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry) throws IOException, ParseException {
        return SchemaBuilder.createFromDirectory(dir, fileRegistry, logger, properties, rankProfileRegistry, SchemaBuilder.createQueryProfileRegistryFromDirectory(dir));
    }

    private static SchemaBuilder createFromDirectory(String dir, FileRegistry fileRegistry, DeployLogger logger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SchemaBuilder.createFromDirectory(dir, MockApplicationPackage.fromSearchDefinitionAndRootDirectory(dir), fileRegistry, logger, properties, rankProfileRegistry, queryProfileRegistry);
    }

    private static SchemaBuilder createFromDirectory(String dir, ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        SchemaBuilder builder = new SchemaBuilder(applicationPackage, fileRegistry, deployLogger, properties, rankProfileRegistry, queryProfileRegistry);
        Iterator i = Files.list(new File(dir).toPath()).filter(p -> p.getFileName().toString().endsWith(".sd")).iterator();
        while (i.hasNext()) {
            builder.importFile((Path)i.next());
        }
        builder.build(true);
        return builder;
    }

    private static QueryProfileRegistry createQueryProfileRegistryFromDirectory(String dir) {
        File queryProfilesDir = new File(dir, "query-profiles");
        if (!queryProfilesDir.exists()) {
            return new QueryProfileRegistry();
        }
        return new QueryProfileXMLReader().read(queryProfilesDir.toString());
    }

    public static Schema buildFromFile(String fileName) throws IOException, ParseException {
        return SchemaBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), new RankProfileRegistry(), new QueryProfileRegistry());
    }

    public static Schema buildFromFile(String fileName, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SchemaBuilder.buildFromFile(fileName, (DeployLogger)new BaseDeployLogger(), rankProfileRegistry, queryProfileRegistry);
    }

    public static Schema buildFromFile(String fileName, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) throws IOException, ParseException {
        return SchemaBuilder.createFromFile(fileName, deployLogger, rankProfileRegistry, queryProfileRegistry).getSchema();
    }

    public static SchemaBuilder createFromRawSchema(Schema rawSchema, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        SchemaBuilder builder = new SchemaBuilder(rankProfileRegistry, queryProfileRegistry);
        builder.importRawSchema(rawSchema);
        builder.build();
        return builder;
    }

    public static Schema buildFromRawSchema(Schema rawSchema, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfileRegistry) {
        return SchemaBuilder.createFromRawSchema(rawSchema, rankProfileRegistry, queryProfileRegistry).getSchema();
    }

    public RankProfileRegistry getRankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public QueryProfileRegistry getQueryProfileRegistry() {
        return this.queryProfileRegistry;
    }

    public ModelContext.Properties getProperties() {
        return this.properties;
    }

    public DeployLogger getDeployLogger() {
        return this.deployLogger;
    }
}

