/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AnnotationReferenceDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.TemporarySDDocumentType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SDDocumentTypeOrderer {
    private final Map<DataTypeName, SDDocumentType> createdSDTypes = new LinkedHashMap<DataTypeName, SDDocumentType>();
    private final Set<Integer> seenTypes = new LinkedHashSet<Integer>();
    List<SDDocumentType> processingOrder = new LinkedList<SDDocumentType>();
    private final DeployLogger deployLogger;

    public SDDocumentTypeOrderer(List<SDDocumentType> sdTypes, DeployLogger deployLogger) {
        this.deployLogger = deployLogger;
        for (SDDocumentType type : sdTypes) {
            this.createdSDTypes.put(type.getDocumentName(), type);
        }
        DocumentTypeManager dtm = new DocumentTypeManager();
        for (DataType type : dtm.getDataTypes()) {
            this.seenTypes.add(type.getId());
        }
    }

    List<SDDocumentType> getOrdered() {
        return this.processingOrder;
    }

    public void process() {
        for (SDDocumentType type : this.createdSDTypes.values()) {
            this.process(type, type);
        }
    }

    private void process(SDDocumentType docOrStruct, SDDocumentType owningDocument) {
        this.resolveAndProcessInheritedTemporaryTypes(docOrStruct, owningDocument);
        int id = docOrStruct.isStruct() ? new StructDataType(docOrStruct.getName()).getId() : new DocumentType(docOrStruct.getName()).getId();
        if (this.seenTypes.contains(id)) {
            return;
        }
        this.seenTypes.add(new StructDataType(docOrStruct.getName()).getId());
        for (Field field : docOrStruct.fieldSet()) {
            if (this.seenTypes.contains(field.getDataType().getId())) continue;
            this.visit(field.getDataType(), owningDocument);
        }
        this.processingOrder.add(docOrStruct);
    }

    private void resolveAndProcessInheritedTemporaryTypes(SDDocumentType type, SDDocumentType owningDocument) {
        ArrayList<DataTypeName> toReplace = new ArrayList<DataTypeName>();
        for (SDDocumentType sdoc : type.getInheritedTypes()) {
            if (!(sdoc instanceof TemporarySDDocumentType)) continue;
            toReplace.add(sdoc.getDocumentName());
        }
        for (DataTypeName name : toReplace) {
            SDDocumentType inherited;
            if (type.isStruct()) {
                inherited = owningDocument.allTypes().get(new NewDocumentType.Name(name.getName()));
                if (inherited == null) {
                    throw new IllegalStateException("Struct '" + name + "' not found in " + owningDocument);
                }
                this.process(inherited, owningDocument);
            } else {
                inherited = this.createdSDTypes.get(name);
                if (inherited == null) {
                    throw new IllegalStateException("Document type '" + name + "' not found");
                }
                this.process(inherited, inherited);
            }
            type.inherit(inherited);
        }
    }

    private SDDocumentType find(String name) {
        SDDocumentType sdDocType = this.createdSDTypes.get(new DataTypeName(name));
        if (sdDocType != null) {
            return sdDocType;
        }
        for (SDDocumentType sdoc : this.createdSDTypes.values()) {
            for (SDDocumentType stype : sdoc.getTypes()) {
                if (!stype.getName().equals(name)) continue;
                return stype;
            }
        }
        return null;
    }

    private void visit(DataType type, SDDocumentType owningDocument) {
        if (type instanceof StructuredDataType) {
            StructuredDataType structType = (StructuredDataType)type;
            SDDocumentType sdDocType = this.find(structType.getName());
            if (sdDocType == null) {
                throw new IllegalArgumentException("Could not find struct '" + type.getName() + "'");
            }
            this.process(sdDocType, owningDocument);
            return;
        }
        if (type instanceof MapDataType) {
            MapDataType mType = (MapDataType)type;
            this.visit(mType.getValueType(), owningDocument);
            this.visit(mType.getKeyType(), owningDocument);
        } else if (type instanceof WeightedSetDataType) {
            WeightedSetDataType wType = (WeightedSetDataType)type;
            this.visit(wType.getNestedType(), owningDocument);
        } else if (type instanceof CollectionDataType) {
            CollectionDataType cType = (CollectionDataType)type;
            this.visit(cType.getNestedType(), owningDocument);
        } else if (!(type instanceof AnnotationReferenceDataType || type instanceof PrimitiveDataType || type instanceof TensorDataType || type instanceof ReferenceDataType)) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Unknown type : " + type);
        }
    }
}

