/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.UserBindingPattern;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.container.http.xml.FilterChainsBuilder;
import com.yahoo.vespa.model.container.http.xml.JettyHttpServerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class HttpBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Http> {
    static final String REQUEST_CHAIN_TAG_NAME = "request-chain";
    static final String RESPONSE_CHAIN_TAG_NAME = "response-chain";
    static final List<String> VALID_FILTER_CHAIN_TAG_NAMES = List.of("request-chain", "response-chain");

    @Override
    protected Http doBuild(DeployState deployState, AbstractConfigProducer ancestor, Element spec) {
        FilterChains filterChains;
        List<Object> bindings = new ArrayList();
        AccessControl accessControl = null;
        Optional<Boolean> strictFiltering = Optional.empty();
        Element filteringElem = XML.getChild((Element)spec, (String)"filtering");
        if (filteringElem != null) {
            filterChains = (FilterChains)new FilterChainsBuilder().build(deployState, ancestor, filteringElem);
            bindings = this.readFilterBindings(filteringElem);
            strictFiltering = XmlHelper.getOptionalAttribute(filteringElem, "strict-mode").map(Boolean::valueOf);
            Element accessControlElem = XML.getChild((Element)filteringElem, (String)"access-control");
            if (accessControlElem != null) {
                accessControl = this.buildAccessControl(deployState, ancestor, accessControlElem);
            }
        } else {
            filterChains = new FilterChainsBuilder().newChainsInstance(ancestor);
        }
        Http http = new Http(filterChains);
        strictFiltering.ifPresent(http::setStrictFiltering);
        http.getBindings().addAll(bindings);
        ApplicationContainerCluster cluster = HttpBuilder.getContainerCluster(ancestor).orElse(null);
        http.setHttpServer((JettyHttpServer)new JettyHttpServerBuilder(cluster).build(deployState, ancestor, spec));
        if (accessControl != null) {
            accessControl.configureHttpFilterChains(http);
        }
        return http;
    }

    private AccessControl buildAccessControl(DeployState deployState, AbstractConfigProducer ancestor, Element accessControlElem) {
        AthenzDomain domain = HttpBuilder.getAccessControlDomain(deployState, accessControlElem);
        AccessControl.Builder builder = new AccessControl.Builder(domain.value());
        HttpBuilder.getContainerCluster(ancestor).ifPresent(builder::setHandlers);
        XmlHelper.getOptionalAttribute(accessControlElem, "read").ifPresent(readAttr -> builder.readEnabled(Boolean.valueOf(readAttr)));
        XmlHelper.getOptionalAttribute(accessControlElem, "write").ifPresent(writeAttr -> builder.writeEnabled(Boolean.valueOf(writeAttr)));
        AccessControl.ClientAuthentication clientAuth = XmlHelper.getOptionalAttribute(accessControlElem, "tls-handshake-client-auth").filter("want"::equals).map(value -> AccessControl.ClientAuthentication.want).orElse(AccessControl.ClientAuthentication.need);
        if (!deployState.getProperties().allowDisableMtls() && clientAuth == AccessControl.ClientAuthentication.want) {
            throw new IllegalArgumentException("Overriding 'tls-handshake-client-auth' for application is not allowed.");
        }
        builder.clientAuthentication(clientAuth);
        Element excludeElem = XML.getChild((Element)accessControlElem, (String)"exclude");
        if (excludeElem != null) {
            XML.getChildren((Element)excludeElem, (String)"binding").stream().map(xml -> UserBindingPattern.fromPattern(XML.getValue((Element)xml))).forEach(builder::excludeBinding);
        }
        return builder.build();
    }

    private static AthenzDomain getAccessControlDomain(DeployState deployState, Element accessControlElem) {
        AthenzDomain tenantDomain = deployState.getProperties().athenzDomain().orElse(null);
        AthenzDomain explicitDomain = XmlHelper.getOptionalAttribute(accessControlElem, "domain").map(AthenzDomain::from).orElse(null);
        if (tenantDomain == null) {
            if (explicitDomain == null) {
                throw new IllegalStateException("No Athenz domain provided for 'access-control'");
            }
            deployState.getDeployLogger().logApplicationPackage(Level.WARNING, "Athenz tenant is not provided by deploy call. This will soon be handled as failure.");
        }
        if (explicitDomain != null) {
            if (tenantDomain != null && !explicitDomain.equals((Object)tenantDomain)) {
                throw new IllegalArgumentException(String.format("Domain in access-control ('%s') does not match tenant domain ('%s')", explicitDomain.value(), tenantDomain.value()));
            }
            deployState.getDeployLogger().logApplicationPackage(Level.WARNING, "Domain in 'access-control' is deprecated and is no longer necessary. Please remove the 'domain' attribute from the 'access-control' element in services.xml.");
        }
        return tenantDomain != null ? tenantDomain : explicitDomain;
    }

    private static Optional<ApplicationContainerCluster> getContainerCluster(AbstractConfigProducer configProducer) {
        AbstractConfigProducer currentProducer = configProducer;
        while (!ApplicationContainerCluster.class.isAssignableFrom(currentProducer.getClass())) {
            if ((currentProducer = currentProducer.getParent()) != null) continue;
            return Optional.empty();
        }
        return Optional.of((ApplicationContainerCluster)currentProducer);
    }

    private List<FilterBinding> readFilterBindings(Element filteringSpec) {
        ArrayList<FilterBinding> result = new ArrayList<FilterBinding>();
        for (Element child : XML.getChildren((Element)filteringSpec)) {
            String tagName = child.getTagName();
            if (!VALID_FILTER_CHAIN_TAG_NAMES.contains(tagName)) continue;
            ComponentSpecification chainId = XmlHelper.getIdRef(child);
            for (Element bindingSpec : XML.getChildren((Element)child, (String)"binding")) {
                String binding = XML.getValue((Element)bindingSpec);
                result.add(FilterBinding.create(HttpBuilder.toFilterBindingType(tagName), chainId, UserBindingPattern.fromPattern(binding)));
            }
        }
        return result;
    }

    private static FilterBinding.Type toFilterBindingType(String chainTag) {
        switch (chainTag) {
            case "request-chain": {
                return FilterBinding.Type.REQUEST;
            }
            case "response-chain": {
                return FilterBinding.Type.RESPONSE;
            }
        }
        throw new IllegalArgumentException("Unknown filter chain tag: " + chainTag);
    }

    static int readPort(ModelElement spec, boolean isHosted, DeployLogger logger) {
        Integer port = spec.integerAttribute("port");
        if (port == null) {
            return Defaults.getDefaults().vespaWebServicePort();
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        int legalPortInHostedVespa = Container.BASEPORT;
        if (isHosted && port != legalPortInHostedVespa && !spec.booleanAttribute("required", false)) {
            throw new IllegalArgumentException("Illegal port " + port + " in http server '" + spec.stringAttribute("id") + "': Port must be set to " + legalPortInHostedVespa);
        }
        return port;
    }
}

