/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeReindexAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VespaReindexAction
extends VespaConfigChangeAction
implements ConfigChangeReindexAction {
    private final ValidationId validationId;
    private final String documentType;

    private VespaReindexAction(ClusterSpec.Id id, ValidationId validationId, String message, List<ServiceInfo> services, String documentType) {
        super(id, message, services);
        this.validationId = validationId;
        this.documentType = documentType;
    }

    public static VespaReindexAction of(ClusterSpec.Id id, ValidationId validationId, String message) {
        return new VespaReindexAction(id, validationId, message, List.of(), null);
    }

    public static VespaReindexAction of(ClusterSpec.Id id, ValidationId validationId, String message, List<ServiceInfo> services, String documentType) {
        return new VespaReindexAction(id, validationId, message, services, documentType);
    }

    @Override
    public VespaConfigChangeAction modifyAction(String newMessage, List<ServiceInfo> newServices, String documentType) {
        return new VespaReindexAction(this.clusterId(), this.validationId, newMessage, newServices, documentType);
    }

    public Optional<ValidationId> validationId() {
        return Optional.ofNullable(this.validationId);
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean ignoreForInternalRedeploy() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", documentType='" + this.documentType + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VespaReindexAction that = (VespaReindexAction)o;
        return Objects.equals(this.validationId, that.validationId) && Objects.equals(this.documentType, that.documentType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.validationId, this.documentType);
    }
}

