/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.application.validation.first.AccessControlOnFirstDeploymentValidator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.Http;
import java.util.ArrayList;

public class AwsAccessControlValidator
extends Validator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        if (!AccessControlOnFirstDeploymentValidator.needsAccessControlValidation(model, deployState)) {
            return;
        }
        if (!deployState.zone().getCloud().requireAccessControl()) {
            return;
        }
        ArrayList<String> offendingClusters = new ArrayList<String>();
        for (ApplicationContainerCluster cluster : model.getContainerClusters().values()) {
            Http http = cluster.getHttp();
            if (http != null && http.getAccessControl().isPresent() && http.getAccessControl().get().writeEnabled && http.getAccessControl().get().readEnabled || !AccessControl.hasHandlerThatNeedsProtection(cluster)) continue;
            offendingClusters.add(cluster.getName());
        }
        if (!offendingClusters.isEmpty()) {
            deployState.validationOverrides().invalid(ValidationId.accessControl, "Access-control must be enabled for read/write operations to container clusters in AWS production zones: " + CollectionUtil.mkString(offendingClusters, (String)"[", (String)", ", (String)"]"), deployState.now());
        }
    }
}

