/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.searchdefinition.document.GeoPos;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.ImportedComplexField;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.document.ImportedSimpleField;
import com.yahoo.searchdefinition.document.TemporaryImportedField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ImportedFieldsResolver
extends Processor {
    private final Map<String, ImportedField> importedFields = new LinkedHashMap<String, ImportedField>();
    private final Optional<DocumentReferences> references;

    public ImportedFieldsResolver(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
        this.references = schema.getDocument().getDocumentReferences();
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.schema.temporaryImportedFields().get().fields().forEach((name, field) -> this.resolveImportedField((TemporaryImportedField)field, validate));
        this.schema.setImportedFields(new ImportedFields(this.importedFields));
    }

    private void resolveImportedField(TemporaryImportedField importedField, boolean validate) {
        DocumentReference reference = this.validateDocumentReference(importedField);
        ImmutableSDField targetField = this.getTargetField(importedField, reference);
        if (GeoPos.isAnyPos(targetField)) {
            this.resolveImportedPositionField(importedField, reference, targetField, validate);
        } else if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(targetField)) {
            this.resolveImportedArrayOfStructField(importedField, reference, targetField, validate);
        } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(targetField)) {
            this.resolveImportedMapOfStructField(importedField, reference, targetField, validate);
        } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(targetField)) {
            this.resolveImportedMapOfPrimitiveField(importedField, reference, targetField, validate);
        } else {
            this.resolveImportedNormalField(importedField, reference, targetField, validate);
        }
    }

    private void resolveImportedPositionField(TemporaryImportedField importedField, DocumentReference reference, ImmutableSDField targetField, boolean validate) {
        TemporaryImportedField importedZCurveField = new TemporaryImportedField(PositionDataType.getZCurveFieldName((String)importedField.fieldName()), reference.referenceField().getName(), PositionDataType.getZCurveFieldName((String)targetField.getName()));
        ImmutableSDField targetZCurveField = this.getTargetField(importedZCurveField, reference);
        this.resolveImportedNormalField(importedZCurveField, reference, targetZCurveField, validate);
        ImportedComplexField importedStructField = new ImportedComplexField(importedField.fieldName(), reference, targetField);
        this.registerImportedField(importedField, null, importedStructField);
    }

    private void resolveImportedArrayOfStructField(TemporaryImportedField importedField, DocumentReference reference, ImmutableSDField targetField, boolean validate) {
        ImportedComplexField importedStructField = new ImportedComplexField(importedField.fieldName(), reference, targetField);
        this.resolveImportedNestedStructField(importedField, reference, importedStructField, targetField, validate);
        this.registerImportedField(importedField, null, importedStructField);
    }

    private void resolveImportedMapOfStructField(TemporaryImportedField importedField, DocumentReference reference, ImmutableSDField targetField, boolean validate) {
        ImportedComplexField importedMapField = new ImportedComplexField(importedField.fieldName(), reference, targetField);
        ImportedComplexField importedStructField = new ImportedComplexField(importedField.fieldName() + ".value", reference, targetField.getStructField("value"));
        importedMapField.addNestedField(importedStructField);
        this.resolveImportedNestedField(importedField, reference, importedMapField, targetField.getStructField("key"), validate);
        this.resolveImportedNestedStructField(importedField, reference, importedStructField, importedStructField.targetField(), validate);
        this.registerImportedField(importedField, null, importedMapField);
    }

    private void makeImportedNormalField(TemporaryImportedField importedField, ImportedComplexField owner, String name, DocumentReference reference, ImmutableSDField targetField) {
        ImportedSimpleField importedSimpleField = new ImportedSimpleField(name, reference, targetField);
        this.registerImportedField(importedField, owner, importedSimpleField);
    }

    private void registerImportedField(TemporaryImportedField temporaryImportedField, ImportedComplexField owner, ImportedField importedField) {
        if (owner != null) {
            owner.addNestedField(importedField);
        } else {
            if (this.importedFields.get(importedField.fieldName()) != null) {
                this.fail(temporaryImportedField, importedField.fieldName(), ImportedFieldsResolver.targetFieldAsString(importedField.targetField().getName(), importedField.reference()) + ": Field already imported");
            }
            this.importedFields.put(importedField.fieldName(), importedField);
        }
    }

    private static String makeImportedNestedFieldName(TemporaryImportedField importedField, ImmutableSDField targetNestedField) {
        return importedField.fieldName() + targetNestedField.getName().substring(importedField.targetFieldName().length());
    }

    private boolean resolveImportedNestedField(TemporaryImportedField importedField, DocumentReference reference, ImportedComplexField owner, ImmutableSDField targetNestedField, boolean requireAttribute) {
        Attribute attribute = targetNestedField.getAttribute();
        String importedNestedFieldName = ImportedFieldsResolver.makeImportedNestedFieldName(importedField, targetNestedField);
        if (attribute != null) {
            this.makeImportedNormalField(importedField, owner, importedNestedFieldName, reference, targetNestedField);
        } else if (requireAttribute) {
            this.fail(importedField, importedNestedFieldName, ImportedFieldsResolver.targetFieldAsString(targetNestedField.getName(), reference) + ": Is not an attribute field. Only attribute fields supported");
        }
        return attribute != null;
    }

    private void resolveImportedNestedStructField(TemporaryImportedField importedField, DocumentReference reference, ImportedComplexField ownerField, ImmutableSDField targetNestedField, boolean validate) {
        boolean foundAttribute = false;
        for (ImmutableSDField immutableSDField : targetNestedField.getStructFields()) {
            if (!this.resolveImportedNestedField(importedField, reference, ownerField, immutableSDField, false)) continue;
            foundAttribute = true;
        }
        if (validate && !foundAttribute) {
            String importedNestedFieldName = ImportedFieldsResolver.makeImportedNestedFieldName(importedField, targetNestedField);
            this.fail(importedField, importedNestedFieldName, ImportedFieldsResolver.targetFieldAsString(targetNestedField.getName(), reference) + ": Is not a struct containing an attribute field.");
        }
    }

    private void resolveImportedMapOfPrimitiveField(TemporaryImportedField importedField, DocumentReference reference, ImmutableSDField targetField, boolean validate) {
        ImportedComplexField importedMapField = new ImportedComplexField(importedField.fieldName(), reference, targetField);
        this.resolveImportedNestedField(importedField, reference, importedMapField, targetField.getStructField("key"), validate);
        this.resolveImportedNestedField(importedField, reference, importedMapField, targetField.getStructField("value"), validate);
        this.registerImportedField(importedField, null, importedMapField);
    }

    private void resolveImportedNormalField(TemporaryImportedField importedField, DocumentReference reference, ImmutableSDField targetField, boolean validate) {
        if (validate) {
            this.validateTargetField(importedField, targetField, reference);
        }
        this.makeImportedNormalField(importedField, null, importedField.fieldName(), reference, targetField);
    }

    private DocumentReference validateDocumentReference(TemporaryImportedField importedField) {
        String referenceFieldName = importedField.referenceFieldName();
        DocumentReference reference = this.references.get().referenceMap().get(referenceFieldName);
        if (reference == null) {
            this.fail(importedField, "Reference field '" + referenceFieldName + "' not found");
        }
        return reference;
    }

    private ImmutableSDField getTargetField(TemporaryImportedField importedField, DocumentReference reference) {
        String targetFieldName = importedField.targetFieldName();
        Schema targetSchema = reference.targetSearch();
        ImmutableSDField targetField = targetSchema.getField(targetFieldName);
        if (targetField == null) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Not found");
        }
        return targetField;
    }

    private void validateTargetField(TemporaryImportedField importedField, ImmutableSDField targetField, DocumentReference reference) {
        if (!targetField.doesAttributing()) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetField.getName(), reference) + ": Is not an attribute field. Only attribute fields supported");
        } else if (targetField.doesIndexing()) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetField.getName(), reference) + ": Is an index field. Not supported");
        } else if (targetField.getDataType().equals((Object)DataType.PREDICATE)) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetField.getName(), reference) + ": Is of type 'predicate'. Not supported");
        }
    }

    private static String targetFieldAsString(String targetFieldName, DocumentReference reference) {
        return "Field '" + targetFieldName + "' via reference field '" + reference.referenceField().getName() + "'";
    }

    private void fail(TemporaryImportedField importedField, String msg) {
        throw new IllegalArgumentException("For " + this.schema + ", import field '" + importedField.fieldName() + "': " + msg);
    }

    private void fail(TemporaryImportedField importedField, String importedNestedFieldName, String msg) {
        if (importedField.fieldName().equals(importedNestedFieldName)) {
            this.fail(importedField, msg);
        }
        throw new IllegalArgumentException("For " + this.schema + ", import field '" + importedField.fieldName() + "' (nested to '" + importedNestedFieldName + "'): " + msg);
    }
}

