/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.test;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SchemaBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class MockApplicationPackage
implements ApplicationPackage {
    public static final String DEPLOYED_BY_USER = "user";
    public static final String APPLICATION_NAME = "application";
    public static final long APPLICATION_GENERATION = 1L;
    public static final String MUSIC_SEARCHDEFINITION = MockApplicationPackage.createSearchDefinition("music", "foo");
    public static final String BOOK_SEARCHDEFINITION = MockApplicationPackage.createSearchDefinition("book", "bar");
    private final File root;
    private final String hostsS;
    private final String servicesS;
    private final List<String> schemas;
    private final String schemaDir;
    private final Optional<String> deploymentSpec;
    private final Optional<String> validationOverrides;
    private final boolean failOnValidateXml;
    private final QueryProfileRegistry queryProfileRegistry;
    private final ApplicationMetaData applicationMetaData;
    private static final String emptyServices = "<services version=\"1.0\">  <admin version=\"2.0\">    <adminserver hostalias=\"node1\" />  </admin></services>";
    private static final String emptyHosts = "<hosts>  <host name=\"localhost\">    <alias>node1</alias>  </host></hosts>";

    protected MockApplicationPackage(File root, String hosts, String services, List<String> schemas, String schemaDir, String deploymentSpec, String validationOverrides, boolean failOnValidateXml, String queryProfile, String queryProfileType) {
        this.root = root;
        this.hostsS = hosts;
        this.servicesS = services;
        this.schemas = schemas;
        this.schemaDir = schemaDir;
        this.deploymentSpec = Optional.ofNullable(deploymentSpec);
        this.validationOverrides = Optional.ofNullable(validationOverrides);
        this.failOnValidateXml = failOnValidateXml;
        this.queryProfileRegistry = new QueryProfileXMLReader().read(this.asNamedReaderList(queryProfileType), this.asNamedReaderList(queryProfile));
        this.applicationMetaData = new ApplicationMetaData(DEPLOYED_BY_USER, "dir", Long.valueOf(0L), false, ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)APPLICATION_NAME), (InstanceName)InstanceName.defaultName()), "checksum", Long.valueOf(1L), 0L);
    }

    protected File root() {
        return this.root;
    }

    public String getApplicationName() {
        return "mock application";
    }

    public ApplicationId getApplicationId() {
        return ApplicationId.from((String)"default", (String)this.getApplicationName(), (String)"default");
    }

    public Reader getServices() {
        return new StringReader(this.servicesS);
    }

    public Reader getHosts() {
        if (this.hostsS == null) {
            return null;
        }
        return new StringReader(this.hostsS);
    }

    public List<NamedReader> getSchemas() {
        ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
        SchemaBuilder schemaBuilder = new SchemaBuilder(this, (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), this.queryProfileRegistry);
        for (String sd : this.schemas) {
            try {
                String name = schemaBuilder.importString(sd);
                readers.add(new NamedReader(name + ".sd", (Reader)new StringReader(sd)));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return readers;
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        return Collections.emptyMap();
    }

    public List<NamedReader> getFiles(Path dir, String fileSuffix, boolean recurse) {
        return new ArrayList<NamedReader>();
    }

    public ApplicationFile getFile(Path file) {
        return new MockApplicationFile(file, Path.fromString((String)this.root.toString()));
    }

    public File getFileReference(Path path) {
        return Path.fromString((String)this.root.toString()).append(path).toFile();
    }

    public String getHostSource() {
        return "mock source";
    }

    public String getServicesSource() {
        return "mock source";
    }

    public Optional<Reader> getDeployment() {
        return this.deploymentSpec.map(StringReader::new);
    }

    public Optional<Reader> getValidationOverrides() {
        return this.validationOverrides.map(StringReader::new);
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return Collections.emptyList();
    }

    public QueryProfileRegistry getQueryProfiles() {
        return this.queryProfileRegistry;
    }

    public ApplicationMetaData getMetaData() {
        return this.applicationMetaData;
    }

    public Reader getRankingExpression(String name) {
        File expressionFile = new File(this.schemaDir, name);
        try {
            return IOUtils.createReader((File)expressionFile, (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + expressionFile.getAbsolutePath() + "'", e);
        }
    }

    public static ApplicationPackage createEmpty() {
        return new Builder().withHosts(emptyHosts).withServices(emptyServices).build();
    }

    public static ApplicationPackage fromSearchDefinitionDirectory(String dir) {
        return new Builder().withEmptyHosts().withEmptyServices().withSchemaDir(dir).build();
    }

    public static ApplicationPackage fromSearchDefinitionAndRootDirectory(String dir) {
        return new Builder().withRoot(new File(dir)).withEmptyHosts().withEmptyServices().withSchemaDir(dir).build();
    }

    public static String createSearchDefinition(String name, String fieldName) {
        return "search " + name + " {  document " + name + " {    field " + fieldName + " type string {}  }}";
    }

    public void validateXML() {
        if (this.failOnValidateXml) {
            throw new IllegalArgumentException("Error in application package");
        }
        throw new UnsupportedOperationException("This application package cannot validate XML");
    }

    private List<NamedReader> asNamedReaderList(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new NamedReader(this.extractId(value) + ".xml", (Reader)new StringReader(value)));
    }

    private String extractId(String xmlStringWithIdAttribute) {
        int idStart = xmlStringWithIdAttribute.indexOf("id=");
        int idEnd = Math.min(xmlStringWithIdAttribute.indexOf(" ", idStart), xmlStringWithIdAttribute.indexOf(">", idStart));
        return xmlStringWithIdAttribute.substring(idStart + 4, idEnd - 1);
    }

    public static class MockApplicationFile
    extends ApplicationFile {
        private final Path root;
        private final File file;

        public MockApplicationFile(Path filePath, Path applicationPackagePath) {
            super(filePath);
            this.root = applicationPackagePath;
            this.file = applicationPackagePath.append(filePath).toFile();
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public boolean exists() {
            return this.file.exists();
        }

        public Reader createReader() {
            try {
                if (!this.exists()) {
                    throw new FileNotFoundException("File '" + this.file + "' does not exist");
                }
                return IOUtils.createReader((File)this.file, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public InputStream createInputStream() {
            try {
                if (!this.exists()) {
                    throw new FileNotFoundException("File '" + this.file + "' does not exist");
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public ApplicationFile createDirectory() {
            this.file.mkdirs();
            return this;
        }

        public ApplicationFile writeFile(Reader input) {
            try {
                IOUtils.writeFile((File)this.file, (String)IOUtils.readAll((Reader)input), (boolean)false);
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public ApplicationFile appendFile(String value) {
            try {
                IOUtils.writeFile((File)this.file, (String)value, (boolean)true);
                return this;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
            if (!this.isDirectory()) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.file.listFiles()).filter(f -> filter.accept(Path.fromString((String)f.toString()))).map(f -> new MockApplicationFile(this.asApplicationRelativePath((File)f), this.root)).collect(Collectors.toList());
        }

        public ApplicationFile delete() {
            this.file.delete();
            return this;
        }

        public ApplicationFile.MetaData getMetaData() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(ApplicationFile other) {
            return this.getPath().getName().compareTo(other.getPath().getName());
        }

        private Path asApplicationRelativePath(File file) {
            Path path = Path.fromString((String)file.toString());
            Iterator pathIterator = path.iterator();
            for (String rootElement : this.root) {
                String pathElement;
                if (rootElement.equals(pathElement = (String)pathIterator.next())) continue;
                throw new RuntimeException("Assumption broken");
            }
            Path relative = Path.fromString((String)"");
            while (pathIterator.hasNext()) {
                relative = relative.append((String)pathIterator.next());
            }
            return relative;
        }
    }

    public static class Builder {
        private File root = new File("nonexisting");
        private String hosts = null;
        private String services = null;
        private List<String> schemas = Collections.emptyList();
        private String schemaDir = null;
        private String deploymentSpec = null;
        private String validationOverrides = null;
        private boolean failOnValidateXml = false;
        private String queryProfile = null;
        private String queryProfileType = null;

        public Builder withRoot(File root) {
            this.root = root;
            return this;
        }

        public Builder withEmptyHosts() {
            return this.withHosts(MockApplicationPackage.emptyHosts);
        }

        public Builder withHosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder withEmptyServices() {
            return this.withServices(MockApplicationPackage.emptyServices);
        }

        public Builder withServices(String services) {
            this.services = services;
            return this;
        }

        public Builder withSearchDefinition(String searchDefinition) {
            this.schemas = Collections.singletonList(searchDefinition);
            return this;
        }

        public Builder withSchemas(List<String> searchDefinition) {
            this.schemas = Collections.unmodifiableList(searchDefinition);
            return this;
        }

        public Builder withSchemaDir(String schemaDir) {
            this.schemaDir = schemaDir;
            return this;
        }

        public Builder withDeploymentSpec(String deploymentSpec) {
            this.deploymentSpec = deploymentSpec;
            return this;
        }

        public Builder withValidationOverrides(String validationOverrides) {
            this.validationOverrides = validationOverrides;
            return this;
        }

        public Builder failOnValidateXml() {
            this.failOnValidateXml = true;
            return this;
        }

        public Builder queryProfile(String queryProfile) {
            this.queryProfile = queryProfile;
            return this;
        }

        public Builder queryProfileType(String queryProfileType) {
            this.queryProfileType = queryProfileType;
            return this;
        }

        public ApplicationPackage build() {
            return new MockApplicationPackage(this.root, this.hosts, this.services, this.schemas, this.schemaDir, this.deploymentSpec, this.validationOverrides, this.failOnValidateXml, this.queryProfile, this.queryProfileType);
        }
    }
}

