/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;

public final class ApplicationContainer
extends Container {
    private static final String defaultHostedJVMArgs = "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage";
    private final boolean isHostedVespa;

    public ApplicationContainer(AbstractConfigProducer parent, String name, int index, boolean isHostedVespa) {
        this(parent, name, false, index, isHostedVespa);
    }

    public ApplicationContainer(AbstractConfigProducer parent, String name, boolean retired, int index, boolean isHostedVespa) {
        super(parent, name, retired, index);
        this.isHostedVespa = isHostedVespa;
    }

    @Override
    protected ContainerServiceType myServiceType() {
        ContainerCluster cluster;
        if (this.parent instanceof ContainerCluster && (cluster = (ContainerCluster)this.parent).getSearch() != null && cluster.getDocproc() == null && cluster.getDocumentApi() == null) {
            return ContainerServiceType.QRSERVER;
        }
        return ContainerServiceType.CONTAINER;
    }

    @Override
    public String getJvmOptions() {
        String jvmArgs = super.getJvmOptions();
        return this.isHostedVespa && this.hasDocproc() ? ("".equals(jvmArgs) ? defaultHostedJVMArgs : "-XX:+UseOSErrorReporting -XX:+SuppressFatalErrorMessage " + jvmArgs) : jvmArgs;
    }

    private boolean hasDocproc() {
        return this.parent instanceof ContainerCluster && ((ContainerCluster)this.parent).getDocproc() != null;
    }
}

