/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.time.Instant;
import java.util.Collections;
import java.util.List;

public class ClusterSizeReductionValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, ValidationOverrides overrides, Instant now) {
        AbstractConfigProducer nextCluster;
        for (ContainerCluster containerCluster : current.getContainerClusters().values()) {
            nextCluster = next.getContainerClusters().get(containerCluster.getName());
            if (nextCluster == null) continue;
            this.validate(containerCluster.getContainers().size(), ((ContainerCluster)nextCluster).getContainers().size(), containerCluster.getName(), overrides, now);
        }
        for (ContentCluster contentCluster : current.getContentClusters().values()) {
            nextCluster = next.getContentClusters().get(contentCluster.getName());
            if (nextCluster == null) continue;
            this.validate(contentCluster.getSearch().getSearchNodes().size(), ((ContentCluster)nextCluster).getSearch().getSearchNodes().size(), contentCluster.getName(), overrides, now);
        }
        return Collections.emptyList();
    }

    private void validate(int currentSize, int nextSize, String clusterName, ValidationOverrides overrides, Instant now) {
        if ((double)nextSize < (double)currentSize * 0.5 && nextSize != currentSize - 1) {
            overrides.invalid(ValidationId.clusterSizeReduction, "Size reduction in '" + clusterName + "' is too large. Current size: " + currentSize + ", new size: " + nextSize + ". New size must be at least 50% of the current size", now);
        }
    }
}

