/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring.builder.xml;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.admin.monitoring.DefaultMetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.DefaultVespaMetrics;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.SystemMetrics;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MetricsBuilder {
    private static final String ID_ATTRIBUTE = "id";
    private static final String DISPLAY_NAME_ATTRIBUTE = "display-name";
    private final ConfigModelContext.ApplicationType applicationType;
    private final Map<String, MetricSet> availableMetricSets;

    public MetricsBuilder(ConfigModelContext.ApplicationType applicationType, Map<String, MetricSet> availableMetricSets) {
        this.applicationType = applicationType;
        this.availableMetricSets = availableMetricSets;
    }

    public Metrics buildMetrics(Element metricsElement) {
        Metrics metrics = new Metrics();
        for (Element consumerElement : XML.getChildren((Element)metricsElement, (String)"consumer")) {
            String consumerId = consumerElement.getAttribute(ID_ATTRIBUTE);
            this.throwIfIllegalConsumerId(metrics, consumerId);
            MetricSet metricSet = this.buildMetricSet(consumerId, consumerElement);
            metrics.addConsumer(new MetricsConsumer(consumerId, metricSet));
        }
        return metrics;
    }

    private static Metric metricFromElement(Element elem) {
        String m_id = elem.getAttribute(ID_ATTRIBUTE);
        String m_dn = elem.getAttribute(DISPLAY_NAME_ATTRIBUTE);
        if (m_dn == null || "".equals(m_dn)) {
            return new Metric(m_id);
        }
        return new Metric(m_id, m_dn);
    }

    private MetricSet buildMetricSet(String consumerId, Element consumerElement) {
        List metrics = XML.getChildren((Element)consumerElement, (String)"metric").stream().map(metricElement -> MetricsBuilder.metricFromElement(metricElement)).collect(Collectors.toCollection(LinkedList::new));
        List metricSets = XML.getChildren((Element)consumerElement, (String)"metric-set").stream().map(metricSetElement -> this.availableMetricSets.get(metricSetElement.getAttribute(ID_ATTRIBUTE))).collect(Collectors.toCollection(LinkedList::new));
        metricSets.add(DefaultVespaMetrics.defaultVespaMetricSet);
        metricSets.add(SystemMetrics.systemMetricSet);
        return new MetricSet(MetricsBuilder.metricSetId(consumerId), metrics, metricSets);
    }

    private static String metricSetId(String consumerName) {
        return "user-metrics-" + consumerName;
    }

    private void throwIfIllegalConsumerId(Metrics metrics, String consumerId) {
        if (consumerId.equalsIgnoreCase(DefaultMetricsConsumer.VESPA_CONSUMER_ID) && this.applicationType != ConfigModelContext.ApplicationType.HOSTED_INFRASTRUCTURE) {
            throw new IllegalArgumentException("'Vespa' is not allowed as metrics consumer id (case is ignored.)");
        }
        if (metrics.hasConsumerIgnoreCase(consumerId)) {
            throw new IllegalArgumentException("'" + consumerId + "' is used as id for two metrics consumers (case is ignored.)");
        }
    }
}

