/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.metricsproxy;

import ai.vespa.metricsproxy.metric.dimensions.NodeDimensions;
import ai.vespa.metricsproxy.metric.dimensions.NodeDimensionsConfig;
import ai.vespa.metricsproxy.rpc.RpcConnector;
import ai.vespa.metricsproxy.rpc.RpcConnectorConfig;
import ai.vespa.metricsproxy.service.VespaServices;
import ai.vespa.metricsproxy.service.VespaServicesConfig;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.vespa.model.admin.metricsproxy.VespaServicesConfigGenerator;
import com.yahoo.vespa.model.container.Container;
import java.util.LinkedHashMap;

public class MetricsProxyContainer
extends Container
implements NodeDimensionsConfig.Producer,
RpcConnectorConfig.Producer,
VespaServicesConfig.Producer {
    private final boolean isHostedVespa;

    public MetricsProxyContainer(AbstractConfigProducer parent, int index, boolean isHostedVespa) {
        super(parent, "metricsproxy." + index, index);
        this.isHostedVespa = isHostedVespa;
        this.setProp("clustertype", "admin");
        this.setProp("index", String.valueOf(index));
        this.addNodeSpecificComponents();
    }

    private void addNodeSpecificComponents() {
        this.addMetricsProxyComponent(NodeDimensions.class);
        this.addMetricsProxyComponent(RpcConnector.class);
        this.addMetricsProxyComponent(VespaServices.class);
    }

    int metricsRpcPortOffset() {
        return this.numHttpServerPorts + this.numMessageBusPorts() + this.numRpcPorts();
    }

    @Override
    protected ContainerServiceType myServiceType() {
        return ContainerServiceType.METRICS_PROXY_CONTAINER;
    }

    @Override
    public int getWantedPort() {
        return 19092;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public boolean requiresConsecutivePorts() {
        return true;
    }

    @Override
    public int getPortCount() {
        return this.metricsRpcPortOffset() + 1;
    }

    @Override
    protected void tagServers() {
        super.tagServers();
        this.portsMeta.on(this.metricsRpcPortOffset()).tag("rpc").tag("metrics");
    }

    @Override
    public String[] getPortSuffixes() {
        String[] suffixes = super.getPortSuffixes();
        suffixes[this.metricsRpcPortOffset()] = "rpc/metrics";
        return suffixes;
    }

    public void getConfig(RpcConnectorConfig.Builder builder) {
        builder.port(this.getRelativePort(this.metricsRpcPortOffset()));
    }

    public void getConfig(VespaServicesConfig.Builder builder) {
        builder.service.addAll(VespaServicesConfigGenerator.generate(this.getHostResource().getServices()));
    }

    public void getConfig(NodeDimensionsConfig.Builder builder) {
        LinkedHashMap dimensions = new LinkedHashMap();
        if (this.isHostedVespa) {
            this.getHostResource().getFlavor().ifPresent(flavor -> {
                dimensions.put("flavor", flavor.name());
                dimensions.put("canonicalFlavor", flavor.canonicalName());
            });
            this.getHostResource().primaryClusterMembership().map(ClusterMembership::cluster).ifPresent(cluster -> {
                dimensions.put("clustertype", cluster.type().name());
                dimensions.put("clusterid", cluster.id().value());
            });
            builder.dimensions(dimensions);
        }
    }

    private void addMetricsProxyComponent(Class<?> componentClass) {
        this.addSimpleComponent(componentClass.getName(), null, "com.yahoo.vespa.metrics-proxy");
    }

    static final class NodeDimensionNames {
        static final String FLAVOR = "flavor";
        static final String CANONICAL_FLAVOR = "canonicalFlavor";
        static final String CLUSTER_TYPE = "clustertype";
        static final String CLUSTER_ID = "clusterid";

        NodeDimensionNames() {
        }
    }
}

