/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.cloud.config.log.LogdConfig;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.ConfigProxy;
import com.yahoo.vespa.model.ConfigSentinel;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.Logd;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.LogForwarder;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.admin.ZooKeepersConfigProvider;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProvider;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Admin
extends AbstractConfigProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isHostedVespa;
    private final Monitoring monitoring;
    private final Metrics metrics;
    private final List<Configserver> configservers = new ArrayList<Configserver>();
    private final List<Slobrok> slobroks = new ArrayList<Slobrok>();
    private Configserver defaultConfigserver;
    private Logserver logserver;
    private LogForwarder.Config logForwarderConfig = null;
    private ConfigModelContext.ApplicationType applicationType = ConfigModelContext.ApplicationType.DEFAULT;
    private ContainerCluster clusterControllers;
    private Optional<ContainerCluster> logServerContainerCluster = Optional.empty();
    private ZooKeepersConfigProvider zooKeepersConfigProvider;
    private FileDistributionConfigProducer fileDistribution;
    private final boolean multitenant;

    public void setLogForwarderConfig(LogForwarder.Config cfg) {
        this.logForwarderConfig = cfg;
    }

    public Admin(AbstractConfigProducer parent, Monitoring monitoring, Metrics metrics, boolean multitenant, FileDistributionConfigProducer fileDistributionConfigProducer, boolean isHostedVespa) {
        super(parent, "admin");
        this.isHostedVespa = isHostedVespa;
        this.monitoring = monitoring;
        this.metrics = metrics;
        this.multitenant = multitenant;
        this.fileDistribution = fileDistributionConfigProducer;
    }

    public Configserver getConfigserver() {
        return this.defaultConfigserver;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public Metrics getUserMetrics() {
        return this.metrics;
    }

    public List<Configserver> getConfigservers() {
        return this.configservers;
    }

    public List<ConfigServerSpec> getConfigServerSpecs() {
        ArrayList<ConfigServerSpec> serverSpecs = new ArrayList<ConfigServerSpec>();
        for (Configserver server : this.getConfigservers()) {
            serverSpecs.add(server.getConfigServerSpec());
        }
        return serverSpecs;
    }

    public void removeSlobroks() {
        this.slobroks.clear();
    }

    public List<Slobrok> getSlobroks() {
        return Collections.unmodifiableList(this.slobroks);
    }

    public void setLogserver(Logserver logserver) {
        this.logserver = logserver;
    }

    public Logserver getLogserver() {
        return this.logserver;
    }

    public void addConfigservers(List<Configserver> configservers) {
        this.configservers.addAll(configservers);
        if (this.configservers.size() > 0) {
            this.defaultConfigserver = configservers.get(0);
        }
        this.zooKeepersConfigProvider = new ZooKeepersConfigProvider(configservers);
    }

    public void addSlobroks(List<Slobrok> slobroks) {
        this.slobroks.addAll(slobroks);
    }

    public ContainerCluster getClusterControllers() {
        return this.clusterControllers;
    }

    public void setClusterControllers(ContainerCluster clusterControllers) {
        if (this.multitenant) {
            throw new RuntimeException("Should not use admin cluster controller in a multitenant environment");
        }
        this.clusterControllers = clusterControllers;
    }

    public Optional<ContainerCluster> getLogServerContainerCluster() {
        return this.logServerContainerCluster;
    }

    public void setLogserverContainerCluster(ContainerCluster logServerContainerCluster) {
        this.logServerContainerCluster = Optional.of(logServerContainerCluster);
    }

    public ZooKeepersConfigProvider getZooKeepersConfigProvider() {
        return this.zooKeepersConfigProvider;
    }

    public void getConfig(LogdConfig.Builder builder) {
        builder.logserver(new LogdConfig.Logserver.Builder().use(this.logServerContainerCluster.isPresent() || !this.isHostedVespa).host(this.logserver.getHostName()).port(this.logserver.getRelativePort(1)));
    }

    public void getConfig(SlobroksConfig.Builder builder) {
        for (Slobrok slob : this.slobroks) {
            builder.slobrok(new SlobroksConfig.Slobrok.Builder().connectionspec(slob.getConnectionSpec()));
        }
    }

    public void getConfig(ZookeepersConfig.Builder builder) {
        this.zooKeepersConfigProvider.getConfig(builder);
    }

    public FileDistributionConfigProducer getFileDistributionConfigProducer() {
        return this.fileDistribution;
    }

    public List<HostResource> getClusterControllerHosts() {
        ArrayList<HostResource> hosts = new ArrayList<HostResource>();
        if (this.multitenant) {
            if (this.logserver != null) {
                hosts.add(this.logserver.getHostResource());
            }
        } else {
            for (Configserver configserver : this.getConfigservers()) {
                hosts.add(configserver.getHostResource());
            }
        }
        return hosts;
    }

    public void addPerHostServices(List<HostResource> hosts, DeployState deployState) {
        if (this.slobroks.isEmpty()) {
            this.slobroks.addAll(this.createDefaultSlobrokSetup(deployState.getDeployLogger()));
        }
        for (HostResource host : hosts) {
            if (host.getHost().runsConfigServer()) continue;
            this.addCommonServices(host, deployState);
        }
    }

    private void addCommonServices(HostResource host, DeployState deployState) {
        this.addConfigSentinel(deployState.getDeployLogger(), host, deployState.getProperties().applicationId(), deployState.zone());
        this.addLogd(deployState.getDeployLogger(), host);
        this.addConfigProxy(deployState.getDeployLogger(), host);
        this.addFileDistribution(host);
        if (this.logForwarderConfig != null) {
            this.addLogForwarder(deployState.getDeployLogger(), host);
        }
    }

    private void addConfigSentinel(DeployLogger deployLogger, HostResource host, ApplicationId applicationId, Zone zone) {
        ConfigSentinel configSentinel = new ConfigSentinel(host.getHost(), applicationId, zone);
        this.addAndInitializeService(deployLogger, host, configSentinel);
        host.getHost().setConfigSentinel(configSentinel);
    }

    private void addLogForwarder(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new LogForwarder((AbstractConfigProducer)host.getHost(), this.logForwarderConfig));
    }

    private void addLogd(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new Logd(host.getHost()));
    }

    private void addConfigProxy(DeployLogger deployLogger, HostResource host) {
        this.addAndInitializeService(deployLogger, host, new ConfigProxy(host.getHost()));
    }

    public void addAndInitializeService(DeployLogger deployLogger, HostResource host, AbstractService service) {
        service.setHostResource(host);
        service.initService(deployLogger);
    }

    private void addFileDistribution(HostResource host) {
        FileDistributor fileDistributor = this.fileDistribution.getFileDistributor();
        HostResource deployHost = this.getHostSystem().getHostByHostname(fileDistributor.fileSourceHost());
        if (this.deployHostIsMissing(deployHost)) {
            throw new RuntimeException("Could not find host in the application's host system: '" + fileDistributor.fileSourceHost() + "'. Hostsystem=" + this.getHostSystem());
        }
        FileDistributionConfigProvider configProvider = new FileDistributionConfigProvider(this.fileDistribution, fileDistributor, host == deployHost, host.getHost());
        this.fileDistribution.addFileDistributionConfigProducer(host.getHost(), configProvider);
    }

    private boolean deployHostIsMissing(HostResource deployHost) {
        return !this.multitenant && deployHost == null;
    }

    private List<Slobrok> createDefaultSlobrokSetup(DeployLogger deployLogger) {
        List<HostResource> hosts = this.getHostSystem().getHosts();
        ArrayList<Slobrok> slobs = new ArrayList<Slobrok>();
        if (this.logserver != null) {
            Slobrok slobrok = new Slobrok((AbstractConfigProducer)this, 0);
            this.addAndInitializeService(deployLogger, this.logserver.getHostResource(), slobrok);
            slobs.add(slobrok);
        }
        for (int n = 0; n < hosts.size() && slobs.size() < 3; ++n) {
            HostResource host = hosts.get(n);
            if (this.logserver != null && host == this.logserver.getHostResource() || host.getHost().runsConfigServer()) continue;
            Slobrok newSlobrok = new Slobrok((AbstractConfigProducer)this, slobs.size());
            this.addAndInitializeService(deployLogger, host, newSlobrok);
            slobs.add(newSlobrok);
        }
        int j = 0;
        for (Slobrok s : slobs) {
            s.setProp("index", j);
            ++j;
        }
        return slobs;
    }

    public boolean multitenant() {
        return this.multitenant;
    }

    public void setApplicationType(ConfigModelContext.ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public ConfigModelContext.ApplicationType getApplicationType() {
        return this.applicationType;
    }
}

