/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.text.Lowercase;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigModelUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Pattern hourNmin = Pattern.compile("(\\d\\d):(\\d\\d)");
    public static Map<String, Integer> day2int = new HashMap<String, Integer>();

    public static int getTimeOfDay(String time) {
        Matcher m = hourNmin.matcher(time);
        if (m.matches()) {
            return Integer.parseInt(m.group(1)) * 60 + Integer.parseInt(m.group(2));
        }
        throw new IllegalArgumentException("The string '" + time + "' is not in ##:## format.");
    }

    public static int getDayOfWeek(String day) {
        return day2int.get(Lowercase.toLowerCase((String)day));
    }

    static {
        day2int.put("sunday", 0);
        day2int.put("monday", 1);
        day2int.put("tuesday", 2);
        day2int.put("wednesday", 3);
        day2int.put("thursday", 4);
        day2int.put("friday", 5);
        day2int.put("saturday", 6);
    }
}

