/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.TypedTransformProvider;
import com.yahoo.vespa.indexinglanguage.ExpressionSearcher;
import com.yahoo.vespa.indexinglanguage.expressions.ExactExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class ExactMatch
extends Processor {
    public static final String DEFAULT_EXACT_TERMINATOR = "@@";

    ExactMatch(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            this.processField(field, this.schema);
        }
    }

    private void processField(SDField field, Schema schema) {
        Matching.Type matching = field.getMatching().getType();
        if (matching.equals((Object)Matching.Type.EXACT) || matching.equals((Object)Matching.Type.WORD)) {
            this.implementExactMatch(field, schema);
        } else if (field.getMatching().getExactMatchTerminator() != null) {
            this.warn(schema, field, "exact-terminator requires 'exact' matching to have any effect.");
        }
        for (SDField structField : field.getStructFields()) {
            this.processField(structField, schema);
        }
    }

    private void implementExactMatch(SDField field, Schema schema) {
        field.setStemming(Stemming.NONE);
        field.getNormalizing().inferLowercase();
        if (field.getMatching().getType().equals((Object)Matching.Type.WORD)) {
            field.addQueryCommand("word");
        } else {
            String exactTerminator = DEFAULT_EXACT_TERMINATOR;
            if (field.getMatching().getExactMatchTerminator() != null && !field.getMatching().getExactMatchTerminator().equals("")) {
                exactTerminator = field.getMatching().getExactMatchTerminator();
            } else {
                this.info(schema, field, "With 'exact' matching, an exact-terminator is needed, using default value '" + exactTerminator + "' as terminator");
            }
            field.addQueryCommand("exact " + exactTerminator);
            if (field.doesIndexing()) {
                this.exactMatchSettingsForField(field);
            }
        }
        ScriptExpression script = field.getIndexingScript();
        if (new ExpressionSearcher(IndexExpression.class).containedIn((Expression)script)) {
            field.setIndexingScript((ScriptExpression)new MyProvider(schema).convert((Expression)field.getIndexingScript()));
        }
    }

    private void exactMatchSettingsForField(SDField field) {
        field.getRanking().setFilter(true);
    }

    private static class MyProvider
    extends TypedTransformProvider {
        MyProvider(Schema schema) {
            super(ExactExpression.class, schema);
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            ExactExpression exp = new ExactExpression();
            if (fieldType instanceof CollectionDataType) {
                exp = new ForEachExpression((Expression)exp);
            }
            return exp;
        }
    }
}

