/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.processing.MatchPhaseSettingsValidator;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DiversitySettingsValidator
extends Processor {
    public DiversitySettingsValidator(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        if (documentsOnly) {
            return;
        }
        for (RankProfile rankProfile : this.rankProfileRegistry.rankProfilesOf(this.schema.getName())) {
            if (rankProfile.getMatchPhaseSettings() == null || rankProfile.getMatchPhaseSettings().getDiversity() == null) continue;
            this.validate(rankProfile, rankProfile.getMatchPhaseSettings().getDiversity());
        }
    }

    private void validate(RankProfile rankProfile, RankProfile.DiversitySettings settings) {
        String attributeName = settings.getAttribute();
        new AttributeValidator(this.schema.getName(), rankProfile.getName(), this.schema.getAttribute(attributeName), attributeName).validate();
    }

    private static class AttributeValidator
    extends MatchPhaseSettingsValidator.AttributeValidator {
        public AttributeValidator(String searchName, String rankProfileName, Attribute attribute, String attributeName) {
            super(searchName, rankProfileName, attribute, attributeName);
        }

        protected void validateThatAttributeIsSingleAndNotPredicate() {
            if (!this.attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE) || this.attribute.getType().equals((Object)Attribute.Type.PREDICATE)) {
                this.failValidation("must be single value numeric, or enumerated attribute, but it is '" + this.attribute.getDataType().getName() + "'");
            }
        }

        @Override
        public void validate() {
            this.validateThatAttributeExists();
            this.validateThatAttributeIsSingleAndNotPredicate();
        }

        @Override
        public String getValidationType() {
            return "diversity";
        }
    }
}

