/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class BuiltInFieldSets
extends Processor {
    public static final String SEARCH_FIELDSET_NAME = "[search]";
    public static final String INTERNAL_FIELDSET_NAME = "[internal]";

    public BuiltInFieldSets(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.addDocumentFieldSet();
        this.addSearchFieldSet();
        this.schema.getDocument().setFieldSets(this.schema.fieldSets());
    }

    private void addSearchFieldSet() {
        for (SDField searchField : this.schema.extraFieldList()) {
            this.schema.fieldSets().addBuiltInFieldSetItem(SEARCH_FIELDSET_NAME, searchField.getName());
        }
    }

    private void addDocumentFieldSet() {
        for (Field docField : this.schema.getDocument().fieldSet()) {
            if (docField instanceof SDField && ((SDField)docField).isExtraField()) continue;
            this.schema.fieldSets().addBuiltInFieldSetItem("[document]", docField.getName());
        }
    }
}

