/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AttributeProperties
extends Processor {
    public AttributeProperties(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (ImmutableSDField immutableSDField : this.schema.allConcreteFields()) {
            String fieldName = immutableSDField.getName();
            for (Attribute attribute : immutableSDField.getAttributes().values()) {
                if (AttributeProperties.attributeCreated(immutableSDField, attribute.getName())) continue;
                boolean created = false;
                for (SDField f : this.schema.allConcreteFields()) {
                    if (f.getName().equals(fieldName) || !AttributeProperties.attributeCreated(f, attribute.getName())) continue;
                    created = true;
                    break;
                }
                if (!validate || created) continue;
                throw new IllegalArgumentException("Attribute '" + attribute.getName() + "' in field '" + immutableSDField.getName() + "' is not created by the indexing statement");
            }
        }
    }

    static boolean attributeCreated(ImmutableSDField field, String attributeName) {
        if (!field.doesAttributing()) {
            return false;
        }
        for (Attribute attribute : field.getAttributes().values()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }
}

