/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.compress.CompressionType;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.document.CompressionConfig;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.searchdefinition.Application;
import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.DocumentOnlySchema;
import com.yahoo.searchdefinition.DocumentsOnlyRankProfile;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import com.yahoo.searchdefinition.document.Case;
import com.yahoo.searchdefinition.document.HnswIndexParams;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Sorting;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.document.TemporaryImportedField;
import com.yahoo.searchdefinition.document.TemporaryImportedFields;
import com.yahoo.searchdefinition.document.TemporarySDField;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.searchdefinition.document.annotation.TemporaryAnnotationReferenceDataType;
import com.yahoo.searchdefinition.fieldoperation.AliasOperation;
import com.yahoo.searchdefinition.fieldoperation.AttributeOperation;
import com.yahoo.searchdefinition.fieldoperation.BoldingOperation;
import com.yahoo.searchdefinition.fieldoperation.DictionaryOperation;
import com.yahoo.searchdefinition.fieldoperation.FieldOperationContainer;
import com.yahoo.searchdefinition.fieldoperation.IdOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexingOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexingRewriteOperation;
import com.yahoo.searchdefinition.fieldoperation.MatchOperation;
import com.yahoo.searchdefinition.fieldoperation.NormalizingOperation;
import com.yahoo.searchdefinition.fieldoperation.QueryCommandOperation;
import com.yahoo.searchdefinition.fieldoperation.RankOperation;
import com.yahoo.searchdefinition.fieldoperation.RankTypeOperation;
import com.yahoo.searchdefinition.fieldoperation.SortingOperation;
import com.yahoo.searchdefinition.fieldoperation.StemmingOperation;
import com.yahoo.searchdefinition.fieldoperation.StructFieldOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldLongOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldShortOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryToOperation;
import com.yahoo.searchdefinition.fieldoperation.WeightOperation;
import com.yahoo.searchdefinition.fieldoperation.WeightedSetOperation;
import com.yahoo.searchdefinition.parser.CharStream;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.SDParserConstants;
import com.yahoo.searchdefinition.parser.SDParserTokenManager;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.Token;
import com.yahoo.searchdefinition.parser.Utils;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;

public class SDParser
implements SDParserConstants {
    private DocumentTypeManager docMan = null;
    private Application application;
    private FileRegistry fileRegistry;
    private DeployLogger deployLogger;
    private ModelContext.Properties properties;
    private RankProfileRegistry rankProfileRegistry;
    private boolean documentsOnly;
    public SDParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[194];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SDParser(SimpleCharStream stream, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, Application application, RankProfileRegistry rankProfileRegistry, boolean documentsOnly) {
        this(stream);
        this.fileRegistry = fileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.application = application;
        this.rankProfileRegistry = rankProfileRegistry;
        this.documentsOnly = documentsOnly;
    }

    private IndexingOperation newIndexingOperation(boolean multiline) throws ParseException {
        return this.newIndexingOperation(multiline, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexingOperation newIndexingOperation(boolean multiline, Linguistics linguistics, Embedder embedder) throws ParseException {
        SimpleCharStream input = (SimpleCharStream)this.token_source.input_stream;
        if (this.token.next != null) {
            input.backup(this.token.next.image.length());
        }
        try {
            IndexingOperation indexingOperation = IndexingOperation.fromStream(input, multiline, linguistics, embedder);
            return indexingOperation;
        }
        finally {
            this.token.next = null;
            this.jj_ntk = -1;
        }
    }

    private FeatureList getFeatureList(String image) throws ParseException {
        try {
            return new FeatureList(image);
        }
        catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
            throw (ParseException)new ParseException("Could not parse feature list '" + image + "' at line " + this.token_source.input_stream.getBeginLine() + ", column " + this.token_source.input_stream.getBeginColumn() + ".").initCause(e);
        }
    }

    private void setCompressionThreshold(CompressionConfig cfg, int val) {
        cfg.threshold = val;
    }

    private void setCompressionLevel(CompressionConfig cfg, int val) {
        cfg.compressionLevel = val;
    }

    public final Schema schema(DocumentTypeManager docMan, String dir) throws ParseException {
        Schema schema;
        this.docMan = docMan;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: 
            case 9: {
                schema = this.rootSchema(dir);
                break;
            }
            case 0: 
            case 16: {
                schema = this.rootDocument(dir);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return schema;
    }

    public final Schema rootSchema(String dir) throws ParseException {
        String inherited = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                inherited = this.identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Schema schema = new Schema(name, Optional.ofNullable(inherited), this.application, this.fileRegistry, this.deployLogger, this.properties);
        this.rankProfileRegistry.add(new DefaultRankProfile(schema, this.rankProfileRegistry, schema.rankingConstants()));
        this.rankProfileRegistry.add(new UnrankedRankProfile(schema, this.rankProfileRegistry, schema.rankingConstants()));
        this.lbrace();
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 16: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 32: 
                case 36: 
                case 46: 
                case 47: 
                case 48: 
                case 50: 
                case 53: 
                case 83: 
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block16;
                }
            }
            this.rootSchemaItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        continue block16;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final Object rootSchemaItem(Schema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.document(schema);
                break;
            }
            case 53: {
                this.rawAsBase64(schema);
                break;
            }
            case 32: {
                this.documentSummary(schema);
                break;
            }
            case 24: {
                this.field(null, schema);
                break;
            }
            case 36: {
                this.index(schema, null);
                break;
            }
            case 46: {
                this.rankingConstant(schema);
                break;
            }
            case 48: 
            case 50: {
                this.rankProfile(schema);
                break;
            }
            case 83: {
                this.searchStemming(schema);
                break;
            }
            case 132: {
                this.useDocument(schema);
                break;
            }
            case 22: {
                this.structOutside(schema);
                break;
            }
            case 6: {
                this.annotationOutside(schema);
                break;
            }
            case 26: {
                this.fieldSet(schema);
                break;
            }
            case 28: {
                this.importField(schema);
                break;
            }
            case 47: {
                this.onnxModel(schema);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Schema rootDocument(String dir) throws ParseException {
        DocumentOnlySchema schema = new DocumentOnlySchema(this.application, this.fileRegistry, this.deployLogger, this.properties);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block6;
                }
            }
            this.rootDocumentItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final Object rootDocumentItem(Schema schema) throws ParseException {
        this.namedDocument(schema);
        return null;
    }

    public final void useDocument(Schema schema) throws ParseException {
        this.jj_consume_token(132);
        this.jj_consume_token(135);
        this.identifier();
    }

    public final void document(Schema schema) throws ParseException {
        String name = schema.getName();
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(5);
        }
        SDDocumentType document = new SDDocumentType(name, schema);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(133);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(5);
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: 
                case 90: 
                case 91: 
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block24;
                }
            }
            this.documentBody(document, schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        continue block24;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        schema.addDocument(document);
    }

    public final void namedDocument(Schema schema) throws ParseException {
        this.jj_consume_token(16);
        String name = this.identifier();
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        SDDocumentType document = new SDDocumentType(name, schema);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(133);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(5);
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: 
                case 90: 
                case 91: 
                case 128: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block21;
                }
            }
            this.documentBody(document, schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        continue block21;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        schema.addDocument(document);
    }

    public final Object documentBody(SDDocumentType document, Schema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.annotation(schema, document);
                break;
            }
            case 128: {
                this.compression(document, null);
                break;
            }
            case 91: {
                this.headercfg(document);
                break;
            }
            case 90: {
                this.bodycfg(document);
                break;
            }
            case 22: {
                this.structInside(document, schema);
                break;
            }
            case 24: {
                this.field(document, schema);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void rawAsBase64(Schema schema) throws ParseException {
        this.jj_consume_token(53);
        schema.enableRawAsBase64();
    }

    public final void headercfg(SDDocumentType document) throws ParseException {
        this.jj_consume_token(91);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 128: {
                this.compression(document, "header");
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
    }

    public final void bodycfg(SDDocumentType document) throws ParseException {
        this.jj_consume_token(90);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 128: {
                this.compression(document, "body");
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
    }

    public final void compression(SDDocumentType document, String name) throws ParseException {
        this.deployLogger.logApplicationPackage(Level.WARNING, "'compression' for a document is deprecated and ignored");
        CompressionConfig cfg = new CompressionConfig(CompressionType.LZ4);
        this.jj_consume_token(128);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 129: 
                case 130: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            cfg = this.compressionItem(cfg);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        if (name == null || name.equals("header")) {
            document.getDocumentType().contentStruct().setCompressionConfig(cfg);
        }
    }

    public final CompressionConfig compressionItem(CompressionConfig cfg) throws ParseException {
        int val = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(135);
                this.jj_consume_token(131);
                cfg = new CompressionConfig(CompressionType.LZ4, cfg.compressionLevel, cfg.threshold);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                this.jj_consume_token(135);
                val = this.integer();
                this.setCompressionThreshold(cfg, val);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                this.jj_consume_token(135);
                val = this.integer();
                this.setCompressionLevel(cfg, val);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cfg;
    }

    public final void inheritsDocument(SDDocumentType document) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        document.inherit(new DataTypeName(name));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(137);
            name = this.identifier();
            document.inherit(new DataTypeName(name));
        }
    }

    public final void field(SDDocumentType document, Schema schema) throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        DataType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        TemporarySDField field = new TemporarySDField(name, type, document);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 34: 
                case 36: 
                case 57: 
                case 67: 
                case 68: 
                case 69: 
                case 83: 
                case 84: 
                case 89: 
                case 90: 
                case 91: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 107: 
                case 109: 
                case 139: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block6;
                }
            }
            this.fieldBody(field, schema, document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        if (document != null) {
            document.addField(field);
        } else {
            schema.addExtraField(field);
        }
    }

    public final void fieldSet(Schema schema) throws ParseException {
        ArrayList<String> queryCommands = new ArrayList<String>();
        ArrayList<FieldOperationContainer> matchSettings = new ArrayList<FieldOperationContainer>();
        this.jj_consume_token(26);
        String setName = this.identifier();
        this.lbrace();
        block18: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    this.jj_consume_token(135);
                    String field = this.identifier();
                    schema.fieldSets().addUserFieldSetItem(setName, field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 137: {
                                break;
                            }
                            default: {
                                this.jj_la1[34] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(137);
                        field = this.identifier();
                        schema.fieldSets().addUserFieldSetItem(setName, field);
                    }
                }
                case 98: {
                    String queryCommand;
                    this.jj_consume_token(98);
                    this.jj_consume_token(135);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 16: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 48: 
                        case 50: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 132: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 181: 
                        case 182: 
                        case 187: 
                        case 188: 
                        case 189: 
                        case 190: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 195: 
                        case 196: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 205: {
                            queryCommand = this.identifierWithDash();
                            break;
                        }
                        case 194: {
                            queryCommand = this.quotedString();
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    queryCommands.add(queryCommand);
                    break;
                }
                case 100: {
                    FieldOperationContainer matchSetting = this.match(new SDField(setName, (DataType)DataType.STRING));
                    matchSettings.add(matchSetting);
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: 
                case 98: 
                case 100: {
                    continue block18;
                }
            }
            break;
        }
        this.jj_la1[38] = this.jj_gen;
        this.jj_consume_token(134);
        for (Object e : queryCommands) {
            schema.fieldSets().userFieldSets().get(setName).queryCommands().add((String)e);
        }
        for (Object e : matchSettings) {
            ((SDField)e).applyOperations();
            schema.fieldSets().userFieldSets().get(setName).setMatching(((SDField)e).getMatching());
        }
    }

    public final void annotationOutside(Schema schema) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        SDAnnotationType type = new SDAnnotationType(name.trim());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        this.lbrace();
        type = this.annotationBody(schema, type);
        this.jj_consume_token(134);
        if (schema.getDocument() == null) {
            throw new IllegalArgumentException("Can't add annotation '" + name + "' to a document type, define a document type first or declare the annotation inside of one.");
        }
        schema.addAnnotation(type);
    }

    public final void annotation(Schema schema, SDDocumentType document) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        SDAnnotationType type = new SDAnnotationType(name.trim());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        this.lbrace();
        type = this.annotationBody(schema, type);
        this.jj_consume_token(134);
        document.addAnnotation(type);
    }

    public final SDAnnotationType annotationBody(Schema schema, SDAnnotationType type) throws ParseException {
        SDDocumentType struct = new SDDocumentType("annotation." + type.getName(), schema);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        if (struct.getFieldCount() > 0) {
            type = new SDAnnotationType(type.getName(), struct, type.getInherits());
            struct.setStruct(null);
        }
        return type;
    }

    public final void inheritsAnnotation(SDAnnotationType annotation) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        annotation.inherit(name);
    }

    public final void structInside(SDDocumentType document, Schema schema) throws ParseException {
        SDDocumentType struct = this.structDefinition(schema, document);
        document.addType(struct);
    }

    public final void structOutside(Schema schema) throws ParseException {
        SDDocumentType struct = this.structDefinition(schema, schema.getDocument());
        schema.addType(struct);
    }

    public final SDDocumentType structDefinition(Schema schema, SDDocumentType repo) throws ParseException {
        this.jj_consume_token(22);
        String name = this.identifier();
        SDDocumentType struct = new SDDocumentType(name, schema);
        this.lbrace();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block8;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        continue block8;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        try {
            this.docMan.getDataType(name);
            throw new ParseException("Reserved name '" + name + "' can not be used to declare a struct.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (repo == null) {
                throw new IllegalArgumentException("Can't add struct '" + name + "' to a document type, define a document type first or declare the struct inside of one.");
            }
            SDDocumentType sdtype = repo.getOwnedType(struct.getDocumentName());
            DataType stype = sdtype != null ? sdtype.getStruct() : TemporaryStructuredDataType.create((String)struct.getName());
            struct.setStruct(stype);
            return struct;
        }
    }

    public final DataType dataType() throws ParseException {
        String typeName = null;
        boolean isArrayOldStyle = false;
        DataType mapType = null;
        DataType arrayType = null;
        DataType wsetType = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(138);
            this.jj_consume_token(203);
            arrayType = this.dataType();
            this.jj_consume_token(204);
            return DataType.getArray((DataType)arrayType);
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(139);
            this.jj_consume_token(203);
            wsetType = this.dataType();
            this.jj_consume_token(204);
            return DataType.getWeightedSet((DataType)wsetType);
        }
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            mapType = this.mapDataType();
            return mapType;
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            mapType = this.annotationRefDataType();
            return mapType;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            TensorType tensorType = this.tensorType("Field type");
            return DataType.getTensor((TensorType)tensorType);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(141);
            this.jj_consume_token(203);
            TemporaryStructuredDataType referenceType = this.referenceType();
            this.jj_consume_token(204);
            return ReferenceDataType.createWithInferredId((TemporaryStructuredDataType)referenceType);
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                typeName = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 209: {
                        this.jj_consume_token(209);
                        isArrayOldStyle = true;
                        break block0;
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataType type = VespaDocumentType.INSTANCE.getDataType(typeName);
        if (type == null) {
            type = TemporaryStructuredDataType.create((String)typeName);
        }
        if (isArrayOldStyle) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Data type syntax '" + typeName + "[]' is deprecated, use 'array<" + typeName + ">' instead.");
            type = DataType.getArray((DataType)type);
        }
        if ("tag".equalsIgnoreCase(typeName) && type instanceof WeightedSetDataType) {
            ((WeightedSetDataType)type).setTag(true);
        }
        return type;
    }

    public final TemporaryStructuredDataType referenceType() throws ParseException {
        String documentName = this.identifier();
        return TemporaryStructuredDataType.create((String)documentName);
    }

    public final DataType annotationRefDataType() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(203);
        String targetName = this.identifier();
        this.jj_consume_token(204);
        return new TemporaryAnnotationReferenceDataType(targetName);
    }

    public final DataType mapDataType() throws ParseException {
        this.jj_consume_token(140);
        this.jj_consume_token(203);
        DataType keyType = this.dataType();
        this.jj_consume_token(137);
        DataType valType = this.dataType();
        this.jj_consume_token(204);
        return DataType.getMap((DataType)keyType, (DataType)valType);
    }

    public final DataType wildCardType() throws ParseException {
        this.jj_consume_token(142);
        return DataType.NONE;
    }

    public final void structFieldDefinition(SDDocumentType struct) throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        DataType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        TemporarySDField field = new TemporarySDField(name, type, struct);
        struct.addField(field);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.id(field, struct);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block13;
                }
            }
            this.match(field);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
    }

    public final void structField(FieldOperationContainer field, Schema schema, SDDocumentType document) throws ParseException {
        this.jj_consume_token(27);
        String name = this.identifier();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        StructFieldOperation structFieldOp = new StructFieldOperation(name);
        field.addOperation(structFieldOp);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 57: 
                case 67: 
                case 98: 
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldBody(structFieldOp, schema, document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
    }

    public final String fieldBody(SDField field, Schema schema, SDDocumentType document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                this.alias(field);
                break;
            }
            case 67: {
                this.attribute(field);
                break;
            }
            case 90: {
                this.body(field);
                break;
            }
            case 89: {
                this.bolding(field);
                break;
            }
            case 69: {
                this.dictionary(field);
                break;
            }
            case 83: {
                this.fieldStemming(field);
                break;
            }
            case 91: {
                this.header(field);
                break;
            }
            case 109: {
                this.id(field, document);
                break;
            }
            case 57: {
                this.summaryInField(field);
                break;
            }
            case 36: {
                this.index(schema, field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 107: {
                this.indexingRewrite(field);
                break;
            }
            case 100: {
                this.match(field);
                break;
            }
            case 84: {
                this.normalizing(field);
                break;
            }
            case 98: {
                this.queryCommand(field);
                break;
            }
            case 101: {
                this.rank(field);
                break;
            }
            case 33: {
                this.rankType(field);
                break;
            }
            case 68: {
                this.sorting(field, field.getName());
                break;
            }
            case 27: {
                this.structField(field, schema, document);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            case 34: {
                this.weight(field);
                break;
            }
            case 139: {
                this.weightedset(field);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final String structFieldBody(FieldOperationContainer field, Schema schema, SDDocumentType document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                this.summaryInField(field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 67: {
                this.attribute(field);
                break;
            }
            case 100: {
                this.match(field);
                break;
            }
            case 98: {
                this.queryCommand(field);
                break;
            }
            case 27: {
                this.structField(field, schema, document);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object indexing(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(30);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.indexingOperation(field, false);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
                this.indexingOperation(field, true);
            }
        }
        return null;
    }

    public final void indexingOperation(FieldOperationContainer field, boolean multiLine) throws ParseException {
        field.addOperation(this.newIndexingOperation(multiLine));
    }

    public final void summaryTo(FieldOperationContainer field) throws ParseException {
        SummaryToOperation op = new SummaryToOperation();
        String name = field.getName();
        this.jj_consume_token(31);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.jj_consume_token(135);
        String destination = this.identifier();
        op.setName(name);
        op.addDestination(destination);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(137);
            destination = this.identifier();
            op.addDestination(destination);
        }
        field.addOperation(op);
    }

    public final void weight(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(135);
        int num = this.integer();
        WeightOperation op = new WeightOperation();
        op.setWeight(num);
        field.addOperation(op);
    }

    public final Object weightedset(FieldOperationContainer field) throws ParseException {
        WeightedSetOperation op = new WeightedSetOperation();
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.weightedsetBody(op);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 143: 
                        case 144: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.weightedsetBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[61] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object weightedsetBody(WeightedSetOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 143: {
                this.jj_consume_token(143);
                field.setCreateIfNonExistent(true);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                field.setRemoveIfZero(true);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void rankType(FieldOperationContainer field) throws ParseException {
        String indexName = null;
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        this.jj_consume_token(135);
        String typeName = this.identifier();
        RankTypeOperation op = new RankTypeOperation();
        op.setType(RankType.fromString(typeName));
        op.setIndexName(indexName);
        field.addOperation(op);
    }

    public final Object attribute(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        this.jj_consume_token(67);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        AttributeOperation op = new AttributeOperation(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.attributeSetting(field, op, name);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 68: 
                        case 99: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 162: {
                            break;
                        }
                        default: {
                            this.jj_la1[66] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.attributeSetting(field, op, name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[67] = this.jj_gen;
                                continue block13;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object sorting(FieldOperationContainer field, String name) throws ParseException {
        SortingOperation op = new SortingOperation(name);
        this.jj_consume_token(68);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.sortingSetting(op, name);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 70: 
                        case 71: 
                        case 75: 
                        case 76: 
                        case 77: {
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.sortingSetting(op, name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object sortingSetting(SortingOperation sorting, String attributeName) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                sorting.setAscending();
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                sorting.setDescending();
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 72: {
                        this.jj_consume_token(72);
                        sorting.setFunction(Sorting.Function.UCA);
                        break block0;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        sorting.setFunction(Sorting.Function.RAW);
                        break block0;
                    }
                    case 74: {
                        this.jj_consume_token(74);
                        sorting.setFunction(Sorting.Function.LOWERCASE);
                        break block0;
                    }
                }
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 78: {
                        this.jj_consume_token(78);
                        sorting.setStrength(Sorting.Strength.PRIMARY);
                        break block0;
                    }
                    case 79: {
                        this.jj_consume_token(79);
                        sorting.setStrength(Sorting.Strength.SECONDARY);
                        break block0;
                    }
                    case 80: {
                        this.jj_consume_token(80);
                        sorting.setStrength(Sorting.Strength.TERTIARY);
                        break block0;
                    }
                    case 81: {
                        this.jj_consume_token(81);
                        sorting.setStrength(Sorting.Strength.QUATERNARY);
                        break block0;
                    }
                    case 82: {
                        this.jj_consume_token(82);
                        sorting.setStrength(Sorting.Strength.IDENTICAL);
                        break block0;
                    }
                }
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 76: {
                this.jj_consume_token(76);
                this.jj_consume_token(135);
                String locale = this.identifierWithDash();
                sorting.setLocale(locale);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object attributeSetting(FieldOperationContainer field, AttributeOperation attribute, String attributeName) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 124: {
                this.jj_consume_token(124);
                attribute.setHuge(true);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                attribute.setFastSearch(true);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                attribute.setFastAccess(true);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                attribute.setMutable(true);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                attribute.setPaged(true);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                attribute.setEnableBitVectors(true);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                attribute.setEnableOnlyBitVector(true);
                break;
            }
            case 68: {
                this.sorting(field, attributeName);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                String aliasedName = attributeName;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 16: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 48: 
                    case 50: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 132: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 181: 
                    case 182: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 205: {
                        aliasedName = this.identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[75] = this.jj_gen;
                    }
                }
                this.jj_consume_token(135);
                String alias = this.identifierWithDash();
                attribute.setDoAlias(true);
                attribute.setAlias(alias);
                attribute.setAliasedName(aliasedName);
                break;
            }
            case 125: {
                this.attributeTensorType(attribute);
                break;
            }
            case 162: {
                this.jj_consume_token(162);
                this.jj_consume_token(135);
                String str = this.identifierWithDash();
                attribute.setDistanceMetric(str);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object attributeTensorType(AttributeOperation attribute) throws ParseException {
        TensorType tensorType = this.tensorType("For attribute field '" + attribute.getName() + "'");
        this.deployLogger.logApplicationPackage(Level.WARNING, "In field '" + attribute.getName() + "': Specifying tensor type on the attribute is deprecated and has no effect.");
        return null;
    }

    public final Object summaryInDocument(DocumentSummary document) throws ParseException {
        this.jj_consume_token(57);
        String name = this.identifierWithDash();
        this.jj_consume_token(35);
        DataType type = this.dataType();
        SummaryField summary = new SummaryField(name, type);
        summary.setVsmCommand(SummaryField.VsmCommand.FLATTENSPACE);
        SummaryInFieldLongOperation op = new SummaryInFieldLongOperation();
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 66: 
                case 89: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block6;
                }
            }
            this.summaryItem(op);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        if (op.destinationIterator().hasNext()) {
            throw new ParseException("Summaries defined in a document-summary section can not have a 'to' line.");
        }
        op.applyToSummary(summary);
        document.add(summary);
        return null;
    }

    public final Object summaryInField(FieldOperationContainer field) throws ParseException {
        SummaryInFieldOperation summary;
        this.jj_consume_token(57);
        if (this.jj_2_7(2)) {
            summary = this.summaryInFieldShort(field);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 48: 
                case 50: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 181: 
                case 182: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 205: {
                    summary = this.summaryInFieldLong(field);
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        field.addOperation(summary);
        return null;
    }

    public final SummaryInFieldOperation summaryInFieldShort(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        SummaryInFieldShortOperation op = new SummaryInFieldShortOperation(name);
        this.jj_consume_token(135);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                op.setTransform(SummaryTransform.DYNAMICTEASER);
                op.addSource(name);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                op.setTransform(SummaryTransform.MATCHED_ELEMENTS_FILTER);
                break;
            }
            case 58: 
            case 59: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                op.setTransform(SummaryTransform.NONE);
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return op;
    }

    public final SummaryInFieldOperation summaryInFieldLong(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        DataType type = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                name = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        type = this.dataType();
                        break block0;
                    }
                }
                this.jj_la1[83] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        this.lbrace();
        SummaryInFieldLongOperation op = new SummaryInFieldLongOperation(name);
        op.setType(type);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 66: 
                case 89: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block12;
                }
            }
            this.summaryItem(op);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        continue block12;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        return op;
    }

    public final Object summaryItem(SummaryInFieldLongOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.summaryTransform(field);
                break;
            }
            case 89: {
                this.summaryBolding(field);
                break;
            }
            case 110: {
                this.summarySourceList(field);
                break;
            }
            case 111: {
                this.summaryDestinationList(field);
                break;
            }
            case 66: {
                this.summaryProperties(field);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object summaryTransform(SummaryInFieldOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.jj_consume_token(60);
                field.setTransform(SummaryTransform.DYNAMICTEASER);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                field.setTransform(SummaryTransform.MATCHED_ELEMENTS_FILTER);
                break;
            }
            case 58: 
            case 59: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                field.setTransform(SummaryTransform.NONE);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void summaryBolding(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(89);
        this.jj_consume_token(135);
        boolean bold = this.bool();
        field.setBold(bold);
    }

    public final void summarySourceList(SummaryInFieldOperation field) throws ParseException {
        block6: while (true) {
            this.jj_consume_token(110);
            this.jj_consume_token(135);
            String str = this.identifier();
            field.addSource(str);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 137: {
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(137);
                str = this.identifier();
                field.addSource(str);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 110: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[91] = this.jj_gen;
    }

    public final void summaryDestinationList(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(111);
        this.jj_consume_token(135);
        String str = this.identifier();
        field.addDestination(str);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(137);
            str = this.identifier();
            field.addDestination(str);
        }
    }

    public final void summaryProperties(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(66);
        this.lbrace();
        block3: while (true) {
            this.summaryProperty(field);
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 48: 
                case 50: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 181: 
                case 182: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 205: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[93] = this.jj_gen;
        this.jj_consume_token(134);
    }

    public final void summaryProperty(SummaryInFieldLongOperation field) throws ParseException {
        String value;
        String name = this.identifierWithDash();
        this.jj_consume_token(135);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                value = this.identifierWithDash();
                break;
            }
            case 194: {
                value = this.quotedString();
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addProperty(new SummaryField.Property(name, value));
    }

    public final void fieldStemming(FieldOperationContainer field) throws ParseException {
        StemmingOperation op = new StemmingOperation();
        this.jj_consume_token(83);
        this.jj_consume_token(135);
        String setting = this.identifierWithDash();
        op.setSetting(setting);
        field.addOperation(op);
    }

    public final void searchStemming(Schema schema) throws ParseException {
        this.jj_consume_token(83);
        this.jj_consume_token(135);
        String setting = this.identifierWithDash();
        schema.setStemming(Stemming.get(setting));
    }

    public final void normalizing(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(84);
        this.jj_consume_token(135);
        String setting = this.identifierWithDash();
        field.addOperation(new NormalizingOperation(setting));
    }

    public final void bolding(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(89);
        this.jj_consume_token(135);
        boolean bold = this.bool();
        field.addOperation(new BoldingOperation(bold));
    }

    public final void dictionary(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.dictionarySetting(field);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: {
                            break;
                        }
                        default: {
                            this.jj_la1[95] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.dictionarySetting(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[96] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void dictionarySetting(FieldOperationContainer field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                field.addOperation(new DictionaryOperation(DictionaryOperation.Operation.HASH));
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                field.addOperation(new DictionaryOperation(DictionaryOperation.Operation.BTREE));
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                field.addOperation(new DictionaryOperation(DictionaryOperation.Operation.CASED));
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                field.addOperation(new DictionaryOperation(DictionaryOperation.Operation.UNCASED));
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void body(SDField field) throws ParseException {
        this.jj_consume_token(90);
        this.deployLogger.logApplicationPackage(Level.WARNING, field + ": 'header/body' is deprecated and has no effect.");
    }

    public final void header(SDField field) throws ParseException {
        this.jj_consume_token(91);
        this.deployLogger.logApplicationPackage(Level.WARNING, field + ": 'header/body' is deprecated and has no effect.");
    }

    public final void queryCommand(FieldOperationContainer container) throws ParseException {
        String command;
        QueryCommandOperation field = new QueryCommandOperation();
        this.jj_consume_token(98);
        this.jj_consume_token(135);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                command = this.identifierWithDash();
                break;
            }
            case 194: {
                command = this.quotedString();
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addQueryCommand(command);
        container.addOperation(field);
    }

    public final void alias(FieldOperationContainer container) throws ParseException {
        String aliasedName = null;
        this.jj_consume_token(99);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                aliasedName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
            }
        }
        this.jj_consume_token(135);
        String alias = this.identifierWithDash();
        AliasOperation op = new AliasOperation(aliasedName, alias);
        container.addOperation(op);
    }

    public final FieldOperationContainer match(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(100);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.matchType(field);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 87: 
                        case 88: 
                        case 103: 
                        case 106: {
                            break;
                        }
                        default: {
                            this.jj_la1[101] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.matchItem(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[102] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return field;
    }

    public final Object matchItem(FieldOperationContainer field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 87: 
            case 88: 
            case 103: {
                this.matchType(field);
                break;
            }
            case 106: {
                this.exactTerminator(field);
                break;
            }
            case 41: {
                this.gramSize(field);
                break;
            }
            case 42: {
                this.matchSize(field);
                break;
            }
            default: {
                this.jj_la1[104] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object matchType(FieldOperationContainer container) throws ParseException {
        MatchOperation matchOp = new MatchOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                matchOp.setMatchingType(Matching.Type.TEXT);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                matchOp.setMatchingType(Matching.Type.TEXT);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                matchOp.setMatchingType(Matching.Type.WORD);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                matchOp.setMatchingType(Matching.Type.EXACT);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                matchOp.setMatchingType(Matching.Type.GRAM);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                matchOp.setCase(Case.CASED);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                matchOp.setCase(Case.UNCASED);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                matchOp.setMatchingAlgorithm(Matching.Algorithm.PREFIX);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                matchOp.setMatchingAlgorithm(Matching.Algorithm.SUBSTRING);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                matchOp.setMatchingAlgorithm(Matching.Algorithm.SUFFIX);
                break;
            }
            default: {
                this.jj_la1[105] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        container.addOperation(matchOp);
        return null;
    }

    public final void exactTerminator(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(106);
        this.jj_consume_token(135);
        String terminator = this.quotedString();
        field.setExactMatchTerminator(terminator);
        container.addOperation(field);
    }

    public final void gramSize(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(41);
        this.jj_consume_token(135);
        int gramSize = this.integer();
        field.setGramSize(gramSize);
        container.addOperation(field);
    }

    public final void matchSize(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(42);
        this.jj_consume_token(135);
        int matchSize = this.integer();
        field.setMaxLength(matchSize);
        container.addOperation(field);
    }

    public final Object rank(FieldOperationContainer field) throws ParseException {
        RankOperation op = new RankOperation();
        this.jj_consume_token(101);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.rankSetting(op);
                break;
            }
            case 5: 
            case 133: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 102: 
                        case 104: 
                        case 105: {
                            break;
                        }
                        default: {
                            this.jj_la1[106] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.rankSetting(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[107] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[108] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object rankSetting(RankOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 102: {
                this.jj_consume_token(102);
                field.setLiteral(true);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                field.setNormal(true);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                field.setFilter(true);
                break;
            }
            default: {
                this.jj_la1[109] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void id(FieldOperationContainer field, SDDocumentType document) throws ParseException {
        IdOperation op = new IdOperation();
        this.jj_consume_token(109);
        this.jj_consume_token(135);
        int fieldId = this.integer();
        op.setDocument(document);
        op.setFieldId(fieldId);
        field.addOperation(op);
    }

    public final void indexingRewrite(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(107);
        this.jj_consume_token(135);
        this.jj_consume_token(92);
        field.addOperation(new IndexingRewriteOperation());
    }

    public final Object documentSummary(Schema schema) throws ParseException {
        block13: {
            this.jj_consume_token(32);
            String name = this.identifierWithDash();
            DocumentSummary summary = new DocumentSummary(name, schema);
            schema.addSummary(summary);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    this.inheritsDocumentSummary(summary, schema);
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                }
            }
            this.lbrace();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 57: 
                    case 113: 
                    case 114: {
                        break;
                    }
                    default: {
                        this.jj_la1[111] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 113: {
                        this.jj_consume_token(113);
                        summary.setFromDisk(true);
                        continue block12;
                    }
                    case 114: {
                        this.jj_consume_token(114);
                        summary.setOmitSummaryFeatures(true);
                        continue block12;
                    }
                    case 57: {
                        this.documentSummaryItem(summary);
                        continue block12;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[112] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(134);
        return null;
    }

    public final void inheritsDocumentSummary(DocumentSummary documentSummary, Schema schema) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifierWithDash();
        documentSummary.setInherited(name);
    }

    public final Object documentSummaryItem(DocumentSummary summary) throws ParseException {
        this.summaryInDocument(summary);
        return null;
    }

    public final Object index(Schema schema, FieldOperationContainer field) throws ParseException {
        IndexOperation op = new IndexOperation();
        String indexName = field != null ? field.getName() : null;
        this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[113] = this.jj_gen;
            }
        }
        if (indexName == null) {
            throw new ParseException("Index statements outside fields must have an explicit name.");
        }
        op.setIndexName(indexName);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135: {
                this.jj_consume_token(135);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 137: {
                            break;
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(137);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 133: {
                this.lbrace();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 43: 
                        case 83: 
                        case 99: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: {
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[116] = this.jj_gen;
                                continue block17;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (field == null) {
            Index index = new Index(indexName);
            op.applyToIndex(index);
            schema.addIndex(index);
        } else {
            field.addOperation(op);
        }
        return null;
    }

    public final Object indexBody(IndexOperation index) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                index.setPrefix(true);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                this.jj_consume_token(135);
                String str = this.identifierWithDash();
                index.addAlias(str);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                this.jj_consume_token(135);
                String str = this.identifierWithDash();
                index.setStemming(str);
                break;
            }
            case 155: {
                this.jj_consume_token(155);
                this.jj_consume_token(135);
                int arity = this.integer();
                index.setArity(arity);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                this.jj_consume_token(135);
                long num = this.consumeLong();
                index.setLowerBound(num);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                this.jj_consume_token(135);
                long num = this.consumeLong();
                index.setUpperBound(num);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                this.jj_consume_token(135);
                double threshold = this.consumeFloat();
                index.setDensePostingListThreshold(threshold);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                index.setEnableBm25(true);
                break;
            }
            case 160: {
                this.hnswIndex(index);
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void hnswIndex(IndexOperation index) throws ParseException {
        HnswIndexParams.Builder params = new HnswIndexParams.Builder();
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(160);
            this.lbrace();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 161: 
                    case 163: 
                    case 164: {
                        break;
                    }
                    default: {
                        this.jj_la1[119] = this.jj_gen;
                        break block9;
                    }
                }
                this.hnswIndexBody(params);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[120] = this.jj_gen;
                            continue block9;
                        }
                    }
                    this.jj_consume_token(5);
                }
                break;
            }
            this.jj_consume_token(134);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 160: {
                    this.jj_consume_token(160);
                    break;
                }
                default: {
                    this.jj_la1[121] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        index.setHnswIndexParams(params);
    }

    public final void hnswIndexBody(HnswIndexParams.Builder params) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 161: {
                this.jj_consume_token(161);
                this.jj_consume_token(135);
                int num = this.integer();
                params.setMaxLinksPerNode(num);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                this.jj_consume_token(135);
                int num = this.integer();
                params.setNeighborsToExploreAtInsert(num);
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                this.jj_consume_token(135);
                boolean bool = this.bool();
                params.setMultiThreadedIndexing(bool);
                break;
            }
            default: {
                this.jj_la1[122] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void onnxModel(Schema schema) throws ParseException {
        this.jj_consume_token(47);
        String name = this.identifier();
        OnnxModel onnxModel = new OnnxModel(name);
        this.lbrace();
        block6: while (true) {
            this.onnxModelItem(onnxModel);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 190: 
                case 191: 
                case 206: 
                case 207: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[124] = this.jj_gen;
        this.jj_consume_token(134);
        if (this.documentsOnly) {
            return;
        }
        schema.onnxModels().add(onnxModel);
    }

    public final Object onnxModelItem(OnnxModel onnxModel) throws ParseException {
        String path = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(135);
                path = this.filePath();
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[125] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(5);
                }
                onnxModel.setFileName(path);
                break;
            }
            case 191: {
                this.jj_consume_token(191);
                this.jj_consume_token(135);
                path = this.uriPath();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[126] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(5);
                }
                onnxModel.setUri(path);
                break;
            }
            case 206: {
                this.jj_consume_token(206);
                String name = this.token.image.substring(5, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String source = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addInputNameMapping(name, source);
                break;
            }
            case 207: {
                this.jj_consume_token(207);
                String name = this.token.image.substring(6, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String as = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addOutputNameMapping(name, as);
                break;
            }
            default: {
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void rankingConstant(Schema schema) throws ParseException {
        this.jj_consume_token(46);
        String name = this.identifier();
        RankingConstant constant = new RankingConstant(name);
        this.lbrace();
        block6: while (true) {
            this.rankingConstantItem(constant);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[128] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 190: 
                case 191: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[129] = this.jj_gen;
        this.jj_consume_token(134);
        if (this.documentsOnly) {
            return;
        }
        schema.rankingConstants().add(constant);
    }

    public final Object rankingConstantItem(RankingConstant constant) throws ParseException {
        String path = null;
        TensorType type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(135);
                path = this.filePath();
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[130] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.jj_consume_token(5);
                }
                constant.setFileName(path);
                break;
            }
            case 191: {
                this.jj_consume_token(191);
                this.jj_consume_token(135);
                path = this.uriPath();
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[131] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(5);
                }
                constant.setUri(path);
                break;
            }
            case 35: {
                type = this.tensorTypeWithPrefix(this.rankingConstantErrorMessage(constant.getName()));
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[132] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(5);
                }
                constant.setType(type);
                break;
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final String rankingConstantErrorMessage(String name) throws ParseException {
        return "For ranking constant ' " + name + "'";
    }

    public final String filePath() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                break;
            }
            case 199: {
                this.jj_consume_token(199);
                break;
            }
            case 192: {
                this.jj_consume_token(192);
                break;
            }
            default: {
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String uriPath() throws ParseException {
        this.jj_consume_token(202);
        return this.token.image;
    }

    public final void rankProfile(Schema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[135] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifierWithDash();
        RankProfile profile = this.documentsOnly ? new DocumentsOnlyRankProfile(name, schema, this.rankProfileRegistry, schema.rankingConstants()) : ("default".equals(name) ? this.rankProfileRegistry.get(schema, "default") : new RankProfile(name, schema, this.rankProfileRegistry, schema.rankingConstants()));
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsRankProfile(profile);
                break;
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
            }
        }
        this.lbrace();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 33: 
                case 34: 
                case 49: 
                case 51: 
                case 52: 
                case 75: 
                case 101: 
                case 108: 
                case 145: 
                case 151: 
                case 152: 
                case 153: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 181: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 189: {
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                    break block13;
                }
            }
            this.rankProfileItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        if (this.documentsOnly) {
            return;
        }
        this.rankProfileRegistry.add(profile);
    }

    public final Object rankProfileItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.fieldRankType(profile);
                break;
            }
            case 34: {
                this.fieldWeight(profile);
                break;
            }
            case 101: {
                this.fieldRankFilter(profile);
                break;
            }
            case 151: {
                this.firstPhase(profile);
                break;
            }
            case 145: {
                this.matchPhase(profile);
                break;
            }
            case 75: 
            case 153: {
                this.function(profile);
                break;
            }
            case 49: {
                this.mutate(profile);
                break;
            }
            case 108: {
                this.ignoreRankFeatures(profile);
                break;
            }
            case 183: {
                this.numThreadsPerSearch(profile);
                break;
            }
            case 184: {
                this.minHitsPerThread(profile);
                break;
            }
            case 185: {
                this.numSearchPartitions(profile);
                break;
            }
            case 186: {
                this.termwiseLimit(profile);
                break;
            }
            case 168: 
            case 169: {
                this.rankFeatures(profile);
                break;
            }
            case 181: {
                this.rankProperties(profile);
                break;
            }
            case 152: {
                this.secondPhase(profile);
                break;
            }
            case 51: 
            case 52: {
                this.rankDegradation(profile);
                break;
            }
            case 189: {
                this.constants(profile);
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                this.summaryFeatures(profile);
                break;
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void inheritsRankProfile(RankProfile profile) throws ParseException {
        this.jj_consume_token(23);
        String str = this.identifierWithDash();
        profile.setInherited(str);
    }

    public final void mutate(RankProfile profile) throws ParseException {
        this.jj_consume_token(49);
        this.lbrace();
        block3: while (true) {
            this.mutate_operation(profile);
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[140] = this.jj_gen;
        this.jj_consume_token(134);
    }

    public final void mutate_operation(RankProfile profile) throws ParseException {
        RankProfile.MutateOperation.Phase phase;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                phase = RankProfile.MutateOperation.Phase.onmatch;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                phase = RankProfile.MutateOperation.Phase.on_first_phase;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                phase = RankProfile.MutateOperation.Phase.on_second_phase;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                phase = RankProfile.MutateOperation.Phase.onsummary;
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.lbrace();
        String attribute = this.identifier();
        String operation = this.mutate_expr();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[142] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(134);
        profile.addMutateOperation(phase, attribute, operation);
    }

    public final String mutate_expr() throws ParseException {
        Number constant = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 210: {
                this.jj_consume_token(210);
                break;
            }
            case 211: {
                this.jj_consume_token(211);
                break;
            }
            case 212: {
                this.jj_consume_token(212);
                break;
            }
            default: {
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String op = this.token.image;
        constant = this.consumeNumber();
        return constant != null ? op + constant : op;
    }

    public final void function(RankProfile profile) throws ParseException {
        ArrayList<String> parameters = new ArrayList<String>();
        boolean inline = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inline = this.inline();
        Object name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 213: {
                this.jj_consume_token(213);
                name = (String)name + this.token.image;
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
            }
        }
        this.jj_consume_token(214);
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                String parameter = this.identifier();
                parameters.add(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 137: {
                            break;
                        }
                        default: {
                            this.jj_la1[146] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(137);
                    parameter = this.identifier();
                    parameters.add(parameter);
                }
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
            }
        }
        this.jj_consume_token(215);
        this.lbrace();
        String expression = this.expression();
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[148] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(134);
        profile.addFunction((String)name, parameters, expression, inline);
    }

    public final boolean inline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 154: {
                this.jj_consume_token(154);
                return true;
            }
        }
        this.jj_la1[149] = this.jj_gen;
        return false;
    }

    public final void matchPhase(RankProfile profile) throws ParseException {
        RankProfile.MatchPhaseSettings settings = new RankProfile.MatchPhaseSettings();
        this.jj_consume_token(145);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 67: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: {
                    break;
                }
                default: {
                    this.jj_la1[150] = this.jj_gen;
                    break block6;
                }
            }
            this.matchPhaseItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[151] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        settings.checkValid();
        profile.setMatchPhaseSettings(settings);
    }

    public final void matchPhaseItem(RankProfile.MatchPhaseSettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(135);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 10: {
                this.diversity(settings);
                break;
            }
            case 148: {
                this.jj_consume_token(148);
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 70: {
                        this.jj_consume_token(70);
                        settings.setAscending(true);
                        break block0;
                    }
                    case 71: {
                        this.jj_consume_token(71);
                        settings.setAscending(false);
                        break block0;
                    }
                }
                this.jj_la1[152] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 150: {
                this.jj_consume_token(150);
                this.jj_consume_token(135);
                int num = this.integer();
                settings.setMaxHits(num);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                this.jj_consume_token(135);
                double coverage = this.consumeFloat();
                settings.setMaxFilterCoverage(coverage);
                break;
            }
            case 146: {
                this.jj_consume_token(146);
                this.jj_consume_token(135);
                double multiplier = this.consumeFloat();
                settings.setEvaluationPoint(multiplier);
                break;
            }
            case 147: {
                this.jj_consume_token(147);
                this.jj_consume_token(135);
                double multiplier = this.consumeFloat();
                settings.setPrePostFilterTippingPoint(multiplier);
                break;
            }
            default: {
                this.jj_la1[153] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void diversity(RankProfile.MatchPhaseSettings profile) throws ParseException {
        RankProfile.DiversitySettings settings = new RankProfile.DiversitySettings();
        this.jj_consume_token(10);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 67: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block6;
                }
            }
            this.diversityItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[155] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        profile.setDiversity(settings);
    }

    public final void diversityItem(RankProfile.DiversitySettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(135);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                this.jj_consume_token(135);
                int num = this.integer();
                settings.setMinGroups(num);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(135);
                double multiplier = this.consumeFloat();
                settings.setCutoffFactor(multiplier);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                this.jj_consume_token(135);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.strict);
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.loose);
                        break block0;
                    }
                }
                this.jj_la1[156] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[157] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void firstPhase(RankProfile profile) throws ParseException {
        this.jj_consume_token(151);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 170: 
                case 171: 
                case 187: 
                case 188: {
                    break;
                }
                default: {
                    this.jj_la1[158] = this.jj_gen;
                    break block6;
                }
            }
            this.firstPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
    }

    public final Object firstPhaseItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: 
            case 171: {
                String expression = this.expression();
                profile.setFirstPhaseRanking(expression);
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                this.jj_consume_token(135);
                int rerankCount = this.integer();
                profile.setKeepRankCount(rerankCount);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                this.jj_consume_token(135);
                double dropLimit = this.consumeFloat();
                profile.setRankScoreDropLimit(dropLimit);
                break;
            }
            default: {
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void secondPhase(RankProfile profile) throws ParseException {
        this.jj_consume_token(152);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 170: 
                case 171: 
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[161] = this.jj_gen;
                    break block6;
                }
            }
            this.secondPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[162] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
    }

    public final Object secondPhaseItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: 
            case 171: {
                String expression = this.expression();
                profile.setSecondPhaseRanking(expression);
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(135);
                int rerankCount = this.integer();
                profile.setRerankCount(rerankCount);
                break;
            }
            default: {
                this.jj_la1[163] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object summaryFeatures(RankProfile profile) throws ParseException {
        String features;
        Object inherited = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 165: {
                this.jj_consume_token(165);
                features = this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                features = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                int inheritsIndex = this.token.image.indexOf("inherits ");
                String rest = this.token.image.substring(inheritsIndex + "inherits ".length());
                profile.setInheritedSummaryFeatures(rest.substring(0, rest.indexOf(" ")).trim());
                features = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        profile.addSummaryFeatures(this.getFeatureList(features));
        return null;
    }

    public final Object rankFeatures(RankProfile profile) throws ParseException {
        String features;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 168: {
                this.jj_consume_token(168);
                features = this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                features = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
                break;
            }
            default: {
                this.jj_la1[165] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        profile.addRankFeatures(this.getFeatureList(features));
        return null;
    }

    public final void ignoreRankFeatures(RankProfile profile) throws ParseException {
        this.jj_consume_token(108);
        profile.setIgnoreDefaultRankFeatures(true);
    }

    public final void numThreadsPerSearch(RankProfile profile) throws ParseException {
        this.jj_consume_token(183);
        this.jj_consume_token(135);
        int num = this.integer();
        profile.setNumThreadsPerSearch(num);
    }

    public final void minHitsPerThread(RankProfile profile) throws ParseException {
        this.jj_consume_token(184);
        this.jj_consume_token(135);
        int num = this.integer();
        profile.setMinHitsPerThread(num);
    }

    public final void numSearchPartitions(RankProfile profile) throws ParseException {
        this.jj_consume_token(185);
        this.jj_consume_token(135);
        int num = this.integer();
        profile.setNumSearchPartitions(num);
    }

    public final void termwiseLimit(RankProfile profile) throws ParseException {
        this.jj_consume_token(186);
        this.jj_consume_token(135);
        double num = this.consumeFloat();
        profile.setTermwiseLimit(num);
    }

    public final void rankProperties(RankProfile profile) throws ParseException {
        this.jj_consume_token(181);
        this.lbrace();
        while (this.jj_2_9(Integer.MAX_VALUE)) {
            this.rankProperty(profile);
            block7: while (true) {
                this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[166] = this.jj_gen;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: 
            case 214: 
            case 215: {
                this.rankProperty(profile);
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
            }
        }
        this.jj_consume_token(134);
    }

    public final void rankProperty(RankProfile profile) throws ParseException {
        String key = this.rankPropertyItem();
        this.jj_consume_token(135);
        String val = this.rankPropertyItem();
        profile.addRankProperty(key, val);
    }

    public final String rankPropertyItem() throws ParseException {
        Object ret = "";
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 48: 
                case 50: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 181: 
                case 182: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 205: {
                    String image = this.identifierWithDash();
                    ret = (String)ret + image;
                    break;
                }
                case 194: {
                    String image = this.quotedString();
                    ret = (String)ret + image;
                    break;
                }
                case 136: 
                case 137: 
                case 214: 
                case 215: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 214: {
                            this.jj_consume_token(214);
                            break;
                        }
                        case 215: {
                            this.jj_consume_token(215);
                            break;
                        }
                        case 136: {
                            this.jj_consume_token(136);
                            break;
                        }
                        case 137: {
                            this.jj_consume_token(137);
                            break;
                        }
                        default: {
                            this.jj_la1[168] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    ret = (String)ret + this.token.image;
                    break;
                }
                default: {
                    this.jj_la1[169] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 48: 
                case 50: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 181: 
                case 182: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 205: 
                case 214: 
                case 215: {
                    continue block14;
                }
            }
            break;
        }
        this.jj_la1[170] = this.jj_gen;
        return ret;
    }

    public final void fieldWeight(RankProfile profile) throws ParseException {
        this.jj_consume_token(34);
        String name = this.identifier();
        this.jj_consume_token(135);
        Integer num = this.integer();
        profile.addRankSetting(name, RankProfile.RankSetting.Type.WEIGHT, num);
    }

    public final void fieldRankType(RankProfile profile) throws ParseException {
        this.jj_consume_token(33);
        String name = this.identifier();
        this.jj_consume_token(135);
        String type = this.identifier();
        profile.addRankSetting(name, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(type));
    }

    public final void fieldRankFilter(RankProfile profile) throws ParseException {
        this.jj_consume_token(101);
        String name = this.identifier();
        this.jj_consume_token(135);
        this.jj_consume_token(104);
        profile.addRankSetting(name, RankProfile.RankSetting.Type.PREFERBITVECTOR, Boolean.TRUE);
    }

    public final void rankDegradationBinSize() throws ParseException {
        this.jj_consume_token(54);
        this.jj_consume_token(135);
        double freq = this.consumeFloat();
        this.deployLogger.logApplicationPackage(Level.WARNING, "Specifying 'doc-frequency' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final void rankDegradationBinLow() throws ParseException {
        this.jj_consume_token(55);
        this.jj_consume_token(135);
        int n = this.integer();
        this.deployLogger.logApplicationPackage(Level.WARNING, "Specifying 'min-fullrank-docs' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final void rankDegradationPosbinSize() throws ParseException {
        this.jj_consume_token(56);
        this.jj_consume_token(135);
        double avgOcc = this.consumeFloat();
        this.deployLogger.logApplicationPackage(Level.WARNING, "Specifying 'occurrences-per-doc' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final Object rankDegradationItem() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.rankDegradationBinSize();
                break;
            }
            case 55: {
                this.rankDegradationBinLow();
                break;
            }
            case 56: {
                this.rankDegradationPosbinSize();
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object rankDegradation(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(135);
                double freq = this.consumeFloat();
                this.deployLogger.logApplicationPackage(Level.WARNING, "Specifying 'rank-degradation-frequency' in 'rank-profile' is deprecated and has no effect.");
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                this.lbrace();
                block10: while (true) {
                    this.rankDegradationItem();
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[172] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 54: 
                        case 55: 
                        case 56: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[173] = this.jj_gen;
                this.jj_consume_token(134);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void constants(RankProfile profile) throws ParseException {
        this.jj_consume_token(189);
        this.jj_consume_token(133);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[175] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 43: 
                case 44: 
                case 45: 
                case 48: 
                case 50: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 143: 
                case 144: 
                case 145: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 181: 
                case 182: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 205: {
                    break;
                }
                default: {
                    this.jj_la1[176] = this.jj_gen;
                    break block14;
                }
            }
            String name = this.identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 135: {
                    this.constantValue(profile, name);
                    break;
                }
                case 133: {
                    this.constantTensor(profile, name);
                    break;
                }
                default: {
                    this.jj_la1[177] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[178] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
    }

    public final void constantValue(RankProfile profile, String name) throws ParseException {
        this.jj_consume_token(135);
        String value = this.identifier();
        profile.addConstant(name, Value.parse((String)value));
    }

    public final void constantTensor(RankProfile profile, String name) throws ParseException {
        String tensorString = "";
        TensorType tensorType = null;
        this.jj_consume_token(133);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[179] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 126: 
                case 127: {
                    break;
                }
                default: {
                    this.jj_la1[180] = this.jj_gen;
                    break block14;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 126: 
                case 127: {
                    tensorString = this.tensorValue();
                    break;
                }
                case 35: {
                    tensorType = this.tensorTypeWithPrefix(this.constantTensorErrorMessage(profile.getName(), name));
                    break;
                }
                default: {
                    this.jj_la1[181] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[182] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(134);
        if (tensorType != null) {
            profile.addConstantTensor(name, new TensorValue(Tensor.from((TensorType)tensorType, (String)tensorString)));
        } else {
            profile.addConstantTensor(name, new TensorValue(Tensor.from((String)tensorString)));
        }
    }

    public final String constantTensorErrorMessage(String rankProfileName, String constantTensorName) throws ParseException {
        return "For constant tensor '" + constantTensorName + "' in rank profile '" + rankProfileName + "'";
    }

    public final String tensorValue() throws ParseException {
        String tensor;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                tensor = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                tensor = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tensor;
    }

    public final TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {
        this.jj_consume_token(35);
        this.jj_consume_token(135);
        TensorType type = this.tensorType(errorMessage);
        return type;
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(125);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void importField(Schema schema) throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(24);
        String fieldRefSpec = this.identifier();
        this.jj_consume_token(29);
        String aliasFieldName = this.identifier();
        this.lbrace();
        this.jj_consume_token(134);
        long nDots = Utils.count(fieldRefSpec, '.');
        if (nDots != 1L) {
            throw new IllegalArgumentException("Illegal field reference spec '" + fieldRefSpec + "': Does not include a single '.'");
        }
        int indexOfDot = fieldRefSpec.indexOf(46);
        String documentReferenceFieldName = fieldRefSpec.substring(0, indexOfDot);
        String foreignFieldName = fieldRefSpec.substring(indexOfDot + 1);
        TemporaryImportedFields importedFields = schema.temporaryImportedFields().get();
        if (importedFields.hasField(aliasFieldName)) {
            throw new IllegalArgumentException("For schema '" + schema.getName() + "', import field as '" + aliasFieldName + "': Field already imported");
        }
        importedFields.add(new TemporaryImportedField(aliasFieldName, documentReferenceFieldName, foreignFieldName));
    }

    public final String expression() throws ParseException {
        String exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: {
                this.jj_consume_token(170);
                exp = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                exp = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[184] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final String identifierWithDash() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 143: 
            case 144: 
            case 145: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 181: 
            case 182: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 205: {
                String identifier = this.identifier();
                return identifier;
            }
            case 193: {
                this.jj_consume_token(193);
                return this.token.image;
            }
        }
        this.jj_la1[185] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 155: {
                this.jj_consume_token(155);
                break;
            }
            case 138: {
                this.jj_consume_token(138);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            case 195: {
                this.jj_consume_token(195);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 196: {
                this.jj_consume_token(196);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 192: {
                this.jj_consume_token(192);
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 197: {
                this.jj_consume_token(197);
                break;
            }
            case 187: {
                this.jj_consume_token(187);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 198: {
                this.jj_consume_token(198);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                break;
            }
            case 140: {
                this.jj_consume_token(140);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                break;
            }
            case 148: {
                this.jj_consume_token(148);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 181: {
                this.jj_consume_token(181);
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 199: {
                this.jj_consume_token(199);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 191: {
                this.jj_consume_token(191);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 154: {
                this.jj_consume_token(154);
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                break;
            }
            default: {
                this.jj_la1[186] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String string() throws ParseException {
        this.jj_consume_token(199);
        return this.token.image;
    }

    public final String quotedString() throws ParseException {
        this.jj_consume_token(194);
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    public final Boolean bool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 93: 
            case 95: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        break;
                    }
                    case 95: {
                        this.jj_consume_token(95);
                        break;
                    }
                    default: {
                        this.jj_la1[187] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return true;
            }
            case 94: 
            case 96: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: {
                        this.jj_consume_token(94);
                        break;
                    }
                    case 96: {
                        this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[188] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return false;
            }
        }
        this.jj_la1[189] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int integer() throws ParseException {
        this.jj_consume_token(197);
        return Integer.parseInt(this.token.image);
    }

    public final long consumeLong() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 197: {
                this.jj_consume_token(197);
                return Long.parseLong(this.token.image);
            }
            case 198: {
                this.jj_consume_token(198);
                return Long.parseLong(this.token.image.substring(0, this.token.image.length() - 1));
            }
        }
        this.jj_la1[190] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double consumeFloat() throws ParseException {
        this.jj_consume_token(196);
        return Double.valueOf(this.token.image);
    }

    public final Number consumeNumber() throws ParseException {
        Number num;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 196: {
                num = this.consumeFloat();
                break;
            }
            case 197: 
            case 198: {
                num = this.consumeLong();
                break;
            }
            default: {
                this.jj_la1[191] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return num;
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(133);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[193] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    private boolean jj_3R_114() {
        return this.jj_scan_token(194);
    }

    private boolean jj_3_7() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_101() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(135)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_107()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_105() {
        return this.jj_scan_token(60);
    }

    private boolean jj_3R_102() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(133)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_106() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(58)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(59)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(160)) {
            return true;
        }
        return this.jj_3R_102();
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_116()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_115() {
        return this.jj_3R_109();
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(138)) {
            return true;
        }
        return this.jj_scan_token(203);
    }

    private boolean jj_3R_116() {
        return this.jj_scan_token(193);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(139)) {
            return true;
        }
        return this.jj_scan_token(203);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(140)) {
            return true;
        }
        return this.jj_scan_token(203);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(203);
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(125);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(141);
    }

    private boolean jj_3R_103() {
        Token xsp;
        if (this.jj_3R_108()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_108());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_111()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_112()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_3R_113();
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(99)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(115)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(6)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(155)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(138)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(29)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(70)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(67)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(90)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(89)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(86)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(87)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(128)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(129)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(130)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(195)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(143)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(158)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(71)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(69)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(112)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(16)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(32)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(196)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(60)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(118)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(119)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(96)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(120)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(123)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(24)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(25)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(26)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(190)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(104)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(151)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(58)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(75)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(40)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(85)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(91)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(124)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(109)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(82)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(192)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(108)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(28)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(36)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(30)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(107)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(23)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(102)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(76)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(74)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(100)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(37)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(92)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(105)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(84)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(94)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(93)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(116)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(43)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(78)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(66)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(81)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(98)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(101)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(48)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(50)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(33)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(73)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(8)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(9)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(79)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(110)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(62)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(63)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(64)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(65)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(59)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(83)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(77)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(22)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(44)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(45)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(57)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(31)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(97)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(80)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(38)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(111)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(35)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(72)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(88)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(34)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(39)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_111() {
        return this.jj_3R_114();
    }

    private boolean jj_3_9() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_scan_token(135)) {
            return true;
        }
        if (this.jj_3R_103()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_112() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(214)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(215)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(136)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(137)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 66305, 768, 0x800000, 356581440, 32, 32, 356581440, 65536, 32, -138345536, 32, 32, 0x800000, 32, 0x1400040, 32, 32, 32, 0x800000, 32, 0x1400040, 32, 0x1400040, 32, 0, 32, 0, 0, 32, 0, 0, -939524096, 32, 0, -138345536, 0x2000000, 32, 0x2000000, 32, 0x800000, 32, 0x800000, 0x1000000, 32, 0x1000000, 32, 0, -138345536, 32, 0, 0, 32, -939524096, 32, -939524096, -939524096, 0, -138345536, 0, 0, 32, 32, 0, -138345536, -138345536, 0, 32, 32, 0, 32, 32, 0, 0, 0, -138345536, 0, 0, 32, -138345504, -138345536, 0, 0, 0, -138345536, 0, 32, 0, 0, 0, 0, 0, 0, -138345536, -138345536, 0, 32, 32, 0, -138345536, -138345536, 0, 32, 32, 0, 0, 0, 32, 32, 0, 0x800000, 32, 32, -138345536, 0, 0, 32, 32, 0, 0, 32, 0, 0, 32, 0, 32, 32, 0, 32, 0, 32, 32, 32, 0, 0, 0, 0x800000, 0, 32, 0, 0x3C0000, 0x3C0000, 32, 0, 0, 0, 0, -138345536, 32, 0, 1024, 32, 0, 1024, 14336, 32, 49152, 14336, 0, 32, 0, 0, 32, 0, 0, 0, 32, -138345536, 0, -138345536, -138345536, 0, 32, 0, 0, 32, -138345536, 0, 32, 32, 0, 0, 32, 0, 0, -138345536, -138345536, 0, 0, 0, 0, 0, 32, 32};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 2474001, 0, 0, 2474001, 0, 0, -570082817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 33554454, 0, 0, -570082817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -570082817, 0, 0, 0, 0, 0x2000000, 0, 33554454, 0x2000000, 0, -570082817, 0, 0, 0, 0, 0, -570082817, -570082817, 0, 0, 0, 0, 0, 0, 0, 0, 0, -570082817, 0, 0x3C000000, 0, -570082817, -570082817, 0xC000000, 0x3C000000, 8, -570082817, 0x3C000000, 0, 0x3C000000, 0xC000000, 0x3C000000, 0, 0, 0, -570082817, -570082817, 0, 0, 0, 0, -570082817, -570082817, 16352, 0, 0, 16352, 14816, 0, 0, 0, 0, 0, 0x2000000, 0x2000000, -570082817, 0, 2048, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 8, 0, 327680, 0, 1703942, 0, 1703942, 0, 0, 0, 0, 0, 0, 0, -570082817, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -570082817, 0, -570082817, -570082817, 0x1C00000, 0, 0x1C00000, 0x180000, 0, -570082817, 0, 0, 0, 8, 8, 0, 0, 0, -570082817, -570082817, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 524288, 0, 0, 524288, 0, 0, -1, 0, 0, 0, 0, 0xC000000, 0, 0, 0, 0, 0, 0xC000000, 0, 0xC000000, 0, 0, 0, 0, 0, 0, 0, 0, 236453944, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 8, 0, 236453944, 8, 0, -1, 0, 0, 0, 0, 0, -1, -1, 16, 0, 0, 14528, 0, 0, 1792, 507904, 14528, -1, 16, 0x2000004, 0, -1, -1, 0, 0, 0, -1, 0x2000004, 0, 0x2000004, 0, 0, 0, 0, 0, -1, -1, 0x1E00000, 0, 0, 0x1E00000, -1, -1, 0x1800000, 0, 0, 0x1800000, 0x1800000, 0, 0, 0, 0, 0, 0, 0, -1, 0, 524288, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 2048, 0, 0, 0, 0, 2048, 0, 0, -1, 0, 0, 8, 0, 192, 8, 8, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1610612736, 0x40000000, -536870912, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10300, 0, 0, 0x1FF9FFFF, 20, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0, 8192, 16, 0, 20, 0, 10300, 20, 0, 0x1FF9FFFF, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0x1FF9FFFF, 1069547528, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FF9FFFF, 1069547528, 49152, 0, 0x1FF9FFFF, 0x1FF9FFFF, 0, 0, 0, 0x1FF9FFFF, 49152, 0, 49152, 0, 0, 0, 16384, 0, 0x1FF9FFFF, 0x1FF9FFFF, 0, 0, 0, 0, 0x1FF9FFFF, 0x1FF9FFFF, 1152, 0, 0, 1152, 128, 832, 0, 0, 832, 0, 393216, 393216, 0x1FF9FFFF, 0, 8, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4128, 0, 4128, 0, 0, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0, 0x1FF9FFFF, 0x1FF9FFFF, 0, 0, 0, 0, 0, 0x1FF9FFFF, 0, 0, 0, -1073741824, -1073741824, 0, -1073741824, 0, 0x1FF9FFFF, 0x1FF9FFFF, 0, 1, 1, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 16, 0, 0, 16, 0, 0, 2146679831, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 6, 0, 6, 512, 2048, 0, 512, 2146679831, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2146679831, 0, 0, 0, 0, 0, 0, 2048, 0, 128, 2146679831, 512, 98304, 0, 160, 98304, 2146679831, 2146679831, 0, 0, 160, 0, 0, 160, 0, 0, 0, 2146679831, 0, 0, 0, 2146679863, 2146679831, 0, 0, 0, 2146679831, 0, 0, 0, 0, 0, 512, 0, 512, 2146679831, 2146679831, 0, 0, 160, 0, 2146679831, 2146679831, 0, 0, 160, 0, 0, 0, 0, 160, 0, 0, 0, 0, 2146679831, 512, -134217728, 0, 160, -134217728, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58851328, 0, 58851328, 0, 0, 0, 0, 0x2000000, 0, 512, 2146679831, 0, 0x4000000, 0x7C0000, 0, 0, 0x7C0000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2146680599, 768, 2146680599, 2146680599, 0, 0, 0, 0, 0, 2146679831, 160, 0, 0, 0, 0, 0, 0, 0, 2146679831, 2146679831, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, -127926272, -127926272, 4, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 4, 0, 0, -127926272, -127926272, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, -127926272, 0, 0, 0, 0, -127926272, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 1, 0, 0, 1, 26, 0, 1, 26, 0, -1073741824, 0, 0, -1073741824, 0, -1073741824, 0, 0, 0, -1073741824, 0, 0, 0, 664798176, 0, 664798176, 0, 0, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 402656256, 0, 402656256, 0x400C00, 0, 0x400C00, 224, 768, 0, -127926272, 0, -127926272, -127926272, 0, 0, 0, 0, 0, -127926272, 0, 0, 0, 0, 0, 0, 0, 3072, -127926272, -127926272, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8447, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8441, 0, 0, 0, 0, 0, 8441, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8441, 0, 0, 0, 8441, 8441, 0, 0, 0, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 8443, 8447, 0, 0, 0, 0, 8447, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49152, 0, 0, 49152, 0, 0, 0, 0, 0, 0, 385, 0, 0, 0, 0, 0, 0, 0, 0, 0x1C0000, 0, 0x200000, 0, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12591359, 0xC00000, 12591359, 12591359, 0, 0, 0, 0, 0, 8441, 0, 0, 0, 0, 0, 0, 0, 0, 8443, 8441, 0, 0, 0, 96, 112, 0, 0};
    }

    public SDParser(CharStream stream) {
        int i;
        this.token_source = new SDParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 194; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 194; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SDParser(SDParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 194; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SDParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 194; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[216];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 194; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 216; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SDParser.jj_la1_init_0();
        SDParser.jj_la1_init_1();
        SDParser.jj_la1_init_2();
        SDParser.jj_la1_init_3();
        SDParser.jj_la1_init_4();
        SDParser.jj_la1_init_5();
        SDParser.jj_la1_init_6();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }
}

