/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.BooleanIndexDefinition;
import com.yahoo.searchdefinition.document.Case;
import com.yahoo.searchdefinition.document.FieldSet;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IndexInfo
extends Derived
implements IndexInfoConfig.Producer {
    private static final String CMD_ATTRIBUTE = "attribute";
    private static final String CMD_DEFAULT_POSITION = "default-position";
    private static final String CMD_DYNTEASER = "dynteaser";
    private static final String CMD_FULLURL = "fullurl";
    private static final String CMD_HIGHLIGHT = "highlight";
    private static final String CMD_INDEX = "index";
    private static final String CMD_LOWERCASE = "lowercase";
    private static final String CMD_NORMALIZE = "normalize";
    private static final String CMD_STEM = "stem";
    private static final String CMD_URLHOST = "urlhost";
    private static final String CMD_WORD = "word";
    private static final String CMD_PLAIN_TOKENS = "plain-tokens";
    private static final String CMD_MULTIVALUE = "multivalue";
    private static final String CMD_FAST_SEARCH = "fast-search";
    private static final String CMD_PREDICATE = "predicate";
    private static final String CMD_PREDICATE_BOUNDS = "predicate-bounds";
    private static final String CMD_NUMERICAL = "numerical";
    private static final String CMD_PHRASE_SEGMENTING = "phrase-segmenting";
    private final Set<IndexCommand> commands = new LinkedHashSet<IndexCommand>();
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private final Map<String, FieldSet> fieldSets;
    private Schema schema;

    public IndexInfo(Schema schema) {
        this.fieldSets = schema.fieldSets().userFieldSets();
        this.addIndexCommand("sddocname", CMD_INDEX);
        this.addIndexCommand("sddocname", CMD_WORD);
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        super.derive(schema);
        this.schema = schema;
        for (FieldSet fs : this.fieldSets.values()) {
            for (String fieldName : fs.getFieldNames()) {
                fs.fields().add(schema.getField(fieldName));
            }
        }
        for (Index index : schema.getExplicitIndices()) {
            this.derive(index, schema);
        }
        for (SummaryField summaryField : schema.getUniqueNamedSummaryFields().values()) {
            if (summaryField.getTransform().isTeaser()) {
                this.addIndexCommand(summaryField.getName(), CMD_DYNTEASER);
            }
            if (!summaryField.getTransform().isBolded()) continue;
            this.addIndexCommand(summaryField.getName(), CMD_HIGHLIGHT);
        }
    }

    private static boolean isPositionArrayField(ImmutableSDField field) {
        return field.getDataType().equals((Object)DataType.getArray((DataType)PositionDataType.INSTANCE));
    }

    private static boolean isPositionField(ImmutableSDField field) {
        return field.getDataType().equals((Object)PositionDataType.INSTANCE) || IndexInfo.isPositionArrayField(field);
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
        this.derive(field, schema, false);
    }

    protected void derive(ImmutableSDField field, Schema schema, boolean inPosition) {
        if (field.getDataType().equals((Object)DataType.PREDICATE)) {
            BooleanIndexDefinition booleanIndexDefinition;
            this.addIndexCommand(field, CMD_PREDICATE);
            Index index = field.getIndex(field.getName());
            if (index != null && ((booleanIndexDefinition = index.getBooleanIndexDefiniton()).hasLowerBound() || booleanIndexDefinition.hasUpperBound())) {
                this.addIndexCommand(field.getName(), "predicate-bounds [" + (booleanIndexDefinition.hasLowerBound() ? Long.toString(booleanIndexDefinition.getLowerBound()) : "") + ".." + (booleanIndexDefinition.hasUpperBound() ? Long.toString(booleanIndexDefinition.getUpperBound()) : "") + "]");
            }
        }
        for (Map.Entry entry : field.getAliasToName().entrySet()) {
            String string = (String)entry.getKey();
            String name = (String)entry.getValue();
            this.addIndexAlias(string, name);
        }
        boolean isPosition = IndexInfo.isPositionField(field);
        if (field.usesStructOrMap()) {
            for (ImmutableSDField immutableSDField : field.getStructFields()) {
                this.derive(immutableSDField, schema, isPosition);
            }
        }
        if (isPosition) {
            this.addIndexCommand(field.getName(), CMD_DEFAULT_POSITION);
        }
        this.addIndexCommand(field, CMD_INDEX);
        if (IndexInfo.needLowerCase(field)) {
            this.addIndexCommand(field, CMD_LOWERCASE);
        }
        if (field.getDataType().isMultivalue()) {
            this.addIndexCommand(field, CMD_MULTIVALUE);
        }
        Attribute attribute = field.getAttribute();
        if ((field.doesAttributing() || attribute != null && !inPosition) && !field.doesIndexing()) {
            this.addIndexCommand(field.getName(), CMD_ATTRIBUTE);
            if (attribute != null && attribute.isFastSearch()) {
                this.addIndexCommand(field.getName(), CMD_FAST_SEARCH);
            }
        } else if (field.doesIndexing()) {
            if (this.stemSomehow(field, schema)) {
                this.addIndexCommand(field, IndexInfo.stemCmd(field, schema), new StemmingOverrider(this, schema));
            }
            if (this.normalizeAccents(field)) {
                this.addIndexCommand(field, CMD_NORMALIZE);
            }
            if (field.getMatching() == null || field.getMatching().getType().equals((Object)Matching.Type.TEXT)) {
                this.addIndexCommand(field, CMD_PLAIN_TOKENS);
            }
        }
        if (this.isUriField(field)) {
            this.addUriIndexCommands(field);
        }
        if (field.getDataType().getPrimitiveType() instanceof NumericDataType) {
            this.addIndexCommand(field, CMD_NUMERICAL);
        }
        for (String command : field.getQueryCommands()) {
            this.addIndexCommand(field, command);
        }
    }

    private static boolean isAnyChildString(DataType dataType) {
        PrimitiveDataType primitive = dataType.getPrimitiveType();
        if (primitive == PrimitiveDataType.STRING) {
            return true;
        }
        if (primitive != null) {
            return false;
        }
        if (dataType instanceof StructuredDataType) {
            StructuredDataType structured = (StructuredDataType)dataType;
            for (Field field : structured.getFields()) {
                if (!IndexInfo.isAnyChildString(field.getDataType())) continue;
                return true;
            }
        } else if (dataType instanceof MapDataType) {
            MapDataType mapType = (MapDataType)dataType;
            return IndexInfo.isAnyChildString(mapType.getKeyType()) || IndexInfo.isAnyChildString(mapType.getValueType());
        }
        return false;
    }

    private static boolean needLowerCase(ImmutableSDField field) {
        return field.doesIndexing() || field.doesLowerCasing() || (field.doesAttributing() || field.getAttribute() != null) && IndexInfo.isAnyChildString(field.getDataType()) && field.getMatching().getCase().equals((Object)Case.UNCASED);
    }

    static String stemCmd(ImmutableSDField field, Schema schema) {
        return "stem:" + field.getStemming(schema).toStemMode();
    }

    private boolean stemSomehow(ImmutableSDField field, Schema schema) {
        if (field.getStemming(schema).equals((Object)Stemming.NONE)) {
            return false;
        }
        return this.isTypeOrNested(field, (DataType)DataType.STRING);
    }

    private boolean normalizeAccents(ImmutableSDField field) {
        return field.getNormalizing().doRemoveAccents() && this.isTypeOrNested(field, (DataType)DataType.STRING);
    }

    private boolean isTypeOrNested(ImmutableSDField field, DataType type) {
        return field.getDataType().equals((Object)type) || field.getDataType().equals((Object)DataType.getArray((DataType)type)) || field.getDataType().equals((Object)DataType.getWeightedSet((DataType)type));
    }

    private boolean isUriField(ImmutableSDField field) {
        DataType fieldType = field.getDataType();
        if (DataType.URI.equals((Object)fieldType)) {
            return true;
        }
        return fieldType instanceof CollectionDataType && DataType.URI.equals((Object)((CollectionDataType)fieldType).getNestedType());
    }

    private void addUriIndexCommands(ImmutableSDField field) {
        String fieldName = field.getName();
        this.addIndexCommand(fieldName, CMD_FULLURL);
        this.addIndexCommand(fieldName, CMD_LOWERCASE);
        this.addIndexCommand(fieldName + "." + fieldName, CMD_FULLURL);
        this.addIndexCommand(fieldName + "." + fieldName, CMD_LOWERCASE);
        this.addIndexCommand(fieldName + ".path", CMD_FULLURL);
        this.addIndexCommand(fieldName + ".path", CMD_LOWERCASE);
        this.addIndexCommand(fieldName + ".query", CMD_FULLURL);
        this.addIndexCommand(fieldName + ".query", CMD_LOWERCASE);
        this.addIndexCommand(fieldName + ".hostname", CMD_URLHOST);
        this.addIndexCommand(fieldName + ".hostname", CMD_LOWERCASE);
        Index index = field.getIndex("hostname");
        if (index != null) {
            this.addIndexCommand(index, CMD_URLHOST);
        }
    }

    private void addIndexCommand(Index index, String command) {
        this.addIndexCommand(index.getName(), command);
    }

    private void addIndexCommand(ImmutableSDField field, String command) {
        this.addIndexCommand(field, command, null);
    }

    private void addIndexCommand(ImmutableSDField field, String command, IndexOverrider overrider) {
        if (overrider == null || !overrider.override(field.getName(), command, field)) {
            this.addIndexCommand(field.getName(), command);
        }
    }

    private void addIndexCommand(String indexName, String command) {
        this.commands.add(new IndexCommand(indexName, command));
    }

    private void addIndexAlias(String alias, String indexName) {
        this.aliases.put(alias, indexName);
    }

    public boolean hasCommand(String indexName, String command) {
        return this.commands.contains(new IndexCommand(indexName, command));
    }

    private boolean notInCommands(String index) {
        for (IndexCommand command : this.commands) {
            if (!command.getIndex().equals(index)) continue;
            return false;
        }
        return true;
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        IndexInfoConfig.Indexinfo.Builder iiB = new IndexInfoConfig.Indexinfo.Builder();
        iiB.name(this.getName());
        for (IndexCommand indexCommand : this.commands) {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(indexCommand.getIndex()).command(indexCommand.getCommand()));
        }
        for (FieldSet fieldSet : this.fieldSets.values()) {
            if (!this.notInCommands(fieldSet.getName())) continue;
            this.addFieldSetCommands(iiB, fieldSet);
        }
        for (Map.Entry entry : this.aliases.entrySet()) {
            iiB.alias(new IndexInfoConfig.Indexinfo.Alias.Builder().alias((String)entry.getKey()).indexname((String)entry.getValue()));
        }
        builder.indexinfo(iiB);
    }

    private void addFieldSetCommands(IndexInfoConfig.Indexinfo.Builder iiB, FieldSet fieldSet) {
        for (String qc : fieldSet.queryCommands()) {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(qc));
        }
        boolean anyIndexing = false;
        boolean anyAttributing = false;
        boolean anyLowerCasing = false;
        boolean anyStemming = false;
        boolean anyNormalizing = false;
        String phraseSegmentingCommand = null;
        String stemmingCommand = null;
        Matching fieldSetMatching = fieldSet.getMatching();
        for (ImmutableSDField field : fieldSet.fields()) {
            Optional<String> explicitPhraseSegmentingCommand;
            if (field.doesIndexing()) {
                anyIndexing = true;
            }
            if (field.doesAttributing()) {
                anyAttributing = true;
            }
            if (IndexInfo.needLowerCase(field)) {
                anyLowerCasing = true;
            }
            if (this.stemming(field)) {
                anyStemming = true;
                stemmingCommand = "stem:" + this.getEffectiveStemming(field).toStemMode();
            }
            if (field.getNormalizing().doRemoveAccents()) {
                anyNormalizing = true;
            }
            if (fieldSetMatching == null && field.getMatching().getType() != Matching.defaultType) {
                fieldSetMatching = field.getMatching();
            }
            if (!(explicitPhraseSegmentingCommand = field.getQueryCommands().stream().filter(c -> c.startsWith(CMD_PHRASE_SEGMENTING)).findFirst()).isPresent()) continue;
            phraseSegmentingCommand = explicitPhraseSegmentingCommand.get();
        }
        if (anyIndexing && anyAttributing && fieldSet.getMatching() == null) {
            fieldSetMatching = new Matching();
        }
        if (anyLowerCasing) {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_LOWERCASE));
        }
        if (this.hasMultiValueField(fieldSet)) {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_MULTIVALUE));
        }
        if (anyIndexing) {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_INDEX));
            if (!this.isExactMatch(fieldSetMatching)) {
                if (fieldSetMatching == null || fieldSetMatching.getType().equals((Object)Matching.Type.TEXT)) {
                    iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_PLAIN_TOKENS));
                }
                if (anyStemming) {
                    iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(stemmingCommand));
                }
                if (anyNormalizing) {
                    iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_NORMALIZE));
                }
                if (phraseSegmentingCommand != null) {
                    iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(phraseSegmentingCommand));
                }
            }
        } else {
            iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_ATTRIBUTE)).command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_INDEX));
        }
        if (fieldSetMatching != null) {
            if (fieldSetMatching.getType().equals((Object)Matching.Type.EXACT)) {
                String term = fieldSetMatching.getExactMatchTerminator();
                if (term == null) {
                    term = "@@";
                }
                iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command("exact " + term));
            } else if (fieldSetMatching.getType().equals((Object)Matching.Type.WORD)) {
                iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command(CMD_WORD));
            } else if (fieldSetMatching.getType().equals((Object)Matching.Type.GRAM)) {
                iiB.command(new IndexInfoConfig.Indexinfo.Command.Builder().indexname(fieldSet.getName()).command("ngram " + (fieldSetMatching.getGramSize() > 0 ? fieldSetMatching.getGramSize() : 2)));
            } else if (fieldSetMatching.getType().equals((Object)Matching.Type.TEXT)) {
                // empty if block
            }
        }
    }

    private boolean hasMultiValueField(FieldSet fieldSet) {
        for (ImmutableSDField field : fieldSet.fields()) {
            if (!field.getDataType().isMultivalue()) continue;
            return true;
        }
        return false;
    }

    private Stemming getEffectiveStemming(ImmutableSDField field) {
        Stemming active = field.getStemming(this.schema);
        if (field.getIndex(field.getName()) != null && field.getIndex(field.getName()).getStemming() != null) {
            active = field.getIndex(field.getName()).getStemming();
        }
        if (active != null) {
            return active;
        }
        return Stemming.BEST;
    }

    private boolean stemming(ImmutableSDField field) {
        if (field.getStemming() != null) {
            return !field.getStemming().equals((Object)Stemming.NONE);
        }
        if (this.schema.getStemming() == Stemming.NONE) {
            return false;
        }
        if (field.isImportedField()) {
            return false;
        }
        if (field.getIndex(field.getName()) == null) {
            return true;
        }
        if (field.getIndex(field.getName()).getStemming() == null) {
            return true;
        }
        return !field.getIndex(field.getName()).getStemming().equals((Object)Stemming.NONE);
    }

    private boolean isExactMatch(Matching m) {
        if (m == null) {
            return false;
        }
        if (m.getType().equals((Object)Matching.Type.EXACT)) {
            return true;
        }
        return m.getType().equals((Object)Matching.Type.WORD);
    }

    @Override
    protected String getDerivedName() {
        return "index-info";
    }

    private static class StemmingOverrider
    extends IndexOverrider {
        private Schema schema;

        public StemmingOverrider(IndexInfo owner, Schema schema) {
            super(owner);
            this.schema = schema;
        }

        @Override
        public boolean override(String indexName, String command, ImmutableSDField field) {
            if (this.schema == null) {
                return false;
            }
            Index index = this.schema.getIndex(indexName);
            if (index == null) {
                return false;
            }
            Stemming indexStemming = index.getStemming();
            if (indexStemming == null) {
                return false;
            }
            if (!Stemming.NONE.equals((Object)indexStemming)) {
                this.owner.addIndexCommand(indexName, "stem:" + indexStemming.toStemMode());
            }
            return true;
        }
    }

    private static abstract class IndexOverrider {
        protected IndexInfo owner;

        public IndexOverrider(IndexInfo owner) {
            this.owner = owner;
        }

        public abstract boolean override(String var1, String var2, ImmutableSDField var3);
    }

    public static class IndexCommand {
        private String index;
        private String command;

        public IndexCommand(String index, String command) {
            this.index = index;
            this.command = command;
        }

        public String getIndex() {
            return this.index;
        }

        public String getCommand() {
            return this.command;
        }

        public boolean isNull() {
            return this.command.equals("");
        }

        public int hashCode() {
            return this.index.hashCode() + 17 * this.command.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexCommand)) {
                return false;
            }
            IndexCommand other = (IndexCommand)object;
            return other.index.equals(this.index) && other.command.equals(this.command);
        }

        public String toString() {
            return "index command " + this.command + " on index " + this.index;
        }
    }
}

