/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.ImmutableSchema;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import com.yahoo.searchdefinition.document.SDDocumentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RankProfileRegistry {
    private final Map<String, Map<String, RankProfile>> rankProfiles = new LinkedHashMap<String, Map<String, RankProfile>>();
    private final String MAGIC_GLOBAL_RANKPROFILES = "[MAGIC_GLOBAL_RANKPROFILES]";
    static final Set<String> overridableRankProfileNames = new HashSet<String>(Arrays.asList("default", "unranked"));

    public static RankProfileRegistry createRankProfileRegistryWithBuiltinRankProfiles(Schema schema) {
        RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
        rankProfileRegistry.add(new DefaultRankProfile(schema, rankProfileRegistry, schema.rankingConstants()));
        rankProfileRegistry.add(new UnrankedRankProfile(schema, rankProfileRegistry, schema.rankingConstants()));
        return rankProfileRegistry;
    }

    private String extractName(ImmutableSchema search) {
        return search != null ? search.getName() : "[MAGIC_GLOBAL_RANKPROFILES]";
    }

    public void add(RankProfile rankProfile) {
        String searchName = this.extractName(rankProfile.getSearch());
        if (!this.rankProfiles.containsKey(searchName)) {
            this.rankProfiles.put(searchName, new LinkedHashMap());
        }
        this.checkForDuplicate(rankProfile);
        this.rankProfiles.get(searchName).put(rankProfile.getName(), rankProfile);
    }

    private void checkForDuplicate(RankProfile rankProfile) {
        String rankProfileName = rankProfile.getName();
        RankProfile existingRankProfileWithSameName = this.rankProfiles.get(this.extractName(rankProfile.getSearch())).get(rankProfileName);
        if (existingRankProfileWithSameName == null) {
            return;
        }
        if (!overridableRankProfileNames.contains(rankProfileName)) {
            throw new IllegalArgumentException("Duplicate rank profile '" + rankProfileName + "' in " + rankProfile.getSearch());
        }
    }

    public RankProfile get(String schema, String name) {
        Map<String, RankProfile> profiles = this.rankProfiles.get(schema);
        if (profiles == null) {
            return null;
        }
        return profiles.get(name);
    }

    public RankProfile get(ImmutableSchema schema, String name) {
        RankProfile profile = this.get(schema.getName(), name);
        if (profile != null) {
            return profile;
        }
        if (schema.inherited().isPresent()) {
            return this.get(schema.inherited().get(), name);
        }
        return null;
    }

    public RankProfile getGlobal(String name) {
        Map<String, RankProfile> profiles = this.rankProfiles.get("[MAGIC_GLOBAL_RANKPROFILES]");
        if (profiles == null) {
            return null;
        }
        return profiles.get(name);
    }

    public RankProfile resolve(SDDocumentType docType, String name) {
        RankProfile rankProfile = this.get(docType.getName(), name);
        if (rankProfile != null) {
            return rankProfile;
        }
        for (SDDocumentType parent : docType.getInheritedTypes()) {
            RankProfile parentProfile = this.resolve(parent, name);
            if (parentProfile == null) continue;
            return parentProfile;
        }
        return this.get("[MAGIC_GLOBAL_RANKPROFILES]", name);
    }

    public Collection<RankProfile> all() {
        ArrayList<RankProfile> all = new ArrayList<RankProfile>();
        for (Map<String, RankProfile> entry : this.rankProfiles.values()) {
            all.addAll(entry.values());
        }
        return all;
    }

    public Collection<RankProfile> rankProfilesOf(String search) {
        Map<String, RankProfile> mapping = this.rankProfiles.get(search);
        if (mapping == null) {
            return Collections.emptyList();
        }
        return mapping.values();
    }

    public Collection<RankProfile> rankProfilesOf(ImmutableSchema search) {
        return this.rankProfilesOf(this.extractName(search));
    }
}

