/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.RankExpressionBody;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LargeRankExpressions {
    private final Map<String, RankExpressionBody> expressions = new ConcurrentHashMap<String, RankExpressionBody>();
    private final FileRegistry fileRegistry;

    public LargeRankExpressions(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    public void add(RankExpressionBody expression) {
        String name = expression.getName();
        RankExpressionBody prev = this.expressions.putIfAbsent(name, expression);
        if (prev == null) {
            expression.validate();
            expression.register(this.fileRegistry);
        } else if (!prev.getBlob().equals(expression.getBlob())) {
            throw new IllegalArgumentException("Rank expression '" + name + "' defined twice. Previous blob with " + prev.getBlob().remaining() + " bytes, while current has " + expression.getBlob().remaining() + " bytes");
        }
    }

    public Map<String, RankExpressionBody> asMap() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.expressions.values().forEach(constant -> constant.sendTo(services));
    }
}

