/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Schema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Application {
    private final ApplicationPackage applicationPackage;
    private final RankProfileRegistry rankProfileRegistry;
    private final Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public Application(ApplicationPackage applicationPackage) {
        this(applicationPackage, new RankProfileRegistry());
    }

    public Application(ApplicationPackage applicationPackage, RankProfileRegistry rankProfileRegistry) {
        this.applicationPackage = applicationPackage;
        this.rankProfileRegistry = rankProfileRegistry;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public RankProfileRegistry rankProfileRegistry() {
        return this.rankProfileRegistry;
    }

    public void add(Schema schema) {
        if (this.schemas.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Duplicate schema '" + schema.getName() + "' in " + this);
        }
        this.schemas.put(schema.getName(), schema);
    }

    public Map<String, Schema> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public void validate(DeployLogger logger) {
        this.schemas.values().forEach(schema -> schema.validate(logger));
    }

    public String toString() {
        return "application " + this.applicationPackage.getApplicationId();
    }
}

