/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.document.select.DocumentSelector;
import com.yahoo.document.select.NowCheckVisitor;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.convert.SelectionExpressionConverter;
import com.yahoo.document.select.parser.ParseException;
import java.util.Map;

public class DocumentSelectionConverter {
    private final DocumentSelector selector;
    private final Map<String, String> queryExpressionMap;

    public DocumentSelectionConverter(String selection) throws ParseException, UnsupportedOperationException, IllegalArgumentException {
        this.selector = new DocumentSelector(selection);
        NowCheckVisitor nowChecker = new NowCheckVisitor();
        this.selector.visit((Visitor)nowChecker);
        if (nowChecker.requiresConversion()) {
            SelectionExpressionConverter converter = new SelectionExpressionConverter();
            this.selector.visit((Visitor)converter);
            this.queryExpressionMap = converter.getQueryMap();
        } else {
            this.queryExpressionMap = null;
        }
    }

    public String getQuery(String documentType) {
        if (this.queryExpressionMap == null) {
            return null;
        }
        if (!this.queryExpressionMap.containsKey(documentType)) {
            return null;
        }
        return this.queryExpressionMap.get(documentType);
    }

    public String getInvertedQuery(String documentType) {
        String query = this.getQuery(documentType);
        if (query == null) {
            return null;
        }
        return query.replaceAll(">", "<");
    }
}

