/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.Application;
import com.yahoo.searchdefinition.FieldSets;
import com.yahoo.searchdefinition.ImmutableSchema;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.LargeRankExpressions;
import com.yahoo.searchdefinition.OnnxModels;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.document.TemporaryImportedFields;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.AbstractService;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Stream;

public class Schema
implements ImmutableSchema {
    private static final String SD_DOC_FIELD_NAME = "sddocname";
    private static final List<String> RESERVED_NAMES = List.of("index", "index_url", "summary", "attribute", "select_input", "host", "documentid", "position", "split_foreach", "tokenize", "if", "else", "switch", "case", "sddocname", "relevancy");
    private String name;
    private final Optional<String> inherited;
    private final boolean documentsOnly;
    private Boolean rawAsBase64 = null;
    private Stemming stemming = null;
    private final FieldSets fieldSets = new FieldSets(Optional.of(this));
    private SDDocumentType documentType;
    private final Map<String, SDField> fields = new LinkedHashMap<String, SDField>();
    private final Map<String, Index> indices = new LinkedHashMap<String, Index>();
    private final Map<String, DocumentSummary> summaries = new LinkedHashMap<String, DocumentSummary>();
    private final LargeRankExpressions largeRankExpressions;
    private final RankingConstants rankingConstants;
    private final OnnxModels onnxModels;
    private final Optional<TemporaryImportedFields> temporaryImportedFields = Optional.of(new TemporaryImportedFields(this));
    private Optional<ImportedFields> importedFields = Optional.empty();
    private final Application owner;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;

    public Schema(String name) {
        this(name, Optional.empty(), null, null, (DeployLogger)new BaseDeployLogger(), new TestProperties());
    }

    public Schema(String name, Application application, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties) {
        this(name, Optional.empty(), application, fileRegistry, deployLogger, properties);
    }

    public Schema(String name, Optional<String> inherited, Application application, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties) {
        this(inherited, application, fileRegistry, deployLogger, properties, false);
        this.name = name;
    }

    protected Schema(Application application, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties) {
        this(Optional.empty(), application, fileRegistry, deployLogger, properties, true);
    }

    private Schema(Optional<String> inherited, Application application, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, boolean documentsOnly) {
        this.inherited = inherited;
        this.owner = application;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.documentsOnly = documentsOnly;
        this.largeRankExpressions = new LargeRankExpressions(fileRegistry);
        this.rankingConstants = new RankingConstants(fileRegistry, Optional.of(this));
        this.onnxModels = new OnnxModels(fileRegistry, Optional.of(this));
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isDocumentsOnly() {
        return this.documentsOnly;
    }

    public Optional<Schema> inherited() {
        return this.inherited.map(name -> this.owner.schemas().get(name));
    }

    public boolean isRawAsBase64() {
        if (this.rawAsBase64 != null) {
            return this.rawAsBase64;
        }
        if (this.inherited.isEmpty()) {
            return false;
        }
        return this.requireInherited().isRawAsBase64();
    }

    public void enableRawAsBase64() {
        this.rawAsBase64 = true;
    }

    public void setStemming(Stemming stemming) {
        this.stemming = Objects.requireNonNull(stemming, "Stemming cannot be null");
    }

    public Stemming getStemming() {
        if (this.stemming != null) {
            return this.stemming;
        }
        if (this.inherited.isEmpty()) {
            return Stemming.BEST;
        }
        return this.requireInherited().getStemming();
    }

    public void addDocument(SDDocumentType document) {
        if (this.documentType != null) {
            throw new IllegalArgumentException("Searchdefinition cannot have more than one document");
        }
        this.documentType = document;
    }

    @Override
    public LargeRankExpressions rankExpressionFiles() {
        return this.largeRankExpressions;
    }

    @Override
    public RankingConstants rankingConstants() {
        return this.rankingConstants;
    }

    @Override
    public OnnxModels onnxModels() {
        return this.onnxModels;
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.rankingConstants.sendTo(services);
        this.largeRankExpressions.sendTo(services);
        this.onnxModels.sendTo(services);
    }

    public Optional<TemporaryImportedFields> temporaryImportedFields() {
        return this.temporaryImportedFields;
    }

    public Optional<ImportedFields> importedFields() {
        return this.importedFields;
    }

    public void setImportedFields(ImportedFields importedFields) {
        this.importedFields = Optional.of(importedFields);
    }

    @Override
    public Stream<ImmutableSDField> allImportedFields() {
        return this.importedFields.map(fields -> fields.fields().values().stream()).orElse(Stream.empty()).map(field -> field.asImmutableSDField());
    }

    @Override
    public ImmutableSDField getField(String name) {
        SDField field = this.getConcreteField(name);
        if (field != null) {
            return field;
        }
        return this.allImportedFields().filter(f -> f.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public List<ImmutableSDField> allFieldsList() {
        ArrayList<ImmutableSDField> all = new ArrayList<ImmutableSDField>();
        all.addAll(this.extraFieldList());
        for (Field field : this.documentType.fieldSet()) {
            all.add((ImmutableSDField)field);
        }
        if (this.importedFields.isPresent()) {
            for (ImportedField imported : this.importedFields.get().fields().values()) {
                all.add(imported.asImmutableSDField());
            }
        }
        return all;
    }

    public SDDocumentType getDocument(String name) {
        if (this.documentType != null && name.equals(this.documentType.getName())) {
            return this.documentType;
        }
        return null;
    }

    public boolean hasDocument() {
        return this.documentType != null;
    }

    @Override
    public SDDocumentType getDocument() {
        return this.documentType;
    }

    @Override
    public List<SDField> allConcreteFields() {
        ArrayList<SDField> allFields = new ArrayList<SDField>();
        allFields.addAll(this.extraFieldList());
        for (Field field : this.documentType.fieldSet()) {
            allFields.add((SDField)field);
        }
        return allFields;
    }

    @Override
    public Reader getRankingExpression(String fileName) {
        return this.owner.applicationPackage().getRankingExpression(fileName);
    }

    public Application application() {
        return this.owner;
    }

    @Override
    public ApplicationPackage applicationPackage() {
        if (this.owner == null) {
            return null;
        }
        return this.owner.applicationPackage();
    }

    @Override
    public DeployLogger getDeployLogger() {
        return this.deployLogger;
    }

    @Override
    public ModelContext.Properties getDeployProperties() {
        return this.properties;
    }

    @Override
    public SDField getConcreteField(String name) {
        SDField field = this.getExtraField(name);
        if (field != null) {
            return field;
        }
        return (SDField)this.documentType.getField(name);
    }

    public SDField getDocumentField(String name) {
        return (SDField)this.documentType.getField(name);
    }

    public void addExtraField(SDField field) {
        if (this.fields.containsKey(field.getName())) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Duplicate field " + field.getName() + " in search definition " + this.getName());
        } else {
            field.setIsExtraField(true);
            this.fields.put(field.getName(), field);
        }
    }

    public Collection<SDField> extraFieldList() {
        if (this.inherited.isEmpty()) {
            return this.fields.values();
        }
        HashSet<SDField> fields = new HashSet<SDField>(this.requireInherited().extraFieldList());
        fields.addAll(this.fields.values());
        return fields;
    }

    public Collection<SDField> allExtraFields() {
        TreeMap<String, SDField> extraFields = new TreeMap<String, SDField>();
        if (this.inherited.isPresent()) {
            this.requireInherited().allExtraFields().forEach(field -> extraFields.put(field.getName(), (Field)field));
        }
        for (Field field2 : this.documentType.fieldSet()) {
            SDField sdField = (SDField)field2;
            if (!sdField.isExtraField()) continue;
            extraFields.put(sdField.getName(), sdField);
        }
        for (SDField sDField : this.extraFieldList()) {
            extraFields.put(sDField.getName(), sDField);
        }
        return extraFields.values();
    }

    public SDField getExtraField(String fieldName) {
        SDField field = this.fields.get(fieldName);
        if (field != null) {
            return field;
        }
        if (this.inherited.isEmpty()) {
            return null;
        }
        return this.requireInherited().getExtraField(fieldName);
    }

    public void addIndex(Index index) {
        this.indices.put(index.getName(), index);
    }

    @Override
    public Index getIndex(String name) {
        ArrayList<Index> sameIndices = new ArrayList<Index>(1);
        this.getSchemaIndex(name).ifPresent(sameIndices::add);
        for (ImmutableSDField immutableSDField : this.allConcreteFields()) {
            if (immutableSDField.getIndex(name) == null) continue;
            sameIndices.add(immutableSDField.getIndex(name));
        }
        if (sameIndices.size() == 0) {
            return null;
        }
        if (sameIndices.size() == 1) {
            return (Index)sameIndices.get(0);
        }
        return this.consolidateIndices(sameIndices);
    }

    Optional<Index> getSchemaIndex(String name) {
        if (this.indices.containsKey(name)) {
            return Optional.of(this.indices.get(name));
        }
        if (this.inherited.isPresent()) {
            return this.requireInherited().getSchemaIndex(name);
        }
        return Optional.empty();
    }

    public boolean existsIndex(String name) {
        if (this.indices.get(name) != null) {
            return true;
        }
        if (this.inherited.isPresent() && this.requireInherited().existsIndex(name)) {
            return true;
        }
        for (ImmutableSDField immutableSDField : this.allConcreteFields()) {
            if (!immutableSDField.existsIndex(name)) continue;
            return true;
        }
        return false;
    }

    private Index consolidateIndices(List<Index> indices) {
        Index first = indices.get(0);
        Index consolidated = new Index(first.getName());
        consolidated.setRankType(first.getRankType());
        consolidated.setType(first.getType());
        for (Index current : indices) {
            if (current.isPrefix()) {
                consolidated.setPrefix(true);
            }
            if (current.useInterleavedFeatures()) {
                consolidated.setInterleavedFeatures(true);
            }
            if (consolidated.getRankType() == null) {
                consolidated.setRankType(current.getRankType());
            } else if (current.getRankType() != null && !consolidated.getRankType().equals((Object)current.getRankType())) {
                this.deployLogger.logApplicationPackage(Level.WARNING, "Conflicting rank type settings for " + first.getName() + " in " + this + ", using " + consolidated.getRankType());
            }
            Iterator<String> j = current.aliasIterator();
            while (j.hasNext()) {
                consolidated.addAlias(j.next());
            }
        }
        return consolidated;
    }

    @Override
    public List<Index> getExplicitIndices() {
        ArrayList<Index> allIndices = new ArrayList<Index>(this.indices.values());
        if (this.inherited.isPresent()) {
            for (Index index : this.requireInherited().getExplicitIndices()) {
                if (this.indices.containsKey(index.getName())) continue;
                allIndices.add(index);
            }
        }
        for (ImmutableSDField immutableSDField : this.allConcreteFields()) {
            for (Index index : immutableSDField.getIndices().values()) {
                allIndices.add(index);
            }
        }
        return Collections.unmodifiableList(allIndices);
    }

    public void addSummary(DocumentSummary summary) {
        this.summaries.put(summary.getName(), summary);
    }

    public DocumentSummary getSummary(String name) {
        DocumentSummary summary = this.summaries.get(name);
        if (summary != null) {
            return summary;
        }
        if (this.inherited.isEmpty()) {
            return null;
        }
        return this.requireInherited().getSummary(name);
    }

    public SummaryField getSummaryField(String name) {
        for (DocumentSummary summary : this.summaries.values()) {
            SummaryField summaryField = summary.getSummaryField(name);
            if (summaryField == null) continue;
            return summaryField;
        }
        if (this.inherited.isEmpty()) {
            return null;
        }
        return this.requireInherited().getSummaryField(name);
    }

    public SummaryField getExplicitSummaryField(String name) {
        for (DocumentSummary summary : this.summaries.values()) {
            SummaryField summaryField = summary.getSummaryField(name);
            if (summaryField == null || summaryField.isImplicit()) continue;
            return summaryField;
        }
        if (this.inherited.isEmpty()) {
            return null;
        }
        return this.requireInherited().getExplicitSummaryField(name);
    }

    public Map<String, DocumentSummary> getSummaries() {
        if (this.inherited.isEmpty()) {
            return this.summaries;
        }
        if (this.summaries.isEmpty()) {
            return this.requireInherited().getSummaries();
        }
        LinkedHashMap<String, DocumentSummary> allSummaries = new LinkedHashMap<String, DocumentSummary>(this.requireInherited().getSummaries());
        allSummaries.putAll(this.summaries);
        return allSummaries;
    }

    public Map<String, DocumentSummary> getSummariesInThis() {
        return Collections.unmodifiableMap(this.summaries);
    }

    @Override
    public Map<String, SummaryField> getSummaryFields(ImmutableSDField field) {
        LinkedHashMap<String, SummaryField> summaryFields = this.inherited.isPresent() ? this.requireInherited().getSummaryFields(field) : new LinkedHashMap();
        for (DocumentSummary documentSummary : this.summaries.values()) {
            for (SummaryField summaryField : documentSummary.getSummaryFields().values()) {
                if (!summaryField.hasSource(field.getName())) continue;
                summaryFields.put(summaryField.getName(), summaryField);
            }
        }
        return summaryFields;
    }

    public Map<String, SummaryField> getUniqueNamedSummaryFields() {
        LinkedHashMap<String, SummaryField> summaryFields = this.inherited.isPresent() ? this.requireInherited().getUniqueNamedSummaryFields() : new LinkedHashMap();
        for (DocumentSummary documentSummary : this.summaries.values()) {
            for (SummaryField summaryField : documentSummary.getSummaryFields().values()) {
                summaryFields.put(summaryField.getName(), summaryField);
            }
        }
        return summaryFields;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Attribute getAttribute(String name) {
        for (ImmutableSDField immutableSDField : this.allConcreteFields()) {
            Attribute attribute = immutableSDField.getAttributes().get(name);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)o;
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return "schema '" + this.getName() + "'";
    }

    public boolean isAccessingDiskSummary(SummaryField field) {
        if (!field.getTransform().isInMemory()) {
            return true;
        }
        if (field.getSources().size() == 0) {
            return this.isAccessingDiskSummary(this.getName());
        }
        for (SummaryField.Source source : field.getSources()) {
            if (!this.isAccessingDiskSummary(source.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isAccessingDiskSummary(String source) {
        SDField field = this.getConcreteField(source);
        if (field == null) {
            return false;
        }
        return field.doesSummarying() && !field.doesAttributing();
    }

    public FieldSets fieldSets() {
        return this.fieldSets;
    }

    private Schema requireInherited() {
        return this.owner.schemas().get(this.inherited.get());
    }

    public Schema addType(SDDocumentType dt) {
        this.documentType.addType(dt);
        return this;
    }

    public Schema addAnnotation(SDAnnotationType dt) {
        this.documentType.addAnnotation(dt);
        return this;
    }

    public void validate(DeployLogger logger) {
        if (this.inherited.isPresent()) {
            if (!this.owner.schemas().containsKey(this.inherited.get())) {
                throw new IllegalArgumentException(this + " inherits '" + this.inherited.get() + "', but this schema does not exist");
            }
            SDDocumentType parentDocument = this.owner.schemas().get(this.inherited.get()).getDocument();
            if (!this.getDocument().inheritedTypes().containsKey(new DataTypeName(parentDocument.getName()))) {
                throw new IllegalArgumentException(this + " inherits '" + this.inherited.get() + "', but its document type does not inherit the parent's document type");
            }
        }
        for (DocumentSummary summary : this.summaries.values()) {
            summary.validate(logger);
        }
    }

    public static boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }
}

