/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModels;
import com.google.common.collect.ImmutableMap;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.ImmutableSchema;
import com.yahoo.searchdefinition.MapEvaluationTypeContext;
import com.yahoo.searchdefinition.OnnxModel;
import com.yahoo.searchdefinition.OnnxModels;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstants;
import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImmutableSDField;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.expressiontransforms.ExpressionTransforms;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RankProfile
implements Cloneable {
    public static final String FIRST_PHASE = "firstphase";
    public static final String SECOND_PHASE = "secondphase";
    private final String name;
    private final ImmutableSchema search;
    private String inheritedName = null;
    private RankProfile inherited = null;
    private MatchPhaseSettings matchPhaseSettings = null;
    protected Set<RankSetting> rankSettings = new LinkedHashSet<RankSetting>();
    private RankingExpressionFunction firstPhaseRanking = null;
    private RankingExpressionFunction secondPhaseRanking = null;
    private int rerankCount = -1;
    private int keepRankCount = -1;
    private int numThreadsPerSearch = -1;
    private int minHitsPerThread = -1;
    private int numSearchPartitions = -1;
    private Double termwiseLimit = null;
    private double rankScoreDropLimit = -1.7976931348623157E308;
    private Set<ReferenceNode> summaryFeatures;
    private String inheritedSummaryFeatures;
    private Set<ReferenceNode> rankFeatures;
    private Map<String, List<RankProperty>> rankProperties = new LinkedHashMap<String, List<RankProperty>>();
    private Boolean ignoreDefaultRankFeatures = null;
    private Map<String, RankingExpressionFunction> functions = new LinkedHashMap<String, RankingExpressionFunction>();
    private CachedFunctions allFunctionsCached = null;
    private Map<Reference, TensorType> inputFeatures = new LinkedHashMap<Reference, TensorType>();
    private Set<String> filterFields = new HashSet<String>();
    private final RankProfileRegistry rankProfileRegistry;
    private Map<String, Value> constants = new HashMap<String, Value>();
    private final TypeSettings attributeTypes = new TypeSettings();
    private final TypeSettings queryFeatureTypes = new TypeSettings();
    private List<ImmutableSDField> allFieldsList;
    private final OnnxModels onnxModels;
    private final RankingConstants rankingConstants;
    private final ApplicationPackage applicationPackage;
    private final DeployLogger deployLogger;
    private final List<ExecuteOperation> executeOperations = new ArrayList<ExecuteOperation>();

    public RankProfile(String name, Schema schema, RankProfileRegistry rankProfileRegistry, RankingConstants rankingConstants) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.search = Objects.requireNonNull(schema, "search cannot be null");
        this.onnxModels = null;
        this.rankingConstants = rankingConstants;
        this.rankProfileRegistry = rankProfileRegistry;
        this.applicationPackage = schema.applicationPackage();
        this.deployLogger = schema.getDeployLogger();
    }

    public RankProfile(String name, ApplicationPackage applicationPackage, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, RankingConstants rankingConstants, OnnxModels onnxModels) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.search = null;
        this.rankProfileRegistry = rankProfileRegistry;
        this.rankingConstants = rankingConstants;
        this.onnxModels = onnxModels;
        this.applicationPackage = applicationPackage;
        this.deployLogger = deployLogger;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableSchema getSearch() {
        return this.search;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public RankingConstants rankingConstants() {
        return this.rankingConstants;
    }

    public Map<String, OnnxModel> onnxModels() {
        return this.search != null ? this.search.onnxModels().asMap() : this.onnxModels.asMap();
    }

    private Stream<ImmutableSDField> allFields() {
        if (this.search == null) {
            return Stream.empty();
        }
        if (this.allFieldsList == null) {
            this.allFieldsList = this.search.allFieldsList();
        }
        return this.allFieldsList.stream();
    }

    private Stream<ImmutableSDField> allImportedFields() {
        return this.search != null ? this.search.allImportedFields() : Stream.empty();
    }

    public void setInherited(String inheritedName) {
        this.inheritedName = inheritedName;
    }

    public String getInheritedName() {
        return this.inheritedName;
    }

    private RankProfile getInherited() {
        if (this.inheritedName == null) {
            return null;
        }
        if (this.inherited == null) {
            this.inherited = this.resolveInherited();
            if (this.inherited == null) {
                String msg = "rank-profile '" + this.getName() + "' inherits '" + this.inheritedName + "', but it does not exist anywhere in the inheritance of search '" + (this.getSearch() != null ? this.getSearch().getName() : " global rank profiles") + "'.";
                throw new IllegalArgumentException(msg);
            }
            ArrayList<String> children = new ArrayList<String>();
            children.add(this.createFullyQualifiedName());
            this.verifyNoInheritanceCycle(children, this.inherited);
        }
        return this.inherited;
    }

    private String createFullyQualifiedName() {
        return this.search != null ? this.search.getName() + "." + this.getName() : this.getName();
    }

    private void verifyNoInheritanceCycle(List<String> children, RankProfile parent) {
        children.add(parent.createFullyQualifiedName());
        String root = children.get(0);
        if (root.equals(parent.createFullyQualifiedName())) {
            throw new IllegalArgumentException("There is a cycle in the inheritance for rank-profile '" + root + "' = " + children);
        }
        if (parent.getInherited() != null) {
            this.verifyNoInheritanceCycle(children, parent.getInherited());
        }
    }

    private RankProfile resolveInherited(ImmutableSchema schema) {
        SDDocumentType documentType = schema.getDocument();
        if (documentType != null) {
            if (this.name.equals(this.inheritedName)) {
                for (SDDocumentType baseType : documentType.getInheritedTypes()) {
                    RankProfile resolvedFromBase = this.rankProfileRegistry.resolve(baseType, this.inheritedName);
                    if (resolvedFromBase == null) continue;
                    return resolvedFromBase;
                }
            }
            return this.rankProfileRegistry.resolve(documentType, this.inheritedName);
        }
        return this.rankProfileRegistry.get(schema.getName(), this.inheritedName);
    }

    private RankProfile resolveInherited() {
        if (this.inheritedName == null) {
            return null;
        }
        return this.getSearch() != null ? this.resolveInherited(this.search) : this.rankProfileRegistry.getGlobal(this.inheritedName);
    }

    public boolean inherits(String name) {
        for (RankProfile parent = this.getInherited(); parent != null; parent = parent.getInherited()) {
            if (!parent.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setMatchPhaseSettings(MatchPhaseSettings settings) {
        settings.checkValid();
        this.matchPhaseSettings = settings;
    }

    public MatchPhaseSettings getMatchPhaseSettings() {
        MatchPhaseSettings settings = this.matchPhaseSettings;
        if (settings != null) {
            return settings;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getMatchPhaseSettings();
        }
        return null;
    }

    public void addRankSetting(RankSetting rankSetting) {
        this.rankSettings.add(rankSetting);
    }

    public void addRankSetting(String fieldName, RankSetting.Type type, Object value) {
        this.addRankSetting(new RankSetting(fieldName, type, value));
    }

    RankSetting getDeclaredRankSetting(String field, RankSetting.Type type) {
        Iterator<RankSetting> i = this.declaredRankSettingIterator();
        while (i.hasNext()) {
            RankSetting setting = i.next();
            if (!setting.getFieldName().equals(field) || !setting.getType().equals((Object)type)) continue;
            return setting;
        }
        return null;
    }

    public RankSetting getRankSetting(String field, RankSetting.Type type) {
        RankSetting rankSetting = this.getDeclaredRankSetting(field, type);
        if (rankSetting != null) {
            return rankSetting;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankSetting(field, type);
        }
        return null;
    }

    public Iterator<RankSetting> declaredRankSettingIterator() {
        return Collections.unmodifiableSet(this.rankSettings).iterator();
    }

    public Iterator<RankSetting> rankSettingIterator() {
        return this.rankSettings().iterator();
    }

    public Set<RankSetting> rankSettings() {
        LinkedHashSet<RankSetting> allSettings = new LinkedHashSet<RankSetting>(this.rankSettings);
        RankProfile parent = this.getInherited();
        if (parent != null) {
            allSettings.addAll(parent.rankSettings());
        }
        return allSettings;
    }

    public void addConstant(String name, Value value) {
        TensorType type;
        if (value instanceof TensorValue && (type = value.type()).dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
            throw new IllegalArgumentException("Illegal type of constant " + name + " type " + type + ": Dense tensor dimensions must have a size");
        }
        this.constants.put(name, value.freeze());
    }

    public void addConstantTensor(String name, TensorValue value) {
        this.addConstant(name, (Value)value);
    }

    public Map<String, Value> getConstants() {
        if (this.constants.isEmpty()) {
            return this.getInherited() != null ? this.getInherited().getConstants() : Collections.emptyMap();
        }
        if (this.getInherited() == null || this.getInherited().getConstants().isEmpty()) {
            return Collections.unmodifiableMap(this.constants);
        }
        HashMap<String, Value> combinedConstants = new HashMap<String, Value>(this.getInherited().getConstants());
        combinedConstants.putAll(this.constants);
        return combinedConstants;
    }

    public void addAttributeType(String attributeName, String attributeType) {
        this.attributeTypes.addType(attributeName, attributeType);
    }

    public Map<String, String> getAttributeTypes() {
        return this.attributeTypes.getTypes();
    }

    public void addQueryFeatureType(String queryFeature, String queryFeatureType) {
        this.queryFeatureTypes.addType(queryFeature, queryFeatureType);
    }

    public Map<String, String> getQueryFeatureTypes() {
        return this.queryFeatureTypes.getTypes();
    }

    public RankingExpression getFirstPhaseRanking() {
        RankingExpressionFunction function = this.getFirstPhase();
        if (function == null) {
            return null;
        }
        return function.function.getBody();
    }

    public RankingExpressionFunction getFirstPhase() {
        if (this.firstPhaseRanking != null) {
            return this.firstPhaseRanking;
        }
        RankProfile inherited = this.getInherited();
        if (inherited != null) {
            return inherited.getFirstPhase();
        }
        return null;
    }

    void setFirstPhaseRanking(RankingExpression rankingExpression) {
        this.firstPhaseRanking = new RankingExpressionFunction(new ExpressionFunction(FIRST_PHASE, Collections.emptyList(), rankingExpression), false);
    }

    public void setFirstPhaseRanking(String expression) {
        try {
            this.firstPhaseRanking = new RankingExpressionFunction(this.parseRankingExpression(FIRST_PHASE, Collections.emptyList(), expression), false);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal first phase ranking function", e);
        }
    }

    public RankingExpression getSecondPhaseRanking() {
        RankingExpressionFunction function = this.getSecondPhase();
        if (function == null) {
            return null;
        }
        return function.function().getBody();
    }

    public RankingExpressionFunction getSecondPhase() {
        if (this.secondPhaseRanking != null) {
            return this.secondPhaseRanking;
        }
        RankProfile inherited = this.getInherited();
        if (inherited != null) {
            return inherited.getSecondPhase();
        }
        return null;
    }

    public void setSecondPhaseRanking(String expression) {
        try {
            this.secondPhaseRanking = new RankingExpressionFunction(this.parseRankingExpression(SECOND_PHASE, Collections.emptyList(), expression), false);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal second phase ranking function", e);
        }
    }

    public Set<ReferenceNode> getSummaryFeatures() {
        if (this.inheritedSummaryFeatures != null && this.summaryFeatures != null) {
            HashSet<ReferenceNode> combined = new HashSet<ReferenceNode>();
            combined.addAll(this.getInherited().getSummaryFeatures());
            combined.addAll(this.summaryFeatures);
            return Collections.unmodifiableSet(combined);
        }
        if (this.summaryFeatures != null) {
            return Collections.unmodifiableSet(this.summaryFeatures);
        }
        if (this.getInherited() != null) {
            return this.getInherited().getSummaryFeatures();
        }
        return Set.of();
    }

    private void addSummaryFeature(ReferenceNode feature) {
        if (this.summaryFeatures == null) {
            this.summaryFeatures = new LinkedHashSet<ReferenceNode>();
        }
        this.summaryFeatures.add(feature);
    }

    public void addSummaryFeatures(FeatureList features) {
        for (ReferenceNode feature : features) {
            this.addSummaryFeature(feature);
        }
    }

    public void setInheritedSummaryFeatures(String parentProfile) {
        if (!parentProfile.equals(this.inheritedName)) {
            throw new IllegalArgumentException("This can only inherit the summary features of its parent, '" + this.inheritedName + ", but attemtping to inherit '" + parentProfile);
        }
        this.inheritedSummaryFeatures = parentProfile;
    }

    public Set<ReferenceNode> getRankFeatures() {
        if (this.rankFeatures != null) {
            return Collections.unmodifiableSet(this.rankFeatures);
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankFeatures();
        }
        return Collections.emptySet();
    }

    private void addRankFeature(ReferenceNode feature) {
        if (this.rankFeatures == null) {
            this.rankFeatures = new LinkedHashSet<ReferenceNode>();
        }
        this.rankFeatures.add(feature);
    }

    public void addRankFeatures(FeatureList features) {
        for (ReferenceNode feature : features) {
            this.addRankFeature(feature);
        }
    }

    public List<RankProperty> getRankProperties() {
        ArrayList<RankProperty> properties = new ArrayList<RankProperty>();
        for (List<RankProperty> propertyList : this.getRankPropertyMap().values()) {
            properties.addAll(propertyList);
        }
        return Collections.unmodifiableList(properties);
    }

    public Map<String, List<RankProperty>> getRankPropertyMap() {
        if (this.rankProperties.size() == 0 && this.getInherited() == null) {
            return Collections.emptyMap();
        }
        if (this.rankProperties.size() == 0) {
            return this.getInherited().getRankPropertyMap();
        }
        if (this.getInherited() == null) {
            return Collections.unmodifiableMap(this.rankProperties);
        }
        LinkedHashMap<String, List<RankProperty>> combined = new LinkedHashMap<String, List<RankProperty>>(this.getInherited().getRankPropertyMap());
        combined.putAll(this.rankProperties);
        return Collections.unmodifiableMap(combined);
    }

    public void addRankProperty(String name, String parameter) {
        this.addRankProperty(new RankProperty(name, parameter));
    }

    private void addRankProperty(RankProperty rankProperty) {
        this.rankProperties.computeIfAbsent(rankProperty.getName(), key -> new ArrayList(1)).add(rankProperty);
    }

    public String toString() {
        return "rank profile '" + this.getName() + "'";
    }

    public int getRerankCount() {
        return this.rerankCount < 0 && this.getInherited() != null ? this.getInherited().getRerankCount() : this.rerankCount;
    }

    public int getNumThreadsPerSearch() {
        return this.numThreadsPerSearch < 0 && this.getInherited() != null ? this.getInherited().getNumThreadsPerSearch() : this.numThreadsPerSearch;
    }

    public void setNumThreadsPerSearch(int numThreads) {
        this.numThreadsPerSearch = numThreads;
    }

    public int getMinHitsPerThread() {
        return this.minHitsPerThread < 0 && this.getInherited() != null ? this.getInherited().getMinHitsPerThread() : this.minHitsPerThread;
    }

    public void setMinHitsPerThread(int minHits) {
        this.minHitsPerThread = minHits;
    }

    public void setNumSearchPartitions(int numSearchPartitions) {
        this.numSearchPartitions = numSearchPartitions;
    }

    public int getNumSearchPartitions() {
        return this.numSearchPartitions < 0 && this.getInherited() != null ? this.getInherited().getNumSearchPartitions() : this.numSearchPartitions;
    }

    public OptionalDouble getTermwiseLimit() {
        return this.termwiseLimit == null && this.getInherited() != null ? this.getInherited().getTermwiseLimit() : (this.termwiseLimit != null ? OptionalDouble.of(this.termwiseLimit) : OptionalDouble.empty());
    }

    public void setTermwiseLimit(double termwiseLimit) {
        this.termwiseLimit = termwiseLimit;
    }

    public void setRerankCount(int rerankCount) {
        this.rerankCount = rerankCount;
    }

    public void setIgnoreDefaultRankFeatures(Boolean ignoreDefaultRankFeatures) {
        this.ignoreDefaultRankFeatures = ignoreDefaultRankFeatures;
    }

    public boolean getIgnoreDefaultRankFeatures() {
        if (this.ignoreDefaultRankFeatures != null) {
            return this.ignoreDefaultRankFeatures;
        }
        return this.getInherited() != null && this.getInherited().getIgnoreDefaultRankFeatures();
    }

    public void addFunction(String name, List<String> arguments, String expression, boolean inline) {
        try {
            this.addFunction(this.parseRankingExpression(name, arguments, expression), inline);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse function '" + name + "'", e);
        }
    }

    public RankingExpressionFunction addFunction(ExpressionFunction function, boolean inline) {
        RankingExpressionFunction rankingExpressionFunction = new RankingExpressionFunction(function, inline);
        if (this.functions.containsKey(function.getName())) {
            this.deployLogger.log(Level.WARNING, "Function '" + function.getName() + "' replaces a previous function with the same name in rank profile '" + this.name + "'");
        }
        this.functions.put(function.getName(), rankingExpressionFunction);
        this.allFunctionsCached = null;
        return rankingExpressionFunction;
    }

    public void addInputFeature(String name, TensorType declaredType) {
        TensorType hadType;
        Reference ref = Reference.fromIdentifier((String)name);
        if (this.inputFeatures.containsKey(ref) && !declaredType.equals((Object)(hadType = this.inputFeatures.get(ref)))) {
            throw new IllegalArgumentException("Tried to replace input feature " + name + " with different type: " + hadType + " -> " + declaredType);
        }
        this.inputFeatures.put(ref, declaredType);
    }

    public void addExecuteOperation(ExecuteOperation.Phase phase, String attribute, String operation) {
        this.executeOperations.add(new ExecuteOperation(phase, attribute, operation));
        this.addRankProperty("vespa.execute." + phase + ".attribute", attribute);
        this.addRankProperty("vespa.execute." + phase + ".operation", operation);
    }

    public List<ExecuteOperation> getExecuteOperations() {
        return this.executeOperations;
    }

    public RankingExpressionFunction findFunction(String name) {
        RankingExpressionFunction function = this.functions.get(name);
        return function == null && this.getInherited() != null ? this.getInherited().findFunction(name) : function;
    }

    public Map<String, RankingExpressionFunction> getFunctions() {
        this.updateCachedFunctions();
        return this.allFunctionsCached.allRankingExpressionFunctions;
    }

    private ImmutableMap<String, ExpressionFunction> getExpressionFunctions() {
        this.updateCachedFunctions();
        return this.allFunctionsCached.allExpressionFunctions;
    }

    private void updateCachedFunctions() {
        if (this.needToUpdateFunctionCache()) {
            this.allFunctionsCached = new CachedFunctions(this.gatherAllFunctions());
        }
    }

    private Map<String, RankingExpressionFunction> gatherAllFunctions() {
        if (this.functions.isEmpty() && this.getInherited() == null) {
            return Collections.emptyMap();
        }
        if (this.functions.isEmpty()) {
            return this.getInherited().getFunctions();
        }
        if (this.getInherited() == null) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, RankingExpressionFunction>(this.functions));
        }
        LinkedHashMap<String, RankingExpressionFunction> allFunctions = new LinkedHashMap<String, RankingExpressionFunction>(this.getInherited().getFunctions());
        allFunctions.putAll(this.functions);
        return Collections.unmodifiableMap(allFunctions);
    }

    private boolean needToUpdateFunctionCache() {
        if (this.getInherited() != null) {
            return this.allFunctionsCached == null || this.getInherited().needToUpdateFunctionCache();
        }
        return this.allFunctionsCached == null;
    }

    public int getKeepRankCount() {
        if (this.keepRankCount >= 0) {
            return this.keepRankCount;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getKeepRankCount();
        }
        return -1;
    }

    public void setKeepRankCount(int rerankArraySize) {
        this.keepRankCount = rerankArraySize;
    }

    public double getRankScoreDropLimit() {
        if (this.rankScoreDropLimit > -1.7976931348623157E308) {
            return this.rankScoreDropLimit;
        }
        if (this.getInherited() != null) {
            return this.getInherited().getRankScoreDropLimit();
        }
        return this.rankScoreDropLimit;
    }

    public void setRankScoreDropLimit(double rankScoreDropLimit) {
        this.rankScoreDropLimit = rankScoreDropLimit;
    }

    public Set<String> filterFields() {
        return this.filterFields;
    }

    public Set<String> allFilterFields() {
        RankProfile parent = this.getInherited();
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        if (parent != null) {
            retval.addAll(parent.allFilterFields());
        }
        retval.addAll(this.filterFields());
        return retval;
    }

    private ExpressionFunction parseRankingExpression(String name, List<String> arguments, String expression) throws ParseException {
        ExpressionFunction expressionFunction;
        block10: {
            if (expression.trim().length() == 0) {
                throw new ParseException("Encountered an empty ranking expression in " + this.getName() + ", " + name + ".");
            }
            Reader rankingExpressionReader = this.openRankingExpressionReader(name, expression.trim());
            try {
                expressionFunction = new ExpressionFunction(name, arguments, new RankingExpression(name, rankingExpressionReader));
                if (rankingExpressionReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (rankingExpressionReader != null) {
                        try {
                            rankingExpressionReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
                    ParseException exception = new ParseException("Could not parse ranking expression '" + expression.trim() + "' in " + this.getName() + ", " + name + ".");
                    throw (ParseException)exception.initCause(e);
                }
                catch (IOException e) {
                    throw new RuntimeException("IOException parsing ranking expression '" + name + "'");
                }
            }
            rankingExpressionReader.close();
        }
        return expressionFunction;
    }

    private static String extractFileName(String expression) {
        Object fileName = expression.substring("file:".length()).trim();
        if (!((String)fileName).endsWith(".expression")) {
            fileName = (String)fileName + ".expression";
        }
        return fileName;
    }

    private Reader openRankingExpressionReader(String expName, String expression) {
        if (!expression.startsWith("file:")) {
            return new StringReader(expression);
        }
        String fileName = RankProfile.extractFileName(expression);
        File file = new File(fileName);
        if (!file.isAbsolute() && file.getPath().contains("/")) {
            throw new IllegalArgumentException("In " + this.getName() + ", " + expName + ", ranking references file '" + file + "' in subdirectory, which is not supported.");
        }
        return this.search.getRankingExpression(fileName);
    }

    public RankProfile clone() {
        try {
            RankProfile clone = (RankProfile)super.clone();
            clone.rankSettings = new LinkedHashSet<RankSetting>(this.rankSettings);
            clone.matchPhaseSettings = this.matchPhaseSettings;
            clone.summaryFeatures = this.summaryFeatures != null ? new LinkedHashSet<ReferenceNode>(this.summaryFeatures) : null;
            clone.rankFeatures = this.rankFeatures != null ? new LinkedHashSet<ReferenceNode>(this.rankFeatures) : null;
            clone.rankProperties = new LinkedHashMap<String, List<RankProperty>>(this.rankProperties);
            clone.inputFeatures = new LinkedHashMap<Reference, TensorType>(this.inputFeatures);
            clone.functions = new LinkedHashMap<String, RankingExpressionFunction>(this.functions);
            clone.allFunctionsCached = null;
            clone.filterFields = new HashSet<String>(this.filterFields);
            clone.constants = new HashMap<String, Value>(this.constants);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public RankProfile compile(QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        try {
            RankProfile compiled = this.clone();
            compiled.compileThis(queryProfiles, importedModels);
            return compiled;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Rank profile '" + this.getName() + "' is invalid", e);
        }
    }

    private void compileThis(QueryProfileRegistry queryProfiles, ImportedMlModels importedModels) {
        this.checkNameCollisions(this.getFunctions(), this.getConstants());
        ExpressionTransforms expressionTransforms = new ExpressionTransforms();
        Map<Reference, TensorType> featureTypes = this.collectFeatureTypes();
        Map<String, RankingExpressionFunction> inlineFunctions = this.compileFunctions(this::getInlineFunctions, queryProfiles, featureTypes, importedModels, Collections.emptyMap(), expressionTransforms);
        this.firstPhaseRanking = this.compile(this.getFirstPhase(), queryProfiles, featureTypes, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
        this.secondPhaseRanking = this.compile(this.getSecondPhase(), queryProfiles, featureTypes, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
        this.functions = this.compileFunctions(this::getFunctions, queryProfiles, featureTypes, importedModels, inlineFunctions, expressionTransforms);
        this.allFunctionsCached = null;
    }

    private void checkNameCollisions(Map<String, RankingExpressionFunction> functions, Map<String, Value> constants) {
        for (Map.Entry<String, RankingExpressionFunction> functionEntry : functions.entrySet()) {
            if (!constants.containsKey(functionEntry.getKey())) continue;
            throw new IllegalArgumentException("Cannot have both a constant and function named '" + functionEntry.getKey() + "'");
        }
    }

    private Map<String, RankingExpressionFunction> getInlineFunctions() {
        return this.getFunctions().entrySet().stream().filter(x -> ((RankingExpressionFunction)x.getValue()).inline()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, RankingExpressionFunction> compileFunctions(Supplier<Map<String, RankingExpressionFunction>> functions, QueryProfileRegistry queryProfiles, Map<Reference, TensorType> featureTypes, ImportedMlModels importedModels, Map<String, RankingExpressionFunction> inlineFunctions, ExpressionTransforms expressionTransforms) {
        Map.Entry<String, RankingExpressionFunction> entry;
        LinkedHashMap<String, RankingExpressionFunction> compiledFunctions = new LinkedHashMap<String, RankingExpressionFunction>();
        while (null != (entry = RankProfile.findUncompiledFunction(functions.get(), compiledFunctions.keySet()))) {
            RankingExpressionFunction rankingExpressionFunction = entry.getValue();
            RankingExpressionFunction compiled = this.compile(rankingExpressionFunction, queryProfiles, featureTypes, importedModels, this.getConstants(), inlineFunctions, expressionTransforms);
            compiledFunctions.put(entry.getKey(), compiled);
        }
        return compiledFunctions;
    }

    private static Map.Entry<String, RankingExpressionFunction> findUncompiledFunction(Map<String, RankingExpressionFunction> functions, Set<String> compiledFunctionNames) {
        for (Map.Entry<String, RankingExpressionFunction> entry : functions.entrySet()) {
            if (compiledFunctionNames.contains(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    private RankingExpressionFunction compile(RankingExpressionFunction function, QueryProfileRegistry queryProfiles, Map<Reference, TensorType> featureTypes, ImportedMlModels importedModels, Map<String, Value> constants, Map<String, RankingExpressionFunction> inlineFunctions, ExpressionTransforms expressionTransforms) {
        if (function == null) {
            return null;
        }
        RankProfileTransformContext context = new RankProfileTransformContext(this, queryProfiles, featureTypes, importedModels, constants, inlineFunctions);
        RankingExpression expression = expressionTransforms.transform(function.function().getBody(), context);
        for (Map.Entry<String, String> rankProperty : context.rankProperties().entrySet()) {
            this.addRankProperty(rankProperty.getKey(), rankProperty.getValue());
        }
        return function.withExpression(expression);
    }

    public MapEvaluationTypeContext typeContext(QueryProfileRegistry queryProfiles) {
        return this.typeContext(queryProfiles, this.collectFeatureTypes());
    }

    public MapEvaluationTypeContext typeContext() {
        return this.typeContext(new QueryProfileRegistry());
    }

    private Map<Reference, TensorType> collectFeatureTypes() {
        HashMap<Reference, TensorType> featureTypes = new HashMap<Reference, TensorType>();
        this.inputFeatures.forEach((k, v) -> featureTypes.put((Reference)k, (TensorType)v));
        this.allFields().forEach(field -> this.addAttributeFeatureTypes((ImmutableSDField)field, (Map<Reference, TensorType>)featureTypes));
        this.allImportedFields().forEach(field -> this.addAttributeFeatureTypes((ImmutableSDField)field, (Map<Reference, TensorType>)featureTypes));
        return featureTypes;
    }

    public MapEvaluationTypeContext typeContext(QueryProfileRegistry queryProfiles, Map<Reference, TensorType> featureTypes) {
        MapEvaluationTypeContext context = new MapEvaluationTypeContext(this.getExpressionFunctions(), featureTypes);
        this.getConstants().forEach((k, v) -> context.setType(FeatureNames.asConstantFeature(k), v.type()));
        this.rankingConstants().asMap().forEach((k, v) -> context.setType(FeatureNames.asConstantFeature(k), v.getTensorType()));
        for (QueryProfileType queryProfileType : queryProfiles.getTypeRegistry().allComponents()) {
            for (FieldDescription field : queryProfileType.declaredFields().values()) {
                TensorType type = field.getType().asTensorType();
                Optional feature = Reference.simple((String)field.getName());
                if (feature.isEmpty() || !((Reference)feature.get()).name().equals("query")) continue;
                TensorType existingType = context.getType((Reference)feature.get());
                if (!Objects.equals(existingType, context.defaultTypeOf((Reference)feature.get()))) {
                    type = (TensorType)existingType.dimensionwiseGeneralizationWith(type).orElseThrow(() -> new IllegalArgumentException(queryProfileType + " contains query feature " + feature.get() + " with type " + field.getType().asTensorType() + ", but this is already defined in another query profile with type " + context.getType((Reference)feature.get())));
                }
                context.setType((Reference)feature.get(), type);
            }
        }
        for (Map.Entry entry : this.onnxModels().entrySet()) {
            String modelName = (String)entry.getKey();
            OnnxModel model = (OnnxModel)entry.getValue();
            Arguments args = new Arguments((ExpressionNode)new ReferenceNode(modelName));
            Map<String, TensorType> inputTypes = this.resolveOnnxInputTypes(model, context);
            TensorType defaultOutputType = model.getTensorType(model.getDefaultOutput(), inputTypes);
            context.setType(new Reference("onnxModel", args, null), defaultOutputType);
            for (Map.Entry<String, String> mapping : model.getOutputMap().entrySet()) {
                TensorType type = model.getTensorType(mapping.getKey(), inputTypes);
                context.setType(new Reference("onnxModel", args, mapping.getValue()), type);
            }
        }
        return context;
    }

    private Map<String, TensorType> resolveOnnxInputTypes(OnnxModel model, MapEvaluationTypeContext context) {
        HashMap<String, TensorType> inputTypes = new HashMap<String, TensorType>();
        for (String onnxInputName : model.getInputMap().keySet()) {
            this.resolveOnnxInputType(onnxInputName, model, context).ifPresent(type -> inputTypes.put(onnxInputName, (TensorType)type));
        }
        return inputTypes;
    }

    private Optional<TensorType> resolveOnnxInputType(String onnxInputName, OnnxModel model, MapEvaluationTypeContext context) {
        String source = model.getInputMap().get(onnxInputName);
        if (source != null) {
            ExpressionFunction func;
            Optional reference = Reference.simple((String)source);
            if (reference.isPresent()) {
                if (((Reference)reference.get()).name().equals("rankingExpression") && ((Reference)reference.get()).simpleArgument().isPresent()) {
                    source = (String)((Reference)reference.get()).simpleArgument().get();
                } else {
                    return Optional.of(context.getType((Reference)reference.get()));
                }
            }
            if ((func = context.getFunction(source)) != null) {
                return Optional.of(func.getBody().type((TypeContext)context));
            }
        }
        return Optional.empty();
    }

    private void addAttributeFeatureTypes(ImmutableSDField field, Map<Reference, TensorType> featureTypes) {
        Attribute attribute = field.getAttribute();
        field.getAttributes().forEach((k, a) -> {
            String name = k;
            if (attribute == a) {
                name = field.getName();
            }
            featureTypes.put(FeatureNames.asAttributeFeature(name), a.tensorType().orElse(TensorType.empty));
        });
    }

    public static class TypeSettings {
        private final Map<String, String> types = new HashMap<String, String>();

        void addType(String name, String type) {
            this.types.put(name, type);
        }

        public Map<String, String> getTypes() {
            return Collections.unmodifiableMap(this.types);
        }
    }

    public static class MatchPhaseSettings {
        private String attribute = null;
        private boolean ascending = false;
        private int maxHits = 0;
        private double maxFilterCoverage = 0.2;
        private DiversitySettings diversity = null;
        private double evaluationPoint = 0.2;
        private double prePostFilterTippingPoint = 1.0;

        public void setDiversity(DiversitySettings value) {
            value.checkValid();
            this.diversity = value;
        }

        public void setAscending(boolean value) {
            this.ascending = value;
        }

        public void setAttribute(String value) {
            this.attribute = value;
        }

        public void setMaxHits(int value) {
            this.maxHits = value;
        }

        public void setMaxFilterCoverage(double value) {
            this.maxFilterCoverage = value;
        }

        public void setEvaluationPoint(double evaluationPoint) {
            this.evaluationPoint = evaluationPoint;
        }

        public void setPrePostFilterTippingPoint(double prePostFilterTippingPoint) {
            this.prePostFilterTippingPoint = prePostFilterTippingPoint;
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public int getMaxHits() {
            return this.maxHits;
        }

        public double getMaxFilterCoverage() {
            return this.maxFilterCoverage;
        }

        public DiversitySettings getDiversity() {
            return this.diversity;
        }

        public double getEvaluationPoint() {
            return this.evaluationPoint;
        }

        public double getPrePostFilterTippingPoint() {
            return this.prePostFilterTippingPoint;
        }

        public void checkValid() {
            if (this.attribute == null) {
                throw new IllegalArgumentException("match-phase did not set any attribute");
            }
            if (this.maxHits <= 0) {
                throw new IllegalArgumentException("match-phase did not set max-hits > 0");
            }
        }
    }

    public static final class DiversitySettings {
        private String attribute = null;
        private int minGroups = 0;
        private double cutoffFactor = 10.0;
        private Diversity.CutoffStrategy cutoffStrategy = Diversity.CutoffStrategy.loose;

        public void setAttribute(String value) {
            this.attribute = value;
        }

        public void setMinGroups(int value) {
            this.minGroups = value;
        }

        public void setCutoffFactor(double value) {
            this.cutoffFactor = value;
        }

        public void setCutoffStrategy(Diversity.CutoffStrategy strategy) {
            this.cutoffStrategy = strategy;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public int getMinGroups() {
            return this.minGroups;
        }

        public double getCutoffFactor() {
            return this.cutoffFactor;
        }

        public Diversity.CutoffStrategy getCutoffStrategy() {
            return this.cutoffStrategy;
        }

        void checkValid() {
            if (this.attribute == null || this.attribute.isEmpty()) {
                throw new IllegalArgumentException("'diversity' did not set non-empty diversity attribute name.");
            }
            if (this.minGroups <= 0) {
                throw new IllegalArgumentException("'diversity' did not set min-groups > 0");
            }
            if (this.cutoffFactor < 1.0) {
                throw new IllegalArgumentException("diversity.cutoff.factor must be larger or equal to 1.0.");
            }
        }
    }

    public static class RankingExpressionFunction {
        private ExpressionFunction function;
        private final boolean inline;

        RankingExpressionFunction(ExpressionFunction function, boolean inline) {
            this.function = function;
            this.inline = inline;
        }

        public void setReturnType(TensorType type) {
            this.function = this.function.withReturnType(type);
        }

        public ExpressionFunction function() {
            return this.function;
        }

        public boolean inline() {
            return this.inline && this.function.arguments().isEmpty();
        }

        RankingExpressionFunction withExpression(RankingExpression expression) {
            return new RankingExpressionFunction(this.function.withBody(expression), this.inline);
        }

        public String toString() {
            return "function " + this.function;
        }
    }

    public static class RankProperty
    implements Serializable {
        private final String name;
        private final String value;

        public RankProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.name.hashCode() + 17 * this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RankProperty)) {
                return false;
            }
            RankProperty other = (RankProperty)object;
            return other.name.equals(this.name) && other.value.equals(this.value);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }
    }

    public static class RankSetting
    implements Serializable {
        private final String fieldName;
        private final Type type;
        private final Object value;

        public RankSetting(String fieldName, Type type, Object value) {
            this.fieldName = fieldName;
            this.type = type;
            this.value = value;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Type getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public int getIntValue() {
            if (this.value instanceof Integer) {
                return (Integer)this.value;
            }
            return -1;
        }

        public int hashCode() {
            return this.fieldName.hashCode() + 17 * this.type.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof RankSetting)) {
                return false;
            }
            RankSetting other = (RankSetting)object;
            return this.fieldName.equals(other.fieldName) && this.type.equals((Object)other.type);
        }

        public String toString() {
            return this.type + " setting " + this.fieldName + ": " + this.value;
        }

        public static enum Type {
            RANKTYPE("rank-type"),
            LITERALBOOST("literal-boost"),
            WEIGHT("weight"),
            PREFERBITVECTOR("preferbitvector", true);

            private final String name;
            private final boolean isIndexLevel;

            private Type(String name) {
                this(name, false);
            }

            private Type(String name, boolean isIndexLevel) {
                this.name = name;
                this.isIndexLevel = isIndexLevel;
            }

            public boolean isIndexLevel() {
                return this.isIndexLevel;
            }

            public String getName() {
                return this.name;
            }

            public String toString() {
                return "type: " + this.name;
            }
        }
    }

    public static class ExecuteOperation {
        final Phase phase;
        final String attribute;
        final String operation;

        ExecuteOperation(Phase phase, String attribute, String operation) {
            this.phase = phase;
            this.attribute = attribute;
            this.operation = operation;
        }

        public static enum Phase {
            onmatch,
            onrerank,
            onsummary;

        }
    }

    private static class CachedFunctions {
        private final Map<String, RankingExpressionFunction> allRankingExpressionFunctions;
        private final ImmutableMap<String, ExpressionFunction> allExpressionFunctions;

        CachedFunctions(Map<String, RankingExpressionFunction> functions) {
            this.allRankingExpressionFunctions = functions;
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            for (Map.Entry<String, RankingExpressionFunction> entry : functions.entrySet()) {
                ExpressionFunction function = entry.getValue().function();
                mapBuilder.put((Object)function.getName(), (Object)function);
            }
            this.allExpressionFunctions = mapBuilder.build();
        }
    }
}

