/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.deploy;

import com.yahoo.searchdefinition.Schema;
import com.yahoo.searchdefinition.SearchBuilder;
import com.yahoo.vespa.documentmodel.DocumentModel;
import com.yahoo.vespa.model.search.NamedSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchDocumentModel {
    private final DocumentModel documentModel;
    private final List<NamedSchema> schemas;

    public SearchDocumentModel(DocumentModel documentModel, List<NamedSchema> schemas) {
        this.documentModel = documentModel;
        this.schemas = schemas;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public List<NamedSchema> getSchemas() {
        return this.schemas;
    }

    public static SearchDocumentModel fromBuilderAndNames(SearchBuilder builder, Map<String, String> names) {
        ArrayList<NamedSchema> ret = new ArrayList<NamedSchema>();
        for (Schema schema : builder.getSearchList()) {
            ret.add(new NamedSchema(names.get(schema.getName()), schema));
        }
        return new SearchDocumentModel(builder.getModel(), ret);
    }

    public static SearchDocumentModel fromBuilder(SearchBuilder builder) {
        ArrayList<NamedSchema> ret = new ArrayList<NamedSchema>();
        for (Schema schema : builder.getSearchList()) {
            ret.add(new NamedSchema(schema.getName(), schema));
        }
        return new SearchDocumentModel(builder.getModel(), ret);
    }
}

