/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains.docproc;

import com.yahoo.collections.Pair;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainedComponentModelBuilder;
import com.yahoo.vespa.model.container.docproc.model.DocumentProcessorModel;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class DocumentProcessorModelBuilder
extends ChainedComponentModelBuilder {
    private Map<Pair<String, String>, String> fieldNameSchemaMap = new HashMap<Pair<String, String>, String>();

    public DocumentProcessorModelBuilder(Element spec) {
        super(spec);
        this.readFieldNameSchemaMap(spec);
    }

    private void readFieldNameSchemaMap(Element spec) {
        this.fieldNameSchemaMap = DocumentProcessorModelBuilder.parseFieldNameSchemaMap(spec);
    }

    @Override
    public DocumentProcessorModel build() {
        return new DocumentProcessorModel(this.bundleInstantiationSpec, this.dependencies, this.fieldNameSchemaMap);
    }

    public static Map<Pair<String, String>, String> parseFieldNameSchemaMap(Element e) {
        HashMap<Pair<String, String>, String> ret = new HashMap<Pair<String, String>, String>();
        for (Element sm : XML.getChildren((Element)e, (String)"map")) {
            for (Element fm : XML.getChildren((Element)sm, (String)"field")) {
                String from = fm.getAttribute("in-document");
                String to = fm.getAttribute("in-processor");
                String doctype = fm.getAttribute("doctype");
                if ("".equals(doctype)) {
                    doctype = null;
                }
                ret.put((Pair<String, String>)new Pair((Object)doctype, (Object)from), to);
            }
        }
        return ret;
    }
}

