/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.builder.xml.ConfigModelBuilder;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.messagebus.routing.ApplicationSpec;
import com.yahoo.messagebus.routing.HopSpec;
import com.yahoo.messagebus.routing.RouteSpec;
import com.yahoo.messagebus.routing.RoutingSpec;
import com.yahoo.messagebus.routing.RoutingTableSpec;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.routing.Routing;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomRoutingBuilder
extends ConfigModelBuilder<Routing> {
    public DomRoutingBuilder() {
        super(Routing.class);
    }

    @Override
    public List<ConfigModelId> handlesElements() {
        return Arrays.asList(ConfigModelId.fromName("routing"));
    }

    @Override
    public void doBuild(Routing plugin, Element spec, ConfigModelContext modelContext) {
        ApplicationSpec app = null;
        RoutingSpec routing = null;
        if (spec != null) {
            app = new ApplicationSpec();
            for (Element node : Xml.mergeElems((Element)spec, (String)"services", (ApplicationPackage)modelContext.getApplicationPackage(), (String)"routing/tables")) {
                DomRoutingBuilder.addServices(app, node);
            }
            routing = new RoutingSpec();
            for (Element node : Xml.mergeElems((Element)spec, (String)"routingtable", (ApplicationPackage)modelContext.getApplicationPackage(), (String)"routing/tables")) {
                DomRoutingBuilder.addRoutingTable(routing, node);
            }
        }
        plugin.setExplicitApplicationSpec(app);
        plugin.setExplicitRoutingSpec(routing);
    }

    private static void addServices(ApplicationSpec app, Element element) {
        String protocol = element.getAttribute("protocol");
        for (Element node : XML.getChildren((Element)element, (String)"service")) {
            app.addService(protocol, node.getAttribute("name"));
        }
    }

    private static void addRoutingTable(RoutingSpec routing, Element element) {
        boolean verify = element.hasAttribute("verify") ? Boolean.valueOf(element.getAttribute("verify")) : true;
        RoutingTableSpec table = new RoutingTableSpec(element.getAttribute("protocol"), verify);
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if ("hop".equals(node.getNodeName())) {
                table.addHop(DomRoutingBuilder.createHopSpec((Element)node));
                continue;
            }
            if (!"route".equals(node.getNodeName())) continue;
            table.addRoute(DomRoutingBuilder.createRouteSpec((Element)node));
        }
        routing.addTable(table);
    }

    private static RouteSpec createRouteSpec(Element element) {
        boolean verify = element.hasAttribute("verify") ? Boolean.valueOf(element.getAttribute("verify")) : true;
        RouteSpec route = new RouteSpec(element.getAttribute("name"), verify);
        String hops = element.getAttribute("hops");
        int from = 0;
        int depth = 0;
        int len = hops.length();
        for (int to = 0; to < len; ++to) {
            if (hops.charAt(to) == '[') {
                ++depth;
                continue;
            }
            if (hops.charAt(to) == ']') {
                --depth;
                continue;
            }
            if (hops.charAt(to) != ' ' || depth != 0) continue;
            if (to > from) {
                route.addHop(hops.substring(from, to));
            }
            from = to + 1;
        }
        if (from < hops.length()) {
            route.addHop(hops.substring(from));
        }
        return route;
    }

    private static HopSpec createHopSpec(Element element) {
        boolean verify = element.hasAttribute("verify") ? Boolean.valueOf(element.getAttribute("verify")) : true;
        HopSpec hop = new HopSpec(element.getAttribute("name"), element.getAttribute("selector"), verify);
        if (Boolean.valueOf(element.getAttribute("ignore-result")).booleanValue()) {
            hop.setIgnoreResult(true);
        }
        NodeList children = element.getElementsByTagName("recipient");
        for (int i = 0; i < children.getLength(); ++i) {
            Element node = (Element)children.item(i);
            hop.addRecipient(node.getAttribute("session"));
        }
        return hop;
    }
}

