/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Optional;

public class PagedAttributeValidator
extends Processor {
    public PagedAttributeValidator(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            for (Attribute attribute : field.getAttributes().values()) {
                if (!attribute.isPaged()) continue;
                this.validatePagedSetting(field, attribute);
            }
        }
    }

    private void validatePagedSetting(Field field, Attribute attribute) {
        Optional<TensorType> tensorType = attribute.tensorType();
        if (!tensorType.isPresent() || !this.isDenseTensorType(tensorType.get())) {
            this.fail(this.search, field, "The 'paged' attribute setting is only supported for dense tensor types");
        }
    }

    private boolean isDenseTensorType(TensorType type) {
        return type.dimensions().stream().allMatch(d -> d.isIndexed());
    }
}

