/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.vespa.model.AbstractService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RankingConstants {
    private final Map<String, RankingConstant> constants = new ConcurrentHashMap<String, RankingConstant>();
    private final FileRegistry fileRegistry;

    public RankingConstants(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    public void add(RankingConstant constant) {
        constant.validate();
        constant.register(this.fileRegistry);
        String name = constant.getName();
        RankingConstant prev = this.constants.putIfAbsent(name, constant);
        if (prev != null) {
            throw new IllegalArgumentException("Ranking constant '" + name + "' defined twice");
        }
    }

    public void putIfAbsent(RankingConstant constant) {
        constant.validate();
        constant.register(this.fileRegistry);
        String name = constant.getName();
        this.constants.putIfAbsent(name, constant);
    }

    public void computeIfAbsent(String name, Function<? super String, ? extends RankingConstant> createConstant) {
        this.constants.computeIfAbsent(name, (? super K key) -> {
            RankingConstant constant = (RankingConstant)createConstant.apply((String)key);
            constant.validate();
            constant.register(this.fileRegistry);
            return constant;
        });
    }

    public RankingConstant get(String name) {
        return this.constants.get(name);
    }

    public Map<String, RankingConstant> asMap() {
        return Collections.unmodifiableMap(this.constants);
    }

    public void sendTo(Collection<? extends AbstractService> services) {
        this.constants.values().forEach(constant -> constant.sendTo(services));
    }
}

