/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Handler<CHILD extends AbstractConfigProducer<?>>
extends Component<CHILD, ComponentModel> {
    private final Set<BindingPattern> serverBindings = new LinkedHashSet<BindingPattern>();
    private final List<BindingPattern> clientBindings = new ArrayList<BindingPattern>();

    public Handler(ComponentModel model) {
        super(model);
    }

    public static Handler<AbstractConfigProducer<?>> fromClassName(String className) {
        return new Handler(new ComponentModel(className, null, null, null));
    }

    public void addServerBindings(BindingPattern ... bindings) {
        this.serverBindings.addAll(Arrays.asList(bindings));
    }

    public void removeServerBinding(BindingPattern binding) {
        this.serverBindings.remove(binding);
    }

    public void addClientBindings(BindingPattern ... bindings) {
        this.clientBindings.addAll(Arrays.asList(bindings));
    }

    public final Set<BindingPattern> getServerBindings() {
        return Collections.unmodifiableSet(this.serverBindings);
    }

    public final List<BindingPattern> getClientBindings() {
        return Collections.unmodifiableList(this.clientBindings);
    }
}

