/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.admin.metricsproxy.MetricsProxyContainerCluster;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.SimpleComponent;

class DefaultThreadpoolProvider
extends SimpleComponent
implements ThreadpoolConfig.Producer {
    private final ContainerCluster<?> cluster;
    private final int metricsproxyNumThreads;

    DefaultThreadpoolProvider(ContainerCluster<?> cluster, int metricsproxyNumThreads) {
        super(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)"default-threadpool", (String)ThreadPoolProvider.class.getName(), null)));
        this.cluster = cluster;
        this.metricsproxyNumThreads = metricsproxyNumThreads;
    }

    private int defaultThreadsByClusterType() {
        if (this.cluster instanceof MetricsProxyContainerCluster) {
            return this.metricsproxyNumThreads;
        }
        return 10;
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        if (!(this.cluster instanceof ApplicationContainerCluster)) {
            int defaultWorkerThreads = this.defaultThreadsByClusterType();
            builder.maxthreads(defaultWorkerThreads);
            builder.corePoolSize(defaultWorkerThreads);
            builder.queueSize(50);
            return;
        }
        double vcpu = this.cluster.vcpu().orElse(0.0);
        if (vcpu == 0.0) {
            return;
        }
        int workerThreads = Math.max(8, (int)Math.ceil(vcpu * 2.0));
        builder.maxthreads(workerThreads);
        builder.corePoolSize(workerThreads);
        builder.queueSize((int)((double)workerThreads * 40.0));
    }
}

