/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.dependencies.Dependencies;
import com.yahoo.component.chain.model.ChainedComponentModel;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.http.filter.security.rule.RuleBasedFilterConfig;
import com.yahoo.vespa.model.container.http.Filter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BlockFeedGlobalEndpointsFilter
extends Filter
implements RuleBasedFilterConfig.Producer {
    private final Set<ContainerEndpoint> endpoints;
    private final boolean dryRun;

    public BlockFeedGlobalEndpointsFilter(Set<ContainerEndpoint> endpoints, boolean dryRun) {
        super(BlockFeedGlobalEndpointsFilter.createFilterComponentModel());
        this.endpoints = Set.copyOf(endpoints);
        this.dryRun = dryRun;
    }

    public void getConfig(RuleBasedFilterConfig.Builder builder) {
        Set hostNames = this.endpoints.stream().flatMap(e -> e.names().stream()).collect(Collectors.toSet());
        if (hostNames.size() > 0) {
            RuleBasedFilterConfig.Rule.Builder rule = new RuleBasedFilterConfig.Rule.Builder().hostNames(hostNames).pathExpressions("/reserved-for-internal-use/{*}").pathExpressions("/document/v1/{*}").methods(List.of(RuleBasedFilterConfig.Rule.Methods.Enum.PUT, RuleBasedFilterConfig.Rule.Methods.Enum.POST, RuleBasedFilterConfig.Rule.Methods.Enum.DELETE)).action(RuleBasedFilterConfig.Rule.Action.Enum.BLOCK).name("block-feed-global-endpoints").blockResponseMessage("Feed to global endpoints are not allowed").blockResponseCode(405).blockResponseHeaders(new RuleBasedFilterConfig.Rule.BlockResponseHeaders.Builder().name("Allow").value("GET, OPTIONS, HEAD"));
            builder.rule(rule);
        }
        builder.dryrun(this.dryRun);
        builder.defaultRule.action(RuleBasedFilterConfig.DefaultRule.Action.Enum.ALLOW);
    }

    private static ChainedComponentModel createFilterComponentModel() {
        return new ChainedComponentModel(new BundleInstantiationSpecification(new ComponentSpecification("com.yahoo.jdisc.http.filter.security.rule.RuleBasedRequestFilter"), null, new ComponentSpecification("jdisc-security-filters")), Dependencies.emptyDependencies());
    }
}

