/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.cluster.ContentCluster;

public class StorServerProducer
implements StorServerConfig.Producer {
    private String clusterName;
    private Integer maxMergesPerNode;
    private Integer queueSize;
    private Integer bucketDBStripeBits;

    private StorServerProducer setMaxMergesPerNode(Integer value) {
        if (value != null) {
            this.maxMergesPerNode = value;
        }
        return this;
    }

    private StorServerProducer setMaxQueueSize(Integer value) {
        if (value != null) {
            this.queueSize = value;
        }
        return this;
    }

    private StorServerProducer setBucketDBStripeBits(Integer value) {
        this.bucketDBStripeBits = value;
        return this;
    }

    StorServerProducer(String clusterName, ModelContext.FeatureFlags featureFlags) {
        this.clusterName = clusterName;
        this.maxMergesPerNode = featureFlags.maxConcurrentMergesPerNode();
        this.queueSize = featureFlags.maxMergeQueueSize();
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.root_folder("");
        builder.is_distributor(false);
        if (this.clusterName != null) {
            builder.cluster_name(this.clusterName);
        }
        if (this.maxMergesPerNode != null) {
            builder.max_merges_per_node(this.maxMergesPerNode.intValue());
        }
        if (this.queueSize != null) {
            builder.max_merge_queue_size(this.queueSize.intValue());
        }
        if (this.bucketDBStripeBits != null) {
            builder.content_node_bucket_db_stripe_bits(this.bucketDBStripeBits.intValue());
        }
    }

    public static class Builder {
        StorServerProducer build(ModelContext.Properties properties, ModelElement element) {
            ModelElement tuning = element.child("tuning");
            StorServerProducer producer = new StorServerProducer(ContentCluster.getClusterId(element), properties.featureFlags());
            if (tuning == null) {
                return producer;
            }
            ModelElement merges = tuning.child("merges");
            if (merges == null) {
                return producer;
            }
            producer.setMaxMergesPerNode(merges.integerAttribute("max-per-node")).setMaxQueueSize(merges.integerAttribute("max-queue-size"));
            return producer;
        }
    }
}

